  function newcell=crtcell ( x, rownam, colnam, tit , dec)  
% function newcell=crtcell ( x, rownam, colnam, tit , dec );  
% This function will create a new cell with 
% the cells /strings in tit at the top 
% and input x in the rest of the cell 
%
% Inputs
% -------
% x is an [m x n ]  matrix x or cell
%                        if matrix it  will be converted to cell with 4
%                       decimals of precision 
% tit   string otr cell
%       string can only be unidimensional 
% dec   Number of decimal points for the conversion
% 
% Output
% newcell 
% 
% Alejandro Justiniano 4/3/2005 
% MISSING: addition of dline option to divide title 
% -------------------------------------------------

if nargin < 5 || isempty(dec) 
    dec=4; 
end
    
% Matrix input 
% --------------
[r,c] = size( x ); 
if iscell( x ) == 0 
    x = num2cprec( x,dec) ; 
end 

% Determine if two add  title or not 
% ---------------------------------------
if nargin < 4 | isempty( tit ) == 1 
    
    flag_tit = 0; 
    
else 
    
    flag_tit = 1; 
    
    [m,n] = size( tit ); 
    if isstr( tit ) == 1 
        flag_str = 1 ;
        if m > 1 & n > 1 
            error('tit must be a cell for multiple strings') 
        end 
        ctwo = 1 ; 
    else 
        flag_str = 0 ; 
        if iscell( tit ) == 0 
            error('tit must be a cell if more than one dimension or string for single dimension') 
        end 
        tit=( tit(:) )'; 
        ctwo = size( tit , 2 ); 
    end 
    clear m n; 
end 

% Determine if to add column names or not 
% --------------------------------------------------
if nargin < 3 | isempty( colnam ) == 1 
    flag_col = 0 ; 
else 
    flag_col = 1; 
    colnam = ( colnam(:) )'; 
    if size( colnam ,2 ) ~= c  
        error('Cells in colname must match number of columns in x' ) 
    end 
end 

if nargin < 2 | isempty( rownam ) == 1
    flag_row = 0 ; 
else 
    flag_row = 1; 
    rownam=rownam(:); 
    if size( rownam, 1) ~= r  
        error('Cells in rownam must match number of rows in x' ) 
    end 
end 

% New row dimension 
% -------------------------
rnew = r + flag_tit + flag_col ; 
rstart = flag_tit + flag_col; 

cnew = c + flag_row; 
if flag_tit ==1 
    cnew = max( cnew, ctwo ); 
end 

% Create new cell 
% ===========
newcell=emptycell( rnew , cnew);

% Add title 
if flag_tit ==1 
    if flag_str == 1 
        newcell( 1,1 ) = { tit } ; 
    else 
        newcell( 1, 1:ctwo ) = tit ; 
    end 
end 

% Add columne names 
if flag_col == 1 
    newcell( flag_tit + 1 , flag_row+1:flag_row + c ) = colnam ;
end 

% Add row names 
if flag_row == 1 
    newcell( rstart + 1:end , 1 ) = rownam ; 
end 

% Add the matrix 
newcell( rstart + 1:end, flag_row+1: flag_row + c ) = x ; 


    


