%figure1.m
% This program creates a plain-vanilla version of Figure 1.

% Load the relevant data from gssTable5Recreation.xlsx
[~, ~, rawData]=xlsread('../GSSAnalysis/gssTable5Recreation.xlsx','Aug07_Dec11 with Outlier','B3:H42');
[~, ~, rawDates]=xlsread('../GSSAnalysis/gssTable5Recreation.xlsx','Aug07_Dec11 with Outlier','A3:A42');

data=cell2mat(rawData);
dates=datenum(rawDates,'mm/dd/yyyy');

pathFactor=data(:,2);
yield10year=data(:,5);

%Identify LSAPs.
LSAPDateStrings=cell(7,1);
LSAPDateStrings{1,1}='11/25/2008';
LSAPDateStrings{2,1}='12/16/2008';
LSAPDateStrings{3,1}='1/28/2009';
LSAPDateStrings{4,1}='3/18/2009';
LSAPDateStrings{5,1}='8/10/2010';
LSAPDateStrings{6,1}='9/21/2010';
LSAPDateStrings{7,1}='11/3/2010';

LSAPDates=datenum(LSAPDateStrings,'mm/dd/yyyy');

%Determine which observations correspond to LSAPs.
dates=repmat(dates,1,size(LSAPDates,1));
LSAPDates=repmat(LSAPDates',size(dates,1),1);
LSAPIndicator=any(dates==LSAPDates,2);
%Plot the LSAP dates.
plot(yield10year(LSAPIndicator),pathFactor(LSAPIndicator),'or','MarkerSize',10,'MarkerFaceColor','r');
hold
%Plot the other dates.
plot(yield10year(~LSAPIndicator),pathFactor(~LSAPIndicator),'ob','MarkerSize',10,'MarkerFaceColor','b');
%Set the background color to white and turn the box around the plot off.
set(gcf,'color',[1 1 1]);
box off;
%Add a legend.
legend({'LSAP Announcement';'Other FOMC Statements'},'FontSize',20);
legend('boxoff');
%Set the fontsize and place tick marks.
set(gca,'FontSize',20);
set(gca,'XTick',[-60 -40 -20 0 20]);
set(gca,'XLim',[-60 25]);
set(gca,'YTick',[-40 -20 0 20 40]);
set(gca,'YLim',[-40 40]);

%Label the axes.
xlabel('Change in 10-Year Note');
ylabel('Path Factor');

%Add annotations to the QE1 and QE2 announcement dates.
QE1date=datenum(LSAPDateStrings{4,1});
QE2date=datenum(LSAPDateStrings{7,1});
dates=dates(:,1);
QE1Location=[yield10year(dates==QE1date) pathFactor(dates==QE1date)];
QE2Location=[yield10year(dates==QE2date) pathFactor(dates==QE2date)];

annotation1Location=QE1Location;
annotation1Location(1)=(annotation1Location(1)+60)/85;
annotation1Location(2)=(annotation1Location(2)+40)/80;
annotation2Location=QE2Location;
annotation2Location(1)=(annotation2Location(1)+60)/85;
annotation2Location(2)=(annotation2Location(2)+40)/80;

annotation('textbox',[annotation1Location(1)+0.125 annotation1Location(2)-0.045 0.5 0.01],'String',['QE1 ' LSAPDateStrings{4,1}],...
    'EdgeColor','none','FontSize',20);
annotation('textarrow',[annotation2Location(1)-0.04 annotation2Location(1)-0.04], [annotation2Location(2)+0.15 annotation2Location(2)+0.02],...
    'String',['QE2 ' LSAPDateStrings{7,1}],'FontSize',20);

%Resize the figure and save it to a .pdf file.
set(gcf,'Position',[-3 5 1280 950],...
    'PaperUnits','in','PaperSize',[17 11],'PaperPositionMode','manual','PaperPosition',[0 0 17 11]);
%cd ../GSSFigures; 
print('-dpdf','Figure1.pdf');
