%%Table5.m
% This program writes the contents of Table 5 in the paper, reading the
% results from the spreadsheets created by GSSMain.m

%Retrieve results from the first sample, 1-February-1990 through
%1-July-2007.

results=xlsread('sample3Results','moments','B9:C15');


%Create a column of row names.
rowNames=cell(7,1);
rowNames{1,1}='Current quarter';
rowNames{2,1}='Next quarter';
rowNames{3,1}='Two quarters hence';
rowNames{4,1}='Three quarters hence';
rowNames{5,1}='Four quarters hence';
rowNames{6,1}='Five quarters hence';
rowNames{7,1}='Six quarters hence';

%Open the output file for writing.
f1=fopen('Table5.tex','w');

%Write each of the output file's cells.
for i=1:7;
    fprintf(f1,rowNames{i,1});
    for j=1:2
        if results(i,j)>=10
            fprintf(f1,' & %2.0f',results(i,j));
        else
            fprintf(f1,' & \\makebox[6pt][l]{}%1.0f',results(i,j));
        end
    end
    fprintf(f1,'\\\\ \n');
end

fclose(f1);