%%Table1.m
% This program writes the contents of Table 1 in the paper, reading the
% results from the spreadsheets created by GSSMain.m

%Retrieve results from the first sample, 1-February-1990 through
%1-July-2007.

sample1Results=xlsread('sample1Results','moments','B9:C15');

%Retrieve results from the second sample, 1-February 1994 through
%1-July-2007.

sample2Results=xlsread('sample2Results','moments','B9:C15');

results=[sample1Results sample2Results];

%Create a column of row names.
rowNames=cell(5,1);
rowNames{1,1}='Current quarter';
rowNames{2,1}='Next quarter';
rowNames{3,1}='Two quarters hence';
rowNames{4,1}='Three quarters hence';
rowNames{5,1}='Four quarters hence';

%Open the output file for writing.
f1=fopen('Table1.tex','w');

%Write each of the output file's cells.
for i=1:5;
    fprintf(f1,rowNames{i,1});
    for j=1:4
        if results(i,j)>=10
            fprintf(f1,' & %2.0f',results(i,j));
        else
            fprintf(f1,' & \\makebox[6pt][l]{}%1.0f',results(i,j));
        end
    end
    fprintf(f1,'\\\\ \n');
end

fclose(f1);


