function outSt=minStlsqnonlin(x0,etaT,minproblem,minforc)
% outSt=minStlsqnonlin(x0,etaT,minproblem,minforc)
%
%% Given the initial guess x0 and the vector of shocks etaT, 
% minimize the SSR of the conditional forecast problem. 
% Structure minproblem contains all details of the minimization
% particularly in the .options field 
%
%% Structure outSt 
% .xstar, minimizer shock 
% .rernorm 
% .residual 
% .exitflag
% .output 
% 
% AJ March 6 2012 
%% NLLSQ minimization 
[xstar,resnorm,residual,exitflag,output]=lsqnonlin(@minObsSub,x0,[],[],minproblem.options);
%% Output
outSt.xstar=xstar; 
outSt.resnorm=resnorm; 
outSt.residual=residual; 
outSt.exitflag=exitflag; 
outSt.output=output; 
%% Subfunction     
    function  fval=minObsSub(x)
        % fval is function with differences between model and data
        fval=zeros(minforc.Nmatch,1);
        % Plug in guess into vector of shocks
        etaT(minforc.innovPos)=x;
        % Generate one step ahead forecast
        if isempty(minforc.signalShutPos)==false;
            minforc.sTMinusOne(minforc.signalShutPos)=0;
        end
        if isempty(minforc.shockShut)==false;
            etaT(minforc.shockShut)=0;
        end
        sT=minforc.G*minforc.sTMinusOne(:)+minforc.R*etaT(:);
        %yT=minforc.Z*(minforc.C+sT);
        % Compute the differences
        fval(:)=sT(minforc.matchPos)-minforc.matchTarget(:);                
    end
end