function fval=minStateDiscrep(x,minforc,etaT) 
%% minStateDiscrep 
%  Minimize the distance beteween the a subset of the state vector, given
%  in minforc.matchPos and a set of target values given in
%  minforc.matchTarget 
%  etaT is the set of shocks at time T 
%  x is the value of a subset of the shocks 
%  fval=minStateDiscrep(x,minforc,etaT) 
%  fval is the difference between the state and the target 
%  Use with lsqnonlin 
%  AJ March 6 2012 
%% fval is function with differences between model and data
fval=zeros(minforc.Nmatch,1); 
%% Plug in guess into vector of shocks 
%etaT=minforc.innovT(:); 
etaT(minforc.innovPos)=x; 
%% Generate one step ahead forecast
if isempty(minforc.signalShutPos)==false;
    minforc.sTMinusOne(minforc.signalShutPos)=0;
end
if isempty(minforc.shockShut)==false; 
    etaT(minforc.shockShut)=0; 
end 
sT=minforc.G*minforc.sTMinusOne(:)+minforc.R*etaT(:); 
yT=minforc.Z*(minforc.C+sT); 
%% Compute the differences 
fval(:)=sT(minforc.matchPos)-minforc.matchTarget(:); 
