version 11.0
set more off
use "democraticchangedata.dta", clear


***generating Arab Conquest***
gen arabconquest=islam1100*half1900
replace arabconquest=0 if country=="Israel" 

***generating non-Arab League, Arab conquest***
gen nonarabarabconquest=arabconquest*((arableague-1)*-1)


log using "REPLICATION_CROSSSECTION.smcl", replace
***************
*** TABLE 1 ***
***************

/*Arab League Countries in 2010*/
tab country if arableague==1
/*Arab Conquest Countries*/
tab country if arabconquest>=0.5
/*Non Arab League Countries, Arab Conquest Countries*/
tab country if arabconquest>=0.5 & arableague==0
/*Muslim Majority, Non Arab League Countries, Non Arab Conquest Countries*/
tab country if arabconquest<0.5 & arableague==0 & muslimmajority==1


***************
*** TABLE 2 ***
***************
* Col 1
reg normpolity muslimmajority, r
* Col 2
reg normpolity muslimmajority arableague, r
* Col 3
reg normpolity muslimmajority arableague arabconquest, r
* Col 4
reg normpolity muslimmajority arableague arabconquest fuel oceania europe asia americas africa, r
* Col 5
reg normpolity muslimmajority arableague nonarabarabconquest fuel oceania europe asia americas africa, r
test arableague=nonarabarabconquest
* Col 6
reg normfree muslimmajority arableague nonarabarabconquest fuel oceania europe asia americas africa, r
test arableague=nonarabarabconquest
/*Col 7: Muslim majority world */
reg normpolity arableague arabconquest fuel oceania europe asia americas africa if muslimmajority==1, r
/*Col 8: Countries with 0.8 Muslim share*/
reg normpolity arableague arabconquest fuel oceania europe asia americas africa if pmuslim>0.8, r

***************
*** TABLE 3 ***
***************

/*Col 1: Baseline*/
reg normpolity arabconquest muslimmajority fuel oceania europe asia americas africa, r
*Col 2
reg normpolity arabconquest muslimmajority religiosity fuel oceania europe asia americas africa, r
*Col 3
reg normpolity arabconquest muslimmajority womeninparl  fuel oceania europe asia americas africa, r
*Col 4
reg normpolity arabconquest muslimmajority fertility fuel oceania europe asia americas africa, r
/*Col 5: Muslim majority world */
reg normpolity arabconquest religiosity fuel  oceania europe asia americas africa if muslimma==1, r
/*Col 6: Muslim majority world */
reg normpolity arabconquest alcohol fuel  oceania europe asia americas africa if muslimma==1, r


***************
*** TABLE 4 ***
***************
*Col 1
reg normpolity arabconquest muslimmajority  fuel oceania europe asia americas africa, r
*Col 2
reg normpolity arabconquest muslimmajority  lrain fuel oceania europe asia americas africa, r
gen lrain2=lrain^2
gen lrain3=lrain^3
*Col 3
reg normpolity arabconquest muslimmajority  lrain lrain2 lrain3 fuel oceania europe asia americas africa, r
*Col 4
reg normpolity arabconquest muslimmajority  desert fuel oceania europe asia americas africa, r
*Col 5
reg normpolity arabconquest muslimmajority  cereal fuel oceania europe asia americas africa, r

***************
*** TABLE 5 ***
***************

/*Col 1 of panels A and B*/
ivregress 2sls normpolity (arabconquest=mecca) muslimmajority fuel oceania europe asia americas africa, first r
/*Col 1 of Panel C*/
reg normpolity muslimmajority arabconquest fuel oceania europe asia americas africa, robust
/*Col 2 of panels A and B*/
ivregress 2sls normpolity (arabconquest=lrain) muslimmajority fuel oceania europe asia americas africa, first r
/*Col 2 and 3 of Panel C*/
reg normpolity muslimmajority arabconquest fuel oceania europe asia americas africa if lrain!=., r
/*Col 3 of panels A and B*/
ivregress 2sls normpolity (arabconquest=lrain mecca) muslimmajority fuel oceania europe asia americas africa, first r
/*Col 3 of panel D*/
estat overid
/*Col 4 of panels A and B*/
ivregress 2sls normpolity (arabconquest=mecca)  fuel oceania europe asia americas africa if muslimma==1, first r
/*Col 4 of Panel C*/
reg normpolity arabconquest fuel oceania europe asia americas africa  if muslimma==1, r
/*Col 5 of panels A and B*/
ivregress 2sls normpolity (arabconquest=lrain) fuel oceania europe asia americas africa if muslimma==1, first r
/*Col 5 and 6 of Panel C*/
reg normpolity arabconquest fuel oceania europe asia americas africa  if muslimma==1 & lrain!=., r
/*Col 6 of panels A and B*/
ivregress 2sls normpolity (arabconquest=lrain mecca)  fuel oceania europe asia americas africa if muslimma==1, first robust
/*Col 6 of panel D*/
estat overid


***************
*** TABLE 6 ***
***************
*Col 1
reg  govtexp arabconquest muslimmajority fuel oceania europe asia americas africa, r
*Col 2
reg  govtexp arabconquest muslimmajority fuel normpolity oceania europe asia americas africa, r
*Col 3
reg  govtexp arabconquest muslimmajority fuel arableague oceania europe asia americas africa, r
*Col 4
reg  accesstocredit arabconquest muslimmajority fuel oceania europe asia americas africa, r
*Col 5
reg  accesstocredit arabconquest muslimmajority fuel normpolity oceania europe asia americas africa, r
*Col 6
reg  accesstocredit arabconquest muslimmajority fuel arableague oceania europe asia americas africa, r
*Col 7
reg  tradeunions arabconquest muslimmajority fuel oceania europe asia americas africa, r
*Col 8
reg  tradeunions arabconquest muslimmajority fuel normpolity oceania europe asia americas africa, r
*Col 9
reg  tradeunions arabconquest muslimmajority fuel arableague oceania europe asia americas africa, r


***************
*** TABLE 7 ***
***************
gen uprising=(country=="Egypt" | country=="Yemen" | country=="Libya" | country=="Syria" | country=="Tunisia" | country=="Bahrain")  
*Col 1
reg uprising thriving2010 if arableague==1, r
*Col 2
reg uprising noyouth2010  if arableague==1, r
*Col 3
reg uprising unemp2010 if arableague==1, r
*Col 4
reg uprising fertilitydif if arableague==1, r
*Col 5
reg uprising fertility if arableague==1, r


**************************************************************************************************************
*** TABLE 8: Due to my agreement with Gallup, I cannot share the underlying data used to construct table 8 ***
**************************************************************************************************************



****************
*** Figure 3 ***
****************
reg normpolity lrain, r
predict nhat
reg normpolity lrain if arabconquest<0.5, r
predict nhat2


twoway (line nhat lrain,   saving(r1)) (scatter normpolity lrain if arabconquest<0.5, msymbol(i)  mlabel(countrycode)) (scatter normpolity lrain if arabconquest>=0.5,  title("") note("[N=158; b=0.13; se=0.02]")  mlabel(countrycode) ytitle("Normalized Polity Score") xtitle("ln(Rain)") legend(off)  scheme(sj)  scale(0.8)  graphregion(fcolor(white)))
twoway (line nhat2 lrain,  saving(r2)) (scatter normpolity lrain if arabconquest<0.5, msymbol(i)  mlabel(countrycode) title("") note("[N=130; b=-0.04; se=0.04]")  mlabel(countrycode) ytitle("Normalized Polity Score") xtitle("ln(Rain)") legend(off)  scheme(sj)  scale(0.8)  graphregion(fcolor(white)))
graph combine r1.gph r2.gph , xcommon col(1) graphregion(fcolor(white)) scheme(sj)  scale(0.8)
graph export "rain.eps", as(eps) preview(off) replace



****************
*** Figure 4 ***
****************
drop nhat nhat2

reg normpolity cereal, r
predict nhat

reg normpolity cereal if arabconquest<0.5, r
predict nhat2


twoway (line nhat cereal, saving(ag1)) (scatter normpolity cereal if arabconquest<0.5, msymbol(i)  mlabel(countrycode)) (scatter normpolity cereal if arabconquest>=0.5, title("") note("[N=150; b=0.40; se=0.11]")  mlabel(countrycode) ytitle("Normalized Polity Score") xtitle("Fraction of Land Suitable for Cereal Production") legend(off)  scheme(sj)  scale(0.8)  graphregion(fcolor(white)))
twoway (line nhat2 cereal, saving(ag2)) (scatter normpolity cereal if arabconquest<0.5, msymbol(i)  mlabel(countrycode) title("") note("[N=123; b=0.06; se=0.12]")  mlabel(countrycode) ytitle("Normalized Polity Score") xtitle("Fraction of Land Suitable for Cereal Production") legend(off)  scheme(sj)  scale(0.8)  graphregion(fcolor(white)))
graph combine ag1.gph ag2.gph , xcommon col(1) graphregion(fcolor(white)) scheme(sj)  scale(0.8)
graph export "grains.eps", as(eps) preview(off) replace

log close
