// table10a.do

// Table 10a: Differences in Business Start Up Motivation and Expectations
//    about Growth and Innovation Behavior, PSED Sample, All Respondents

use sbh-psed, clear

gen want_big = 1 - want_to_remain_small

// sample means for omitted group
sum many_providers new_product develope_tech got_patent_trademark_in_future want_big [aw=weight_a] if !b_reasons__business & !b_reasons__personal & subset_1 
// sample percentiles for omitted group
sum desired_employees_year5 [aw=weight_a] if !b_reasons__business & !b_reasons__personal & subset_1 , detail

forvalues s=1/1 { // all respondents
  reg many_providers b_reasons__business b_reasons__personal [pw=weight_a] if subset_`s'
  disp _b[b_reasons__personal] - _b[b_reasons__business]
  test b_reasons__business = b_reasons__personal
  
  reg new_product b_reasons__business b_reasons__personal [pw=weight_a] if subset_`s'
  disp _b[b_reasons__personal] - _b[b_reasons__business]
  test b_reasons__business = b_reasons__personal
  
  reg develope_tech b_reasons__business b_reasons__personal [pw=weight_a] if subset_`s'
  disp _b[b_reasons__personal] - _b[b_reasons__business]
  test b_reasons__business = b_reasons__personal
  
  reg got_patent_trademark_in_future b_reasons__business b_reasons__personal [pw=weight_a] if subset_`s'
  disp _b[b_reasons__personal] - _b[b_reasons__business]
  test b_reasons__business = b_reasons__personal
  
  reg want_big b_reasons__business b_reasons__personal [pw=weight_a] if subset_`s'
  disp _b[b_reasons__personal] - _b[b_reasons__business]
  test b_reasons__business = b_reasons__personal
  
  qreg desired_employees_year5 b_reasons__business b_reasons__personal [aw=weight_a] if subset_`s', q(75)
  disp _b[b_reasons__personal] - _b[b_reasons__business]
  test b_reasons__business = b_reasons__personal
  
  qreg desired_employees_year5 b_reasons__business b_reasons__personal [aw=weight_a] if subset_`s', q(90)
  disp _b[b_reasons__personal] - _b[b_reasons__business]
  test b_reasons__business = b_reasons__personal
}
