// table05.do

// Table 5: Using Industry Share of Small Businesses to Predict Small Business
//    Job Creation and Destruction, Pooled 2003 to 2006 SUSB Data

version 10
clear all
macro drop _all
graph drop _all

set more off
set mem 500m
set matsize 400
set maxvar 10000
set varabbrev off
set linesize 80

use sbh-susb-dyn

//use 4-digit naics
keep if naicsdig == 4

//only look at small firms (<20 empls)
keep if zsize == 6

tab year, gen(year_d)
drop year_d1

// outputs the regression results for table6 to a txt file
// panel A is the first 5 columns
// panel B is the last 5 columns
// coefficients are reported for indfirmshrsz variable

// unweighted
// -------------------------------------------------------------
reg jc_rate ind_jc_rate indfirmshrsz year_d?, robust
outreg2 using table6, noaster replace

reg jc_rate ind_jc_rate ind_jb_rate ind_jd_rate indfirmshrsz year_d?, robust
outreg2 using table6, noaster

//exclude obs with missing birth & death data
reg jc_rate ind_jc_rate indfirmshrsz year_d? if jb_rate < . & jd_rate < ., robust
outreg2 using table6, noaster

reg jb_rate ind_jb_rate indfirmshrsz year_d?, robust
outreg2 using table6, noaster

reg jd_rate ind_jd_rate indfirmshrsz year_d?, robust 
outreg2 using table6, noaster

// Weighted
// ------------------------------------------------------------
reg jc_rate ind_jc_rate indfirmshrsz year_d? [fw=firm], robust
outreg2 using table6, noaster

reg jc_rate ind_jc_rate ind_jb_rate ind_jd_rate indfirmshrsz year_d? [fw=firm], robust
outreg2 using table6, noaster

//exclude obs with missing birth & death data
reg jc_rate ind_jc_rate indfirmshrsz year_d? [fw=firm] if jb_rate < . & jd_rate < ., robust
outreg2 using table6, noaster

reg jb_rate ind_jb_rate indfirmshrsz year_d? [fw=firm], robust
outreg2 using table6, noaster

reg jd_rate ind_jd_rate indfirmshrsz year_d? [fw=firm], robust 
outreg2 using table6, noaster


