// table02b.do

// Table 2b: Small Business Employment out of All Firms, by Firm Age 
//    and Industry, 2005 Business Dynamic Statistics Data

clear
version 10
set mem 50m
use sbh-bds

keep if year2 == 2005
keep firms emp small _sic age_group

//add an all industry row
save x-bds, replace
replace _sic = 0
collapse (sum) firms emp, by(_sic small age_group)
append using x-bds
save x-bds, replace

//add an all age row
replace age_group = 0
collapse (sum) firms emp, by(_sic small age_group)
append using x-bds

//tables 2a and 2b (0 is all age, 1 is young, 2 is old) 
keep if age_group < 3
collapse (sum) firms emp, by(_sic small age_group)
egen firmtot = sum(firms), by(_sic age_group)
egen emptot = sum(emp), by (_sic age_group)
gen firmsbshr = firms*small/firmtot
gen empsbshr = emp*small/emptot
keep if small
drop firmtot firms emptot emp small
reshape wide firmsbshr empsbshr, i(_sic) j(age_group)
replace firmsbshr1 = firmsbshr1 + 1 if _sic == 0
gsort -firmsbshr1
replace firmsbshr1 = firmsbshr1 - 1 if _sic == 0

//copy to excel
browse _sic empsbshr1 empsbshr2 empsbshr0 

