//ssbf_read.do 
//read in the raw Survey of Small Business Finances (SSBF) 2003 data
//raw data downloaded from:
//http://www.federalreserve.gov/pubs/oss/oss3/nssbftoc.htm
//

clear
set mem 100m
set more off

use ssbf_raw/ssbf03

//do anything we need to clean up the data
#delimit ;

gen weight = fin_wgt ; 

gen year = 2003 ; 

gen num_employees_cat = a0_sizeclss;

gen credit_score = a0_db_credrk ; 

gen industry = a0_sic2_fin ;

gen employees_tot = a_totemp ; 

gen working_owners = a10_1 ;

gen nonworking_owners = a10_2 ; 

gen organization_type = b3 ; 

gen age_owners_avg = cf_age ;

gen ed_owners_avg_cat = cf_educ ; 

gen how_established_cat = cf_estab ; 

gen exper_owners_avg = cf_exper ;

gen firm_age = cf_fage ;

gen family_owned = cf_family ; 

gen SBA_loans = 	h3r1_1 == 15 | h3r2_1 == 15 | h3r3_1 == 15 |
			h3r1_2 == 15 | h3r2_2 == 15 | h3r3_2 == 15 |
			h3r1_3 == 15 | h3r2_3 == 15 | h3r3_3 == 15 |
			h3r1_4 == 15 | h3r2_4 == 15 | h3r3_4 == 15 |
			h3r1_5 == 15 | h3r2_5 == 15 | h3r3_5 == 15 |
			h3r1_6 == 15 | h3r2_6 == 15 | h3r3_6 == 15 |
			h3r1_7 == 15 | h3r2_7 == 15 | h3r3_7 == 15 |
			h3r1_8 == 15 | h3r2_8 == 15 | h3r3_8 == 15 ;

gen grow_last_year = a10_5;
gen grow_last_3year = a10_6;

keep if a0_implicat == 1 ;

keep  weight year num_employees_cat credit_score 
industry employees_tot working_owners nonworking_owners 
organization_type age_owners_avg ed_owners_avg_cat how_established_cat
 exper_owners_avg firm_age family_owned SBA_loans grow_last_year grow_last_3year ; 

gen industry_contractor 		= industry == 15 | industry == 17 | industry == 16 ; 
gen industry_manufacturing  		= industry >= 20 & industry <= 39 ; 
gen industry_transportation  		= industry >= 40 & industry <= 49 ;
gen industry_wholesale 			= industry == 50 | industry == 51 ;
gen industry_retail			= industry == 52 | industry == 53 | industry == 54 | industry == 55 | industry == 56 | industry == 57 | industry == 59 ; 

 
gen industry_fire				= industry >= 60 & industry <= 69 ;
gen industry_service_rest_hotel	= industry == 58 | industry == 70 ;
gen industry_service_arts		= industry == 78 | industry == 79 | industry == 84 ;
gen industry_service_prof_nonhealth	= industry == 81 | industry == 87 |industry == 82;
gen industry_service_health		= industry == 80 | industry == 83 ;
gen industry_service_other		= (industry >= 72 & industry <= 76) | industry == 86 | industry == 88 | industry == 89 ; 


#delimit cr

save sbh-ssbf, replace
