/* ======================================================================
 * psed_read.do : read and recode waves a-e of the psed
 * 
 * Inputs:
 *  ./psed_raw/psedii_scrn_abcde.dta : psed waves a-e downloaded from
 *    http://www.psed.isr.umich.edu/psed/data (see below)
 *
 * Outputs:
 *
 * Notes:
 *
 * 050511 [benjamin] : created
 *
 * ======================================================================
 */

//raw psed data downloaded from
//http://www.psed.isr.umich.edu/psed/data
//converted from SAS using stat transfer

cap log close
log using psed_read.do, replace text

version 10
clear all
macro drop _all
graph drop _all

set more off
set mem 500m
set matsize 400
set maxvar 10000
set varabbrev off
set linesize 80

set more off

use psed_raw/psedii_scrn_abcde



#delimit ; 
                                /*  Generate Different Reasons For Starting a Business - Either First or Second Response */; 

#delimit ;

gen b_reasons__money = aa2a == 30 | aa2a == 31 | aa2a == 32 | aa2a == 33 | aa2a == 35 | aa2a == 36 | aa2a == 37 | aa2a == 38 | aa2a == 39 | aa2a == 53 |  
                       aa2b == 30 | aa2b == 31 | aa2b == 32 | aa2b == 33 | aa2b == 35 | aa2b == 36 | aa2b == 37 | aa2b == 38 | aa2b == 39 | aa2b == 53 ;

gen b_reasons__business = aa2a == 60 | aa2a == 61 | aa2a == 63 | aa2a == 40 | aa2a == 41 | aa2a == 42 | aa2a == 43 | aa2a == 44 |
                          aa2a == 45 | aa2a == 46 | aa2a == 49 |
                          aa2b == 60 | aa2b == 61 | aa2b == 63 | aa2b == 40 | aa2b == 41 | aa2b == 42 | aa2b == 43 | aa2b == 44 |
                          aa2b == 45 | aa2b == 46 | aa2b == 49  ;

gen b_reasons__personal = aa2a == 50 | aa2a == 51 | aa2a == 52 | aa2a == 56 | aa2a == 59 | aa2a == 62 | aa2a == 34 | aa2a == 70 | aa2a == 73 |
                          aa2a == 34 | aa2a == 70 | aa2a == 71 | aa2a == 72 | aa2a == 73 | aa2a == 74 | aa2a == 75 | aa2a == 76 | aa2a == 79 | 
	     		        aa2b == 50 | aa2b == 51 | aa2b == 52 | aa2b == 56 | aa2b == 59 | aa2b == 62 | aa2b == 34 | aa2b == 70 | aa2b == 73 |
                          aa2b == 34 | aa2b == 70 | aa2a == 71 | aa2a == 72 | aa2b == 73 | aa2b == 74 | aa2b == 75 | aa2b == 76 | aa2b == 79 ; 

gen b_reasons__badjob =       aa2a == 54 | aa2a == 55 | 
                              aa2b == 54 | aa2b == 55    ;

gen b_reasons_other = 		aa2a == 64 | aa2a == 65 | aa2a == 69 | aa2a  == 90 | aa2a == 91 | aa2a == 92 | aa2a == 98 | aa2a == 99 | 
                              aa2b == 64 | aa2b == 65 | aa2b == 69 | aa2b  == 90 | aa2b == 91 | aa2b == 92 | aa2b == 98 | aa2b == 99 ;

  
  
  
                                /*  Generate Different Reasons For Starting a Business - Only First Response */ ; 

#delimit ;

gen b_reasons__money_1 = aa2a == 30 | aa2a == 31 | aa2a == 32 | aa2a == 33 | aa2a == 35 | aa2a == 36 | aa2a == 37 | aa2a == 38 | aa2a == 39 | aa2a == 53 ;

gen b_reasons__business_1 = aa2a == 60 | aa2a == 61 | aa2a == 63 | aa2a == 40 | aa2a == 41 | aa2a == 42 | aa2a == 43 | aa2a == 44 |
                          aa2a == 45 | aa2a == 46  | aa2a == 49;

gen b_reasons__personal_1 = aa2a == 50 | aa2a == 51 | aa2a == 52 | aa2a == 56 | aa2a == 59 | aa2a == 62 | aa2a == 34 | aa2a == 70 | aa2a == 71 | 
                            aa2a == 72 | aa2a == 73 | aa2a == 74 | aa2a == 75 | aa2a == 76 | aa2a == 79  ; 

gen b_reasons__badjob_1 =    aa2a == 54 | aa2a == 55  ; 
 
gen b_reasons_other_1 = 	aa2a == 64 | aa2a == 65 | aa2a == 69 | aa2a  == 90 | aa2a == 91 | aa2a == 92 | aa2a == 98 | aa2a == 99 ;                          



/*  Generate Different Industries of Business Activity - At Time of Inception */ ; 


#delimit ;

gen industry_ag_mining = aa1 >= 110000 & aa1 <= 229999 ;
gen industry_construction = aa1 >= 230000 & aa1 <= 239999 ;
gen industry_manufacturing = aa1 >= 310000 & aa1 <= 399999 ;
gen industry_wholesale = aa1 >= 420000 & aa1 <= 429999 ;
gen industry_retail = aa1 >= 440000 & aa1 <= 459999 ;
gen industry_transport_warehouse = aa1 >= 480000 & aa1 <= 499999 ;

gen industry_information = aa1 >= 510000 & aa1 <= 519999 ;
gen industry_fire = (aa1 >= 520000 & aa1 <= 539999) | (aa1 >= 550000 & aa1 <= 559999)  ;
gen industry_professional = (aa1 >= 540000 & aa1 <= 549999) | (aa1 >= 610000 & aa1 <= 619999) ;
gen industry_health = aa1 >= 620000 & aa1 <= 629999 ;
gen industry_general = (aa1 >= 560000 & aa1 <= 569999) | (aa1 >= 810000 & aa1 <= 849999)   ;
gen industry_arts = aa1 >= 710000 & aa1 <= 719999 ;
gen industry_food = aa1 >= 720000 & aa1 <= 729999 ;


gen industry_group_1 = industry_manufacturing == 1 | industry_transport_warehouse == 1  |industry_health | industry_food   ; 





/*  Generate Summary Variables for Answers to How Important Different Motivations Were to Starting Business */; 

#delimit ; 

gen care_about_higher_position = 		(aw1 == 4  | aw1 == 5) ;
gen care_about_flexibility = 			(aw2 == 4  | aw2 == 5) ;
gen care_about_family_tradition = 		(aw3 == 4  | aw3 == 5) ;
gen care_about_respect_friends = 		(aw4 == 4  | aw4 == 5) ;
gen care_about_freedom = 			(aw5 == 4  | aw5 == 5) ;
gen care_about_financial_security =		(aw6 == 4  | aw6 == 5) ;	
gen care_about_follow_other =			(aw7 == 4  | aw7 == 5) ;	
gen care_about_build_inherit =		(aw8 == 4  | aw8 == 5) ;	
gen care_about_large_income =			(aw9 == 4  | aw9 == 5) ;	
gen care_about_achieve_something =		(aw10 == 4 | aw10 == 5) ;		
gen care_about_idea = 				(aw11 == 4 | aw11 == 5) ;
gen care_about_get_rich = 			(aw12 == 4 | aw12 == 5) ;
gen care_about_personal_vision =		(aw13 == 4 | aw13 == 5) ;
gen care_about_power_to_influence =		(aw14 == 4 | aw14 == 5) ;


#delimit ;

gen care_pecuniary = 				care_about_financial_security == 1 | care_about_large_income == 1 | care_about_get_rich == 1 ; 
gen care_nonpecuniary = 			care_about_flexibility == 1 |  care_about_freedom == 1 | care_about_personal_vision == 1 ;  
gen care_status = 				care_about_higher_position == 1| care_about_respect_friends == 1 | care_about_achieve_something == 1 ;
gen care_other = 					care_about_idea == 1 | care_about_family_tradition == 1 | care_about_follow_other == 1 | care_about_build_inherit == 1 | care_about_power_to_influence == 1;


/*  Generate Variables Describing Actual and Expected Innovation and Growth Behavior */; 

#delimit ;

gen develope_tech = 					ad11 == 1;
gen develope_tech_e = ad11 == 1 | bd11 == 1 | cd11 == 1 | dd11 == 1 | ed11 == 1;
gen develope_tech_in_future =			ad11 == 2;

gen got_patent_trademark =				ad13 == 1;
gen got_patent_trademark_e =				ad13 == 1 | bd13 == 1 | cd13 == 1 | dd13 == 1 | ed13 == 1;
gen got_patent_trademark_in_future =	ad13 == 2; 

gen new_product =						as2 ==  6;
gen new_product_e =					 es2 == 6;
gen many_providers =					as2 ==  1;
gen many_providers_e =					es2 == 1;

gen r_and_d_important =					as5 ==  1;

gen want_to_remain_small =				at1 ==  5;

gen desired_employees_year5 =			at5 ; 

gen start_because_nobetter_choice = 	at6 == 2 ; 
			

#delimit ;
replace desired_employees_year5 = . if at5 >= 999998 ;


/* Generate Different Levels of New Business Ex-post Success */ ; 

#delimit ;

gen subset_1 = 1 ;
gen subset_2 = ae13 == 1;           	/*  Business Received Income From Sales */;
gen subset_3 = ae15 == 1;				/*  Business Had Revenues That Exceeded Expenses */;
gen subset_4 = ae7 == 1 ;               /*  Business Hired Employees */; 
gen subset_5 = ba41 == 1;				/*  Business Was Active In Wave B of Survey */ ; 
gen subset_6 = ee13 == 1;



/*  Create Other Demographic Controls and Re-label Some Variables */; 



#delimit ;

gen income_low = income == 1 | income == 2 | income == 3 ; 
gen income_mid = income == 4 | income == 5  | income == 6 | income == 7  | income == 8 ; 
gen income_high = income == 9 | income == 10  ; 


#delimit ;

rename wt_wavea weight_a;

#delimit cr

save sbh-psed, replace

cap log close

exit
