// table10b.do

// Table 10a: Differences in Business Start Up Motivation and Expectations
//    about Growth and Innovation Behavior, PSED Sample, Positive Revenues

use sbh-psed, clear

gen want_big = 1 - want_to_remain_small

forvalues s=2/2 { // positive revenues
  reg many_providers b_reasons__business b_reasons__personal [pw=weight_a] if subset_`s'
  disp _b[b_reasons__personal] - _b[b_reasons__business]
  test b_reasons__business = b_reasons__personal
  
  reg new_product b_reasons__business b_reasons__personal [pw=weight_a] if subset_`s'
  disp _b[b_reasons__personal] - _b[b_reasons__business]
  test b_reasons__business = b_reasons__personal
  
  reg develope_tech b_reasons__business b_reasons__personal [pw=weight_a] if subset_`s'
  disp _b[b_reasons__personal] - _b[b_reasons__business]
  test b_reasons__business = b_reasons__personal
  
  reg got_patent_trademark_in_future b_reasons__business b_reasons__personal [pw=weight_a] if subset_`s'
  disp _b[b_reasons__personal] - _b[b_reasons__business]
  test b_reasons__business = b_reasons__personal
  
  reg want_big b_reasons__business b_reasons__personal [pw=weight_a] if subset_`s'
  disp _b[b_reasons__personal] - _b[b_reasons__business]
  test b_reasons__business = b_reasons__personal
  
  qreg desired_employees_year5 b_reasons__business b_reasons__personal [aw=weight_a] if subset_`s', q(75)
  disp _b[b_reasons__personal] - _b[b_reasons__business]
  test b_reasons__business = b_reasons__personal
  
  qreg desired_employees_year5 b_reasons__business b_reasons__personal [aw=weight_a] if subset_`s', q(90)
  disp _b[b_reasons__personal] - _b[b_reasons__business]
  test b_reasons__business = b_reasons__personal
}

