/* ======================================================================
 * susb3_readdyn.do : read in and recode ASCII/xls 
 *  downloads from Statistics of US Businesses (SUSB), US Census Bureau
 * 
 * Inputs:
 *  ./susb_raw/ *.xls  : xls downloads (see below)
 *
 * Outputs:
 *  ./susb_raw/sbh-susb-raw-dynYY.dta : pooled two year panel for years
 *    2002-2006
 *
 * Notes: 
 *  ** This step may be skipped if the sbh-susb-raw-dynYY datasets
 *  already exist.
 * 
 *  Data are manually pasted from the spreadsheet into the 
 *  data editor in Stata. The program will prompt for the data to be
 *  pasted and then save a source Stata file.
 *
 *  Set yy variable to the appropriate year before each run
 *
 * 050211 [benjamin] : created from older version
 *
 * ======================================================================
 */

cap log close
log using sbh-stat-susb3-readdyn.txt, replace text

version 10
clear all
macro drop _all
graph drop _all

set more off
set mem 500m
set matsize 400
set maxvar 10000
set varabbrev off
set linesize 80

//=================================================================
// DYNAMIC DATA: EMPLOYMENT/FIRMS/ESTABS/PAYROLL
//=================================================================

//read these in from the excel spreadsheets available from
//http://www.census.gov/econ/susb/historical_data.html

//entered in by hand by copying from each spreadsheet

//earlier available years use NAICS 1997
//2003 to 2004
//2004 to 2005
//2005 to 2006
//2006 to 2007

//all spreadsheet years have identical formats
//change this for each (base) year 2003 2004 2005 2006
local yy 06

clear

//paste in the data from the appropriate excel spreadsheet
//copy all data below the column headings!
edit

gen year = 20`yy'

//name the columns
ren var1 naics
ren var2 naicsdscr
ren var3 datatype
ren var4 datatypedscr
//employment sizes
ren var5 e1   //total
ren var6 e2   //1-4
ren var7 e3   //5-9
ren var8 e4   //10-19
ren var9 e5   //20-99
ren var10 e6  //100-499
ren var11 e7  //500+
ren var12 e8  //<500

label data "converted from xls by sbh-data-susb3-readdyn.do"
save susb_raw/sbh-susb-raw-dyn`yy', replace

cap log close
exit


