// figure3.do

// Figure 3: Within Industry Share of Employment by Small Firms by Decile
//    of Industry Share of Small Firms out of All Small Firms

clear
version 10
set mem 50m
use sbh-susb-static07

keep if naicsdig == 4 & entrsize == 6

// rank by unadjusted
sort indfirmranksz

// assign percentiles
gen pctile2 = sum(1 / 294) // cumulative 

// group by decile
gen decile2 = .
replace decile2 = 1 if pctile2 <= .10
replace decile2 = 2 if pctile2 > 0.1 & pctile2 <= 0.2
replace decile2 = 3 if pctile2 > 0.2 & pctile2 <= 0.3
replace decile2 = 4 if pctile2 > 0.3 & pctile2 <= 0.4
replace decile2 = 5 if pctile2 > 0.4 & pctile2 <= 0.5
replace decile2 = 6 if pctile2 > 0.5 & pctile2 <= 0.6
replace decile2 = 7 if pctile2 > 0.6 & pctile2 <= 0.7
replace decile2 = 8 if pctile2 > 0.7 & pctile2 <= 0.8
replace decile2 = 9 if pctile2 > 0.8 & pctile2 <= 0.9
replace decile2 = 10 if pctile2 > 0.9 & pctile2 <= 1.0

// fig_small_share_by_adjrank_deciles_bar
graph bar szemplshrind, over(decile2) ///
  over(entrsize /*just need a constant category*/, relabel(1 "Decile of  Industry Firm Share out of all Small Firms")) ///
  ytitle("Within Industry Share of Employment By Small Firms") 
  
