//bds_read.do

//read in the raw business dynamic statistics databases
//downloaded from http://www.ces.census.gov/index.php/bds/bds_database_list

//data downloaded as SAS files and converted to Stata

clear
set mem 100m
set more off

//firm age by firm size by sector
//use bds_raw/jcrempfagefsz_release_sector
//save bds_age_size_sector, replace

//initial firm size
use bds_raw/jcrempfageifszsic_release

gen _sic = sic1
destring _sic, replace
label def lsic  ///
  0   "All"             ///
  7   "Agriculture"     ///
  10  "Mining"          ///
  15  "Construction"    ///  
  20  "Manufacturing"   ///
  40  "TCU"             ///
  50  "Wholesale Trade" ///
  52  "Retail Trade"    ///
  60  "FIRE"            ///
  70  "Services"      
label val _sic lsic

label def lage_group  ///
  0   "All Ages"        ///
  1   "0-9 Years Old"   ///
  2   "10-25 Years Old" ///  
  3   "26+ Years Old"   

//0 to 10
gen age_group = 1 if regexm(fage4,"^[abcdefg]")
//11 to 25
replace age_group = 2 if regexm(fage4,"^[hij]")
//26 or more
replace age_group = 3 if regexm(fage4,"^[kl]")
label val age_group lage_group

gen small = regexm(ifsize,"^[abc]")
label var small "=1 if firms < 20 empls"

save sbh-bds, replace

