clear all

use data_complete.dta

** job loss on contemperaneous unemployment rate ALL
regress joblose curcont
mat define coef=e(b)
mat define V=e(V)
mat define rtwo=e(r2)
local a=round(coef[1,1],.01) // this gives slope //
local b=round(coef[1,2],.01) // gives constant //
local r=round(rtwo[1,1],.01)
local c=round(V[1,1]^.5,.01)
local d=round(V[2,2]^.5,.01)
#delimit ;
twoway scatter joblose curcont || lfit joblose curcont, 
ytitle(Percentage that considers it fairly or very likely to lose job) 
ytitle(, size(medsmall)) 
xtitle(Average Civilian Unemployment Rate Over 5 Months) 
xtitle(, size(medsmall)) 
title(Contemporaneous Perceptions of Job Loss, size(large)) 
subtitle(Select Years from 1977-2008, size(medium))
caption("Slope=`a'(s.e.=`c')" "Intercept=`b'(s.e.=`d')" "R-squared=`r'", ring(0) position(3) )
yscale(range(7 16))
xscale(range(3 10))
legend(off);
graph export "jobloseall.png", replace;
#delimit cr


** job loss on contemperaneous unemployment rate prime age
regress joblose_pa paurcont
mat define coef=e(b)
mat define V=e(V)
mat define rtwo=e(r2)
local a=round(coef[1,1],.01) // this gives slope //
local b=round(coef[1,2],.01) // gives constant //
local r=round(rtwo[1,1],.01)
local c=round(V[1,1]^.5,.01)
local d=round(V[2,2]^.5,.01)
#delimit ;
twoway scatter joblose_pa paurcont || lfit joblose_pa paurcont, 
ytitle(Percentage of rime-aged that considers it fairly or very likely to lose job) 
ytitle(, size(small)) 
xtitle(Average Prime-aged Unemployment Rate Over 5 Months) 
xtitle(, size(small)) 
title(Contemporaneous Perceptions of Job Loss for Prime-aged Workers, size(medlarge)) 
subtitle(Select Years from 1977-2008, size(medium))
caption("Slope=`a'(s.e.=`c')" "Intercept=`b'(s.e.=`d')" "R-squared=`r'", ring(0) position(3) )
yscale(range(7 16))
xscale(range(3 10))
legend(off);
graph export "joblosepa.png", replace;
#delimit cr



** job find on contemperaneous unemployment rate ALL

regress jobfind curcont 
mat define coef=e(b)
mat define V=e(V)
mat define rtwo=e(r2)
local a=round(coef[1,1],.01) // this gives slope //
local b=round(coef[1,2],.01) // gives constant //
local r=round(rtwo[1,1],.01)
local c=round(V[1,1]^.5,.01)
local d=round(V[2,2]^.5,.01)
#delimit ;
twoway scatter jobfind curcont || lfit jobfind curcont, 
ytitle(Not easy to find a job with same income and fringe benefits) 
ytitle(, size(medsmall)) 
xtitle(Average Civilian Unemployment Rate Over 5 Months) 
xtitle(, size(medsmall)) 
title(Contemporaneous Perceptions of Job-finding, size(large)) 
subtitle(Select Years from 1977-2008, size(medium))
caption("Slope=`a'(s.e.=`c')" "Intercept=`b'(s.e.=`d')" "R-squared=`r'", ring(0) position(3) )
yscale(range(25 60))
xscale(range(3 10))
legend(off);
graph export "jobfindall.png", replace;
#delimit cr


** job find on contemperaneous unemployment rate prime age

regress jobfind_pa paurcont
mat define coef=e(b)
mat define V=e(V)
mat define rtwo=e(r2)
local a=round(coef[1,1],.01) // this gives slope //
local b=round(coef[1,2],.01) // gives constant //
local r=round(rtwo[1,1],.01)
local c=round(V[1,1]^.5,.01)
local d=round(V[2,2]^.5,.01)
#delimit ;
graph twoway scatter jobfind_pa paurcont || lfit jobfind_pa paurcont ,  
ytitle(Not easy to find a job with same income and fringe benefits) 
ytitle(, size(medsmall)) 
xtitle(Average Prime-aged Unemployment Rate Over 5 Months) 
xtitle(, size(medsmall)) 
yscale(range(25 60))
xscale(range(3 10))
title(Contemporaneous Perceptions of Job-finding for Prime-age Workers, size(medlarge))
legend(off)
caption("Slope=`a'(s.e.=`c')" "Intercept=`b'(s.e.=`d')" "R-squared=`r'", ring(0) position(3) )
subtitle(Select Years from 1977-2008, size(medium));
graph export "jobfindpa.png", replace;
#delimit cr
