#delimit ;
capture log close;
log using appfig_a1.log, replace;

* PROGRAM GENERATES FIGURES OF PDV LOSS OVER CYCLE BY AGE AND TENURE GROUP;

global title pos(11) span size(medium) margin(bottom) c(black);

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

* GENERATE FIGURES OF BEFORE/AFTER LOSSES BY *FOUR* AGE GROUPS;

/*-----------------------------*/
capture program drop makefig;
program define makefig;
local t `1';

scatter $varlist ccnt if ten==`t'&agegr==1&ccnt<20, c(l l) m(d o p) clw(medthick medthick medthick) 
title("Panel 1: Workers Displaced at age 21-30", $title) xlabel(-6(2)20) ylabel(-25(5)0)
$graph saving(pan1, replace);

scatter $varlist ccnt if ten==`t'&agegr==2&ccnt<20, c(l l) m(d o p) clw(medthick medthick medthick) 
title("Panel 2: Workers Displaced at age 31-40", $title)  xlabel(-6(2)20) ylabel(-25(5)0)
$graph saving(pan2, replace);

if `t' ==6 {;
	scatter $varlist ccnt if ten==6&agegr==3&ccnt<13, c(l l) m(d o p) clw(medthick medthick medthick) 
	title("Panel 3: Workers Displaced at age 41-50", $title)  xlabel(-6(2)20) ylabel(-25(5)0)
	$graph saving(pan3, replace);
};
else {;
	scatter $varlist ccnt if ten==`t'&agegr==3&ccnt<15, c(l l) m(d o p) clw(medthick medthick medthick) 
	title("Panel 3: Workers Displaced at age 41-50", $title)  xlabel(-6(2)20) ylabel(-25(5)0)
	$graph saving(pan3, replace);
};

*scatter $varlist ccnt if ten==`t'&agegr==3&ccnt<15, c(l l) m(d o p) clw(medthick medthick medthick) 
title("Panel 3: Workers Displaced at age 41-50", $title)  xlabel(-6(2)20) ylabel(-25(5)0)
$graph saving(pan3, replace);

scatter $varlist ccnt if ten==`t'&agegr==4&ccnt<10, c(l l) m(d o p) clw(medthick medthick medthick) 
title("Panel 4: Workers Displaced at age 51-60", $title)  xlabel(-6(2)20) ylabel(-25(5)0)
$graph saving(pan4, replace);
end;
/*-----------------------------*/

/*-----------------------------*/
capture program drop combfig;
program define combfig;
local t `1';

*graph combine pan1.gph pan2.gph pan3.gph pan4.gph , altshrink graphregion(color(white) 
lcolor(white)) plotregion(lcolor(black) lwidth(medthin)) 
title("Figure Y: Annual Earnings Losses Before/After Job Displacement in $1000"
"Averages for Displacements in NBER Recessions and Expansions"
"Men with At Least `t' Years of Job Tenure Displaced at Firms Size 50+"
"Displaced as Firm has Lasting 30% Employment Drop Over 2 Years", $title) 
saving(FIGURES/appfig_a1, replace)
note("Source: 1% Files of Social Security administrative data (see text).", span);

* NOTITLE FOR PAPER APPENDIX;

graph combine pan1.gph pan2.gph pan3.gph pan4.gph , altshrink graphregion(color(white) 
lcolor(white)) plotregion(lcolor(black) lwidth(medthin)) 
saving(FIGURES/appfig_a1, replace);

graph export FIGURES/appfig_a1.wmf, replace;

forvalues x=1/4  {;
	erase pan`x'.gph;
};
end;
/*-----------------------------*/

/*-----------------------------*/
capture program drop appfig_a1;
program define appfig_a1;

* LOAD AND GENERATE VARIABLES;

use regsum3u_vars, clear;

sort ten sep agegr ccnt;

label var baseE "Expansion";
label var baseR "Recession";

foreach var in baseE baseR {;
		local a1=.25;
		local a2=1-2*`a1';
		g `var'_s=`var';
		qui replace `var'_s=`var'[_n-1]*`a1'+`var'*`a2'+`var'[_n+1]*`a1' if ccnt>=2&ten==ten[_n-1]&ten==ten[_n+1]&
		sep==sep[_n-1]&sep==sep[_n+1]&agegr==agegr[_n-1]&agegr==agegr[_n+1];
};

label var baseE_s "Expansion";
label var baseR_s "Recession";

* MAKE FIGURES;

global graph graphregion(color(white)) plotregion(lcolor(black) lwidth(medthin)) ylabel(, nogrid) yline(0);

global varlist baseE_s baseR_s;

makefig 3;
combfig 3;

end;
/*--------------------------------------------------------------------------*/

* RUN PROGRAM;

appfig_a1;

log close;

