#delimit ;
capture log close;
log using regsum3fu.log, replace;
set more off;

* GENERATES AVERAGE PRE-EARNINGS AND NUMBER DISPLACED BY BOOM/RECESSION BASED ON NBER RECESSION DATES, UR-DUMMIES, DOES IT FOR *FIVE* AGE-GROUPS;

/*----------------------*/
/* 	LOAD DATA 	*/
/*----------------------*/

global finyr = 2008;

/*-----------------------------------------------------------------*/
capture program drop loadit;
program define loadit;

* FIRST LOAD COEFFICIENTS FOR LOSSES;

use if sep=="ddd2yrmnwkd30n1"|sep=="ddd2yrmnwkd80n1" & yrgr<=2005 using ../../SSA_REPLICATION/RESULTS/Results_Sept13/basic3fYR3a2_100, clear;

* GENERATE "PANEL";

	* rename for smart reshaping;
		foreach var in earnzer earnall work {;
			forvalues x=6/10{;
				local y=`x'-5;
				rename b`var'`x' b`var'5`y';
			};
			forvalues x=1/5{;
				rename b`var'`x' b`var'1`x';
			};
};

keep bearnall* yrgr cnt sep ten;
reshape long bearnall1 , i(yrgr cnt sep ten) j(agegr);
sort ten sep agegr yrgr cnt;

keep if cnt>=-4&cnt<=-1;

collapse (mean) bearnall1, by(agegr yrgr sep ten);	/* NEW: 11/12/11 */

rename bearnall1 preearn;

keep agegr yrgr ten sep preearn;

sum yrgr;
global lastdisp=r(max);

label var yrgr "Year of Displacement";

sort yrgr ten sep agegr;
tempfile temp;
save `temp';

* MERGE ON INFO FROM MONTHLY UR BY YEAR;

use year value period if year>=1980&year<=$lastdisp using ../mntur_bls_jul2011, clear;

rename value ur;

sum ur, d;
replace ur=ur/100;

g dur4_5=0;
replace dur4_5=1 if ur<=.05;
g dur5_6=0;
replace dur5_6=1 if ur>.05&ur<=.06;
g dur6_7=0;
replace dur6_7=1 if ur>.06&ur<=.07;
g dur7_8=0;
replace dur7_8=1 if ur>.07&ur<=.08;
g dur8_11=0;
replace dur8_11=1 if ur>.08;

collapse (mean) dur*, by(year);

egen check=rsum(dur*);
sum check;	* should be identical to 1;
drop check;

* see fraction of years for single variables;

	mat B=0;
	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		sum dur`var';
		mat B=[B\r(mean)];
		};
	mat B=B[2..6,1];

/* GENERATE DUMMIES BASED ON NBER RECESSION DATES*/

g dumR = 0;
replace dumR = 7/12 if year==1980|year==1981;
replace dumR = 9/12 if year==1982;
replace dumR = 7/12 if year==1990;
replace dumR = 3/12 if year==1991;
replace dumR = 8/12 if year==2001;
*replace dumR = 1/12 if year==2007;
*replace dumR = 1 if year==2008;
*replace dumR = 6/12 if year==2009;
label var dumR "Indicator NBER Recession";

g dumE = 1-dumR;
label var dumE "Indicator NBER Expansion";

* see fractions;

	sum dumE;
	mat a=r(mean);
	sum dumR;
	mat b=r(mean);
	
	mat B=[a\b\B];

* MERGE BACK TO MAIN DATA;

rename year yrgr;
sort yrgr;
merge yrgr using `temp';
tab _merge;
keep if _merge ==3; 
drop _merge;

save temp_regsum3fu, replace;

end;
/*-----------------------------------------------------------------*/

/*----------------------*/
/*    RUN REGRESSIONS   */
/*----------------------*/

/*-----------------------------------------------------------------*/
capture program drop regmain1;
program define regmain1;
local ten `1';
local sep `2';
local agegr `3';

* GENERATE VARIABLES;

	use if agegr==`agegr'&sep=="`sep'" using temp_regsum3fu, clear;

* FIRST OBTAIN BASIC MEAN;

	reg preearn if ten==`ten';
	* save out coefficients;
	mat bprew=_b[_cons];

* ALLOW MEAN BY BOOM/RECESSION;

	reg preearn dumE dumR if ten==`ten', noconst;
	* save out coefficients;
	mat bprew=[bprew\_b[dumE]\_b[dumR]];

	foreach var in bprew  {;
		svmat `var';
		rename `var'1 `var';
	};
	
	g str15 var="";
	replace var="mean" in 1;
	replace var="NBER Expanstion" in 2;
	replace var="NBER Recession" in 3;
	g order =_n;

	keep var order bprew ;
	drop if bprew==.;

* SAVE OUT;

g ten=`ten';
g str15 sep="`sep'";
g agegr=`agegr';
g spec =1;
order spec agegr ten sep order var bprew ;
save regsum3fu_1_`ten'_`sep'_`agegr', replace;

end;
/*-----------------------------------------------------------------*/

/*-----------------------------------------------------------------*/
capture program drop regmain2;
program define regmain2;
local ten `1';
local sep `2';
local agegr `3';

* GENERATE VARIABLES;

	use if agegr==`agegr'&sep=="`sep'" using temp_regsum3fu, clear;

* ALLOW MEAN BY BOOM/RECESSION;

	reg preearn dur* if ten==`ten', noconst;
	* save out coefficients;
	mat bprew=.;
	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
	mat bprew=[bprew\_b[dur`var']];
	};

	foreach var in bprew  {;
		mat `var'=`var'[2..6,1];
		svmat `var';
		rename `var'1 `var';
	};
	g str15 var="";
	replace var="UR4_5" in 1;
	replace var="UR5_6" in 2;
	replace var="UR6_7" in 3;
	replace var="UR7_8" in 4;
	replace var="UR8_11" in 5;
	g order =_n+3;
	
	keep var order bprew* ;
	drop if bprew==.;

* SAVE OUT;

g ten=`ten';
g str15 sep="`sep'";
g spec =2;
g agegr=`agegr';
order spec agegr ten sep order var bprew ;
save regsum3fu_2_`ten'_`sep'_`agegr', replace;

end;
/*-----------------------------------------------------------------*/

* RUN THE WHOLE THING;

global tenlist 3 6;
global prognum 1 2;
global seplist ddd2yrmnwkd30n1;
global agelist 1 2 3 4 5;

* load data;

loadit;

* run regressions;

foreach sep in $seplist {;
         foreach ten in $tenlist {;
			foreach agegr in $agelist {;
				regmain1 `ten' `sep' `agegr';
				regmain2 `ten' `sep' `agegr';
			};
  	   };
};

* MERGE FILES TOGETHER;

capture program drop mergeit;
program define mergeit;
local n `1';

local sep1: word 1 of $seplist;
local age1: word 1 of $agelist;
local ten1: word 1 of $tenlist;

local seplist $seplist;
global seplist2 : list seplist-sep1;
local agelist $agelist;
global agelist2: list agelist-age1;
local tenlist $tenlist;
global tenlist2 : list tenlist-ten1;

use regsum3fu_`n'_`ten1'_`sep1'_`age1',clear;

global sep1 `sep1';
global age1 `age1';
foreach ten in $tenlist2 {;
        local age1 $age1;                  
        local sep1 $sep1;                  
                   append using regsum3fu_`n'_`ten'_`sep1'_`age1';
        };

foreach ten in $tenlist {;
	foreach sep in $seplist2 {;
        local age1 $age1;                  
                   append using regsum3fu_`n'_`ten'_`sep'_`age1';
        };
};
                          
foreach age in $agelist2 {;
	foreach sep in $seplist {;
                          foreach ten in $tenlist {;
                                             append using regsum3fu_`n'_`ten'_`sep'_`age';
                                            };
              	        };
		};
		
save regsum3fu_`n', replace;
end;

mergeit 1;
mergeit 2;


* SAVE IT OUT;

use regsum3fu_1;
append using regsum3fu_2;

sort sep agegr ten order;

save regsum3fu, replace;

* CLEAN UP;

foreach sep in $seplist {;
		foreach age in $agelist {;
                         foreach ten in $tenlist {;
                                             erase regsum3fu_1_`ten'_`sep'_`age'.dta;
                                             erase regsum3fu_2_`ten'_`sep'_`age'.dta;
                                           };
                       };
 		};

erase temp_regsum3fu.dta;
erase regsum3fu_1.dta;
erase regsum3fu_2.dta;

log close;

