#delimit ;
set more off;
capture log close;
log using appfig.log, replace;

* FIGURE: GENERATE FIGURES OF AGE-GRADIENT IN PDV LOSS;

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
global title pos(11) span size(medium) margin(bottom) c(black);

/*------------------------------------------------------------------*/
capture program drop appfig_a2;
program define appfig_a2;

use regsum3e3u_tab, clear;

keep if spec==1;
keep if (measure=="pathED"|measure=="pathRD");
egen group=group(measure);

keep pdvgap1 pdvloss1 pdvfrac1 diffA agegr ten group sep;
reshape wide pdvgap1 pdvloss1 pdvfrac1 diffA, i(agegr ten sep) j(group);

* main measure;

label var diffA1 "PDV Perc. Loss, Exp.";
label var diffA2 "PDV Perc. Loss, Rec.";

* additional measures;

label var pdvloss11 "PDV Loss, Expansion";
label var pdvloss12 "PDV Loss, Recession";
label var pdvgap11 "Relative Loss, Expansion";
label var pdvgap12 "Relative Loss, Recession";
label var pdvfrac11 "Relative Loss, Expansion";
label var pdvfrac12 "Relative Loss, Recession";
label var agegr "Age at Displacement";

* SAVE OUT TO UPLOAD IN EXCEL;

	* RESHAPE;
	g str4 sep_="";
	replace sep_="30d2" if sep=="ddd2yrmnwkd30n1";
	replace sep_="30d1" if sep=="ddd1yrmnwkd30n1";
	replace sep_="80d2" if sep=="ddd2yrmnwkd80n1";
	replace sep_="plcl" if sep=="ddd1yrmnwkd100n";
	drop sep;
	global varlist diffA1 diffA2 pdvgap11 pdvgap12 pdvloss11 pdvloss12;
	keep sep_ ten $varlist agegr;
	global varlist1;
	foreach var in $varlist {;
		rename `var' `var'_;
		global varlist1 $varlist1 `var'_;
		};
	reshape wide $varlist1 , i(ten agegr) j(sep_) string;
	* MAKE RIGHT ORDER;
	global varlist2;
	foreach var in $varlist {;
		global varlist2 $varlist2 `var'_30d2;
		};
	sort ten agegr;
	order ten agegr $varlist2;
	* SAVE OUT;
	outsheet using FIGURES/appfig_a2.txt, replace;

end; /* end program: appfig_a2 */
/*------------------------------------------------------------------*/
/*------------------------------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------------------------------*/

* RUN IT ALL ;

appfig_a2;

log close;
