#delimit ;
set more off;
capture log close;
log using figure6.log, replace;

* FIGURE 6: INITIAL ANNUAL EARNINGS LOSSES BY YEAR OF DISPLACEMENT;

* OUTPUT FILES SAVED IN FOLDER FIGURES/;

/*------------------------------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------------------------------*/
capture program drop fig6;
program define fig6;

* LOAD BASIC DATA;

use if (sep=="ddd2yrmnwkd30n1"|sep=="ddd2yrmnwkd80n1")&yrgr<2006 using ../../SSA_REPLICATION/RESULTS/basic3fYR3e_100, clear;


* reset wage losses to be relative to 4 years prior to displacement;
 
rename bearnzer5 bzer;
rename bearnall5 ball;

replace cnt=99 if cnt==-4;
drop if cnt<=0;
reshape wide b*, i(ten yrgr sep) j(cnt);
rename bzer99 bzer_3;
rename ball99 ball_3;

* generate differences at various durations;

global varlist zer all;
foreach x in 1 2 5 9 {;
    foreach var in $varlist {;
           local y=`x'+1;
           g d`var'`x'_`y'=(b`var'`x'+b`var'`y')/2 - b`var'_3;
           };
    };
global varlist zer all;
forvalues x= 1/15{;
    foreach var in $varlist {;
           g d`var'`x'=b`var'`x' - b`var'_3;
           };
    };

sort ten yrgr;
tempfile temp;
sort yrgr;
save `temp';

* MERGE ON UNEMPLOYMENT RATE;

use year urate if year>=1980&year<2006 using yearur,clear;
rename year yrgr;
sort yrgr;
merge yrgr using `temp';
tab _merge;
drop _merge;

sort ten yrgr;

label var dall2 "Positive Earnings";
label var dzer2 "Any Earnings";
label var dall3 "Positive Earnings";
label var dzer3 "Any Earnings";
label var urate "Unemployment Rate";

* MERGE ON INITIAL WAGE LEVEL;

tempfile temp;
sort sep ten yrgr;
save `temp';

use sep ten cnt yrgr bearnall1 if cnt>=-4&cnt<=-1 & (sep=="ddd2yrmnwkd30n1"|sep=="ddd2yrmnwkd80n1") using ../../SSA_REPLICATION/RESULTS/basic3fYR3e_100, clear;
collapse (mean) bearnall1, by(yrgr ten sep);
keep yrgr ten sep bearnall1;
rename bearnall1 iniw;
sort sep ten yrgr;
keep if (sep=="ddd2yrmnwkd30n1"|sep=="ddd2yrmnwkd80n1");
merge sep ten yrgr using `temp';
tab _merge;
keep if _merge==3;
drop _merge;

g relzer=dzer3/iniw;

* WITHOUT TITLE FOR PAPER;

foreach t in 3 {;
	twoway (scatter relzer urate if ten==`t'&sep=="ddd2yrmnwkd30n1", c(.) ml(yrgr) clw(medthick) yaxis(1)), 
	xlabel(3(1)11) ytitle("Earnings Loss/Initial Wage") saving(FIGURES/figure6, replace) 
	graphregion(color(white)) plotregion(lcolor(black) lwidth(medthin)) ylabel(, nogrid);

	graph export FIGURES/figure6.wmf, replace;
	graph export FIGURES/figure6.eps, replace;
};


* SAVE OUT TO UPLOAD IN EXCEL;

	* RESHAPE;

	g str4 sep_="";
	replace sep_="30d2" if sep=="ddd2yrmnwkd30n1";
	replace sep_="30d1" if sep=="ddd1yrmnwkd30n1";
	replace sep_="80d2" if sep=="ddd2yrmnwkd80n1";
	replace sep_="plcl" if sep=="ddd1yrmnwkd100n";
	drop sep;
	global varlist relzer dzer3 dall3;
	keep ten sep_ $varlist urate yrgr;
	global varlist1;
	foreach var in $varlist {;
		rename `var' `var'_;
		global varlist1 $varlist1 `var'_;
		};
	reshape wide $varlist1 , i(ten urate) j(sep_) string;
	* MAKE RIGHT ORDER;
	global varlist2;
	foreach var in $varlist {;
		global varlist2 $varlist2 `var'_30d2 `var'_80d2;
		};
	sort ten urate;
	order ten urate $varlist2;
	* SAVE OUT;
	outsheet using FIGURES/figure6.txt, replace;

end;
/*------------------------------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------------------------------*/

* RUN IT ALL ;

fig6; 	/* fig 6 */

log close;
