#delimit ;
capture log close;
log using table2.log, replace;

* GENERATE TABLE 2 WITH VARIOUS SPECIFICATIONS;

global varlist pdvloss1 pdvfrac1 diffA pdvgap1;

* HIGH-TENURED WORKERS;

use regsum2d3u_tab_rev, clear;
keep measure ten sep $varlist;
keep if ten==6&sep=="ddd2yrmnwkd30n1";
keep if measure=="path0D"|measure=="pathED"|measure=="pathRD";
drop ten sep;
g group=1;
order group measure $varlist;
tempfile temp1;
save `temp1';

* WOMEN;

use regsum2d3w_tab, clear;
keep measure ten sep $varlist;
keep if ten==3&sep=="ddd2yrmnwkd30n1";
keep if measure=="path0D"|measure=="pathED"|measure=="pathRD";
drop ten sep;
g group=2;
order group measure $varlist;
tempfile temp2;
save `temp2';

* AGE-GROUPS;

use regsum3u_tab, clear;

keep measure agegr ten sep $varlist;
keep if ten==3&sep=="ddd2yrmnwkd30n1";
keep if measure=="path0D"|measure=="pathED"|measure=="pathRD";
drop ten sep;
rename agegr group;
order group measure $varlist;
tempfile temp3;
save `temp3';

* APPEND IT ALL FOR TABLE;

use `temp1';
append using `temp2';
append using `temp3';

list;

outsheet using table2.txt, replace;

log close;
