#delimit ;
capture log close;
log using regsum2c2w.log, replace;
set more off;

* GENERATES AVERAGE PRE-EARNINGS AND NUMBER DISPLACED BY BOOM/RECESSION BASED ON NBER RECESSION DATES, UR-DUMMIES;

/*----------------------*/
/* 	LOAD DATA 	*/
/*----------------------*/

global finyr = 2008;

/*-----------------------------------------------------------------*/
capture program drop loadit;
program define loadit;

use sep ten cnt yrgr bearnall1 if cnt>=-4&cnt<=-1 & (sep=="ddd2yrmnwkd30n1"|sep=="ddd2yrmnwkd80n1") using ../../SSA_REPLICATION/WOMEN/basic3fYR3ew_100, clear;
collapse (mean) bearnall1, by(yrgr sep ten);	

keep yrgr ten sep bearnall1;
rename bearnall1 preearn;

sum yrgr;
global lastdisp=r(max);

label var yrgr "Year of Displacement";

sort yrgr ten sep;
tempfile temp;
save `temp';

* MERGE ON INFO FROM MONTHLY UR BY YEAR;

use year value period if year>=1980&year<=$lastdisp using ../mntur_bls_jul2011, clear;

rename value ur;

sum ur, d;
replace ur=ur/100;

g dur4_5=0;
replace dur4_5=1 if ur<=.05;
g dur5_6=0;
replace dur5_6=1 if ur>.05&ur<=.06;
g dur6_7=0;
replace dur6_7=1 if ur>.06&ur<=.07;
g dur7_8=0;
replace dur7_8=1 if ur>.07&ur<=.08;
g dur8_11=0;
replace dur8_11=1 if ur>.08;

collapse (mean) dur*, by(year);

egen check=rsum(dur*);
sum check;	* should be identical to 1;
drop check;

* see fraction of years for single variables;

	mat B=0;
	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		sum dur`var';
		mat B=[B\r(mean)];
		};
	mat B=B[2..6,1];

/* GENERATE DUMMIES BASED ON NBER RECESSION DATES*/

g dumR = 0;
replace dumR = 7/12 if year==1980|year==1981;
replace dumR = 9/12 if year==1982;
replace dumR = 7/12 if year==1990;
replace dumR = 3/12 if year==1991;
replace dumR = 8/12 if year==2001;

label var dumR "Indicator NBER Recession";

g dumE = 1-dumR;
label var dumE "Indicator NBER Expansion";

* see fractions;

	sum dumE;
	mat a=r(mean);
	sum dumR;
	mat b=r(mean);
	
	mat B=[a\b\B];

* MERGE BACK TO MAIN DATA;

rename year yrgr;
sort yrgr;
merge yrgr using `temp';
tab _merge;
keep if _merge ==3; 
drop _merge;

save temp_regsum2c2w, replace;

drop _all;
svmat B, n(fracyrs);
outsheet using fracyrs.txt, replace;

end;
/*-----------------------------------------------------------------*/

/*----------------------*/
/*    RUN REGRESSIONS   */
/*----------------------*/

/*-----------------------------------------------------------------*/
capture program drop regmain1;
program define regmain1;
local ten `1';
local sep `2';

* GENERATE VARIABLES;

	use if sep=="`sep'" using temp_regsum2c2w, clear;

* FIRST OBTAIN BASIC MEAN;

	reg preearn if ten==`ten';
	* save out coefficients;
	mat bprew=_b[_cons];

	/*
	reg ndisp if ten==`ten';
	* save out coefficients;
	mat bndisp=_b[_cons];

	reg fdisp if ten==`ten';
	* save out coefficients;
	mat bfdisp=_b[_cons];
	*/

* ALLOW MEAN BY BOOM/RECESSION;

	reg preearn dumE dumR if ten==`ten', noconst;
	* save out coefficients;
	mat bprew=[bprew\_b[dumE]\_b[dumR]];

	/*
	reg ndisp dumE dumR if ten==`ten', noconst;
	* save out coefficients;
	mat bndisp=[bndisp\_b[dumE]\_b[dumR]];

	reg fdisp dumE dumR if ten==`ten', noconst;
	* save out coefficients;
	mat bfdisp=[bfdisp\_b[dumE]\_b[dumR]];
	*/
	foreach var in bprew {;
		svmat `var';
		rename `var'1 `var';
	};
	
	g str15 var="";
	replace var="mean" in 1;
	replace var="NBER Expanstion" in 2;
	replace var="NBER Recession" in 3;
	g order =_n;

	keep var order bprew;
	drop if bprew==.;

* SAVE OUT;

g ten=`ten';
g str15 sep="`sep'";
g spec =1;
order spec ten sep order var bprew;
save regsum2c2w_1_`ten'_`sep', replace;

end;
/*-----------------------------------------------------------------*/

/*-----------------------------------------------------------------*/
capture program drop regmain2;
program define regmain2;
local ten `1';
local sep `2';

* GENERATE VARIABLES;

	use if sep=="`sep'" using temp_regsum2c2w, clear;

* ALLOW MEAN BY BOOM/RECESSION;

	reg preearn dur* if ten==`ten', noconst;
	* save out coefficients;
	mat bprew=.;
	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
	mat bprew=[bprew\_b[dur`var']];
	};
	/*
	reg ndisp dur* if ten==`ten', noconst;
	* save out coefficients;
	mat bndisp=.;
	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
	mat bndisp=[bndisp\_b[dur`var']];
	};

	reg fdisp dur* if ten==`ten', noconst;
	* save out coefficients;
	mat bfdisp=.;
	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
	mat bfdisp=[bfdisp\_b[dur`var']];
	};
	*/

	foreach var in bprew {;
		mat `var'=`var'[2..6,1];
		svmat `var';
		rename `var'1 `var';
	};
	g str15 var="";
	replace var="UR4_5" in 1;
	replace var="UR5_6" in 2;
	replace var="UR6_7" in 3;
	replace var="UR7_8" in 4;
	replace var="UR8_11" in 5;
	g order =_n+3;
	
	keep var order bprew*;
	drop if bprew==.;

* SAVE OUT;

g ten=`ten';
g str15 sep="`sep'";
g spec =2;
order spec ten sep order var bprew;
save regsum2c2w_2_`ten'_`sep', replace;

end;
/*-----------------------------------------------------------------*/

* RUN THE WHOLE THING;

global tenlist 3 6;
global prognum 1 2;
global seplist ddd2yrmnwkd30n1 ddd2yrmnwkd80n1;

* load data;

loadit;

* run regressions;

foreach sep in $seplist {;
                 foreach ten in $tenlist {;
				regmain1 `ten' `sep';
				regmain2 `ten' `sep';
			};
	};


* MERGE FILES TOGETHER;

local sep1: word 1 of $seplist;
local n1: word 1 of $prognum;
local ten1: word 1 of $tenlist;

local seplist $seplist;
global seplist2 : list seplist-sep1;
local prognum $prognum;
global prognum2: list prognum-n1;
local tenlist $tenlist;
global tenlist2 : list tenlist-ten1;

use regsum2c2w_`n1'_`ten1'_`sep1',clear;

global sep1 `sep1';
global n1 `n1';
foreach ten in $tenlist2 {;
        local n1 $n1;                  
        local sep1 $sep1;                  
                   append using regsum2c2w_`n1'_`ten'_`sep1';
        };

foreach ten in $tenlist {;
	foreach sep in $seplist2 {;
        local n1 $n1;                  
                   append using regsum2c2w_`n1'_`ten'_`sep';
        };
};
                          
foreach n in $prognum2 {;
	foreach sep in $seplist {;
                          foreach ten in $tenlist {;
                                             append using regsum2c2w_`n'_`ten'_`sep';
                                            };
              	        };
		};
		
		
* SAVE IT OUT;

sort sep ten order;

save regsum2c2w, replace;

* CLEAN UP;

foreach sep in $seplist {;
		foreach n in $prognum {;
                         foreach ten in $tenlist {;
                                             erase regsum2c2w_`n'_`ten'_`sep'.dta;
                                           };
                       };
 		};

erase temp_regsum2c2w.dta;
log close;

