#delimit ;
capture log close;
log using regsum3u_tab.log, replace;

* EXTRACTS DATA NEEDED FOR TABLE;

global suf 3u;

/*---------------------------------------------------------------------------------------*/
* extract discounted series ("D"); /* EASILY DO SUMS INSTEAD */

use regsum$suf, clear;
g x=reverse(measure);
g y=substr(x,1,1);
keep if y=="D";
drop x y;

* extract series with smoothed recovery;
g y=substr(measure,1,4);
keep if y=="path";
drop y;
rename pdvloss pdvloss1;
	label var pdvloss1 "PDV: Smoothed Recovery Path";

g measure_=substr(measure,5,3);
sort agegr ten sep measure_;
tempfile temp;
save `temp', replace;

/*---------------------------------------------------------------------------------------*/
* do actual series;  

use regsum$suf, clear;
g x=reverse(measure);
g y=substr(x,1,1);
keep if y=="D";
drop x y;
g y=substr(measure,1,4);
keep if y=="base";
drop y;
g measure_=substr(measure,5,3);
rename pdvloss pdvloss2;
label var pdvloss2 "PDV: Actual Recovery Path";
drop measure;
sort agegr ten sep measure_;

merge agegr ten sep measure_ using `temp';
tab _merge;
drop _merge;
sort agegr ten sep measure_ ;
tempfile temp;
save `temp', replace;

/*---------------------------------------------------------------------------------------*/
* then do differenced series;

use regsum$suf, clear;
g x=reverse(measure);
g y=substr(x,1,1);
keep if y=="D";
drop x y;
g y=substr(measure,1,5);
keep if y=="diffA";
drop y;
g measure_=substr(measure,6,3);
rename pdvloss diffA;
label var diffA "PDV of Log Diff Loss";
drop measure;
sort agegr ten sep measure_;

merge agegr ten sep measure_ using `temp';
tab _merge;
drop _merge;
sort agegr ten sep measure_ ;
tempfile temp;
save `temp', replace;

* SECOND MEASURE;

use regsum$suf, clear;
g x=reverse(measure);
g y=substr(x,1,1);
keep if y=="D";
drop x y;
g y=substr(measure,1,5);
keep if y=="diffB";
drop y;
g measure_=substr(measure,6,3);
rename pdvloss diffB;
label var diffB "PDV of Log Diff Loss";
drop measure;
sort agegr ten sep measure_;

merge agegr ten sep measure_ using `temp';
tab _merge;
drop _merge;
sort agegr ten sep measure_ ;
tempfile temp;
save `temp', replace;
/*---------------------------------------------------------------------------------------*/
* then do counterfactual mean;

use regsum$suf, clear;
g x=reverse(measure);
g y=substr(x,1,1);
keep if y=="D";
drop x y;
g y=substr(measure,1,4);
keep if y=="cntf";
drop y;
g measure_=substr(measure,5,3);
rename pdvloss cntf;
label var cntf "Avg. Cntf. PDV";
drop measure;
sort agegr ten sep measure_;

merge agegr ten sep measure_ using `temp';
tab _merge;
drop _merge;
sort agegr ten sep measure_ ;
tempfile temp;
save `temp', replace;

/*---------------------------------------------------------------------------------------*/
* generate order variable;

g order=.;
replace order=1 if measure=="path0D";
replace order=2 if measure=="pathED";
replace order=3 if measure=="pathRD";
replace order=4 if measure=="path4_5D";
replace order=5 if measure=="path5_6D";
replace order=6 if measure=="path6_7D";
replace order=7 if measure=="path7_8D";
replace order=8 if measure=="path8_11D";

/*---------------------------------------------------------------------------------------*/
* merge on initial wage level;
	
replace agegr=20 if agegr==1;
replace agegr=30 if agegr==2;
replace agegr=40 if agegr==3;
replace agegr=50 if agegr==4;

sort sep agegr ten order;
local suf $suf;
save regsum`suf'_tab, replace;
merge sep agegr ten order using regsum3du;
tab _merge;
drop _merge;

/*---------------------------------------------------------------------------------------*/
* generate additional variables;

*replace bndisp=bndisp*100;

foreach n in 1 2 {;
	g pdvfrac`n'=pdvloss`n'/bprew;
	g pdvgap`n'=pdvloss`n'/cntf;		/* relative to average COUNTERFACTUAL PDV */
	replace pdvloss`n'=1000*pdvloss`n';	/* scale in 1000s of $ */
};

drop measure_;

order agegr ten sep spec order var measure pdvloss1 pdvfrac1 diffA diffB pdvgap1 bprew pdvloss2 pdvfrac2;

save regsum`suf'_tab, replace;
outsheet using regsum`suf'_tab.txt, replace;


log close;