#delimit ;
capture log close;
log using regsum3u.log, replace;
set more off;

* MAIN PROGRAM FOR TABLE OF PDV EARNINGS LOSSES BY AGE-GROUP;

global maxyear=2008;		
global maxdisp=2005;		

/*---------------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------------*/
capture program drop loadit;
program define loadit;

/*************************************************/
/* STEP 0: LOAD ORIGINAL MEANS PLUS COEFFICIENTS */
/*************************************************/

/* PREPARE MERGE OF MISSING CONSTANTS */

use if spec==1&var==1 using ../../SSA_REPLICATION/RESULTS/Results_Sept13/extract_const, clear;
drop spec var se n;
replace agegr=agegr/10 -1;
reshape wide cons, i(yrgr ten) j(agegr);
sort yrgr ten;
tempfile temp;
save `temp';

* FIRST LOAD COEFFICIENTS FOR LOSSES;

use if sep=="ddd2yrmnwkd30n1" using ../../SSA_REPLICATION/RESULTS/Results_Sept13/basic3fYR3a_100, clear;
g year=cnt+yrgr-1;	

sort yrgr ten cnt;

/* MERGE IN MISSING CONSTANTS AND ADJUST VALUES */

merge yrgr ten using `temp';
tab _merge;

	forvalues x=1/4{;
		replace bearnzer`x'=cons`x'+bearnzer`x';
	};


* SET TO MISSING VALUES BASED ON TOO FEW COHORTS;

foreach var in bearnzer bearnall {;
	foreach x in 3 7 {;
		replace `var'`x'=. if cnt>15;
		};
	foreach y in 4 8 {;
		replace `var'`y'=. if cnt>10;
		};
};

* GENERATE "PANEL";

	* rename for smart reshaping;
		foreach var in earnzer earnall work {;
			forvalues x=5/8{;
				local y=`x'-4;
				rename b`var'`x' b`var'5`y';
			};
			forvalues x=1/4{;
				rename b`var'`x' b`var'1`x';
			};
};

* RESET DIFFERENCE VIS-A-VIS FOUR YEARS BEFORE LAYOFF;

foreach var in all zer {;
	forvalues x=1/4 {;
		g dum=bearn`var'5`x' if cnt==-4;
		egen ini=sum(dum), by(yrgr sep ten);
		g dearn`var'`x'=bearn`var'5`x'-ini;
		drop ini dum; 
	};
};

reshape long bearnzer1 bearnall1 bearnzer5 bearnall5 dearnzer dearnall bwork1 bwork5, i(yrgr cnt sep ten) j(agegr);
sort ten sep agegr yrgr cnt;

* GENERATE "ADJUSTED VARIABLE": SUBTRACT LOSS;

foreach var in earnzer earnall {;		
	g c`var'0=b`var'1-b`var'5;
	g c`var'=b`var'1-d`var';		
	};

foreach var in zer all {;
	rename cearn`var' c`var';	/* COUNTERFACTUAL MEAN: NEW */
	rename bearn`var'1 m`var';	/* ACTUAL MEAN */
	rename bearn`var'5 b`var'; 	/* LOSS */
	rename dearn`var' d`var'; 	/* LOSS RELATIVE TO CNT=-2 */
};
rename bwork1 mwork;
rename bwork5 bwork; 

keep agegr c* bzer ball dall dzer bwork m* ten sep yrgr year cnt;

sort yrgr;
tempfile temp;
save `temp';	

/*************************************************/
/* STEP 0: MERGE ON INFO FROM MONTHLY UR BY YEAR */
/*************************************************/

use year value period if year>=1980&year<=$maxdisp using ../mntur_bls_jul2011, clear;

rename value ur;

sum ur, d;
replace ur=ur/100;

g dur4_5=0;
replace dur4_5=1 if ur<=.05;
g dur5_6=0;
replace dur5_6=1 if ur>.05&ur<=.06;
g dur6_7=0;
replace dur6_7=1 if ur>.06&ur<=.07;
g dur7_8=0;
replace dur7_8=1 if ur>.07&ur<=.08;
g dur8_11=0;
replace dur8_11=1 if ur>.08;

collapse (mean) dur*, by(year);

egen check=rsum(dur*);
sum check;	* should be identical to 1;
drop check;

sum dur*;

rename year yrgr;
sort yrgr;
merge yrgr using `temp';
tab _merge;
keep if _merge ==3; 
drop _merge;

/* GENERATE RELEVANT DUMMIES */

g dumR = 0;
replace dumR = 7/12 if yrgr==1980|yrgr==1981;
replace dumR = 9/12 if yrgr==1982;
replace dumR = 7/12 if yrgr==1990;
replace dumR = 3/12 if yrgr==1991;
replace dumR = 8/12 if yrgr==2001;
*replace dumR = 1/12 if yrgr==2007;
*replace dumR = 1 if yrgr==2008;
*replace dumR = 6/12 if yrgr==2009;
label var dumR "Indicator NBER Recession";

g dumE = 1-dumR;
label var dumE "Indicator NBER Expansion";

save temp_regsum3u, replace;

end;
/*---------------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------------*/

/**************************************************/
/* STEP 1: REGRESS ON RECESSION DUMMIES		  */
/**************************************************/

/*---------------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------------*/
capture program drop regmain1;
program define regmain1;
local ten `1';
local sep `2';
local age `3';
global var `4';

/*--------------------------------------------------------------------*/
* SET BASIC PARAMETERS;

	/* NOTE (8/26/2011): SET THESE *EQUAL* SINCE OTHERWISE WE 
	EITHER ALSO HAVE TO PROJECT MEANS&COUNTERFACTUAL EARNINGS 
	OR WE HAVE TO USE VALUES AVERAGING OVER VERY FEW COHORTS */

if `age'==1 {;		
	global maxpred=20;		/* range for prediction */
	global maxcnt=20;			/* range of coeff estimates used */
};
if `age'==2 {;
	global maxpred=20;
	global maxcnt=20;
};
if `age'==3 {;
	global maxpred=15;		/* NOTE: same as range kept for estimates in "loadit" above */
	global maxcnt=15;
};

if `age'==4 {;
	global maxpred=10;		/* NOTE: same as range kept for estimates in "loadit" above */
	global maxcnt=10;
};

/*--------------------------------------------------------------------*/
* LOAD AND GENERATE BASIC VARIABLES;

	use if agegr==`age'&cnt<=$maxcnt&sep=="`sep'"&ten==`ten'&yrgr<=$maxdisp&year<=$maxyear using temp_regsum3u, clear;

	qui tab cnt, g(dcnt);	/* GENERATE DUMMIES */

	egen group=group(cnt);	/* GENERATE COUNTER */
	sum group;
	global max=r(max);

/*--------------------------------------------------------------------*/
* FIRST OBTAIN BASIC MEAN OF AVERAGE WAGES BY THE CYCLE;

	reg c$var dcnt1-dcnt$max if ten==`ten', noconst; 	/* COUNTERFACTUAL MEAN */

	* save out coefficients;
	g cntf0=.;
	forvalues x=1/$max {;
                      qui replace cntf0=_b[dcnt`x'] in `x';
	};

	reg m$var dcnt1-dcnt$max if ten==`ten', noconst; 	/* ACTUAL MEAN */

	* save out coefficients;
	g mean0=.;
	forvalues x=1/$max {;
                      qui replace mean0=_b[dcnt`x'] in `x';
	};

	* ALSO OBTAIN AVERAGE LOSS DUE TO LAYOFF;

	reg d$var dcnt1-dcnt$max if ten==`ten', noconst; 	/* LOSS */

	* save out coefficients;
	g base0=.;
	forvalues x=1/$max {;
                      qui replace base0=_b[dcnt`x'] in `x';
	};

/*--------------------------------------------------------------------*/
* THEN DO NBER RECESSION DATES;

	* GENERATE ADDITIONAL REGRESSORS;

	forvalues x=1/$max {;
                      g dcntR`x'=dcnt`x'*dumR;
                    };
	forvalues x=1/$max {;
                      g dcntE`x'=dcnt`x'*dumE;
                    };

	* ALLOW FOR PERSISTENT EFFECT EFFECT TO VARY WITH INITIAL CONDITION;

	reg c$var dcntR1-dcntR$max dcntE1-dcntE$max if ten==`ten', noconst; 	/* COUNTERFACTUAL MEAN */
	
	* SIMULATE EFFECT OF VARIOUS UR LEVELS AND SAVE OUT COEFFICIENTS;

	g cntfR=.;
	g cntfE=.;
	forvalues x=1/$max {;
                      qui replace cntfR=_b[dcntR`x'] in `x';
                      qui replace cntfE=_b[dcntE`x'] in `x';
	};

	* ALLOW FOR ACTUAL MEAN TO VARY WITH INITIAL CONDITION;

	reg m$var dcntR1-dcntR$max dcntE1-dcntE$max if ten==`ten', noconst; 	/* ACTUAL MEAN */
	
	* SIMULATE EFFECT OF VARIOUS UR LEVELS AND SAVE OUT COEFFICIENTS;

	g meanR=.;
	g meanE=.;
	forvalues x=1/$max {;
                      qui replace meanR=_b[dcntR`x'] in `x';
                      qui replace meanE=_b[dcntE`x'] in `x';
	};

	g ccnt=_n-7;
	label var mean0 "Counterfactual Average";
	label var meanR "Ctf. Avg. NBER Recessions";
	label var meanE "Ctf. Avg. NBER Expansions";
	label var ccnt "Year Before/After Layoff";

	* ALSO ALLOW FOR PERSISTENT EFFECT EFFECT TO VARY WITH INITIAL CONDITION;

	reg d$var dcntR1-dcntR$max dcntE1-dcntE$max if ten==`ten', noconst;	/* LOSS */
	
	* SIMULATE EFFECT OF VARIOUS UR LEVELS AND SAVE OUT COEFFICIENTS;

	g baseR=.;
	g baseE=.;
	forvalues x=1/$max {;
                      qui replace baseR=_b[dcntR`x'] in `x';
                      qui replace baseE=_b[dcntE`x'] in `x';
	};

/*--------------------------------------------------------------------*/
* NEXT DO UR DUMMIES;

	* GENERATE ADDITIONAL REGRESSORS;

	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		forvalues x=1/$max {;
                      g dcntur`var'_`x'=dcnt`x'*dur`var';
                    };
	};

	* ALLOW FOR COUNTERFACTUAL MEAN TO VARY WITH INITIAL CONDITION;

	reg c$var dcntur* if ten==`ten', noconst;		/* COUNTERFACTUAL MEAN */
	
	* SIMULATE EFFECT OF VARIOUS UR LEVELS AND SAVE OUT COEFFICIENTS;

	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		qui g cntf`var'=.;
	};
	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		forvalues x=1/$max {;
                      qui replace cntf`var'=_b[dcntur`var'_`x'] in `x';
		};
	};
	
	* ALLOW FOR ACTUAL MEAN TO VARY WITH INITIAL CONDITION;

	reg m$var dcntur* if ten==`ten', noconst;		/* ACTUAL MEAN */
	
	* SIMULATE EFFECT OF VARIOUS UR LEVELS AND SAVE OUT COEFFICIENTS;

	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		qui g mean`var'=.;
	};
	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		forvalues x=1/$max {;
                      qui replace mean`var'=_b[dcntur`var'_`x'] in `x';
		};
	};

	* ALSO ALLOW FOR PERSISTENT LOSS TO VARY WITH INITIAL CONDITION;

	reg d$var dcntur* if ten==`ten', noconst;		/* LOSS */
	
	* SIMULATE EFFECT OF VARIOUS UR LEVELS AND SAVE OUT COEFFICIENTS;

	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		qui g base`var'=.;
	};
	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		forvalues x=1/$max {;
                      qui replace base`var'=_b[dcntur`var'_`x'] in `x';
		};
	};

/*--------------------------------------------------------------------*/
* GENERATE RATE OF DECAY BASED ON AVERAGE RECOVERY PATTERN;

* FIRST DO IT FOR NBER RECESSION DATES;

	foreach v in 6 10 11 15 20 12 18 19 {;
		g x=base0 if ccnt==`v';
		egen loss`v'=mean(x);
		drop x;
	};
	g dec6_10 = (log(abs(loss10))-log(abs(loss6)))/5;
	sum dec6_10;
	g dec11_15= (log(abs(loss15))-log(abs(loss11)))/5;
	sum dec11_15;
	g dec11_20= (log(abs(loss20))-log(abs(loss11)))/5;
	sum dec11_20;

	* take average to account for variability (or moving average);

	if `age'==1 {;	/* GENERATE SINGLE RATE OF DECAY FOR ALL AGE GROUPS (THIS IS RESET FOR EACH TENURE & SEP DEFINITION) */
		g dec=(dec6_10+dec11_15)/2;	/* choose this: use 5-10, since there most cohorts, but also 11-15 to put some weight on persistence */
		sum dec;				
		global dec=r(mean);
	};
	
	* PROJECT FORWARD PATH OF EARNINGS LOSSES;

	qui g path0=base0 if ccnt<=10;
	qui g pathE=baseE if ccnt<=10;
	qui g pathR=baseR if ccnt<=10;

	if $maxpred>=11 {;
		qui replace path0=path0[_n-1]*(1+$dec) if ccnt>=11&ccnt<=$maxpred;
		qui replace pathE=pathE[_n-1]*(1+$dec) if ccnt>=11&ccnt<=$maxpred;
		qui replace pathR=pathR[_n-1]*(1+$dec) if ccnt>=11&ccnt<=$maxpred;
	};

	label var path0 "Avg: Proj. Recovery >=11";
	label var pathE "E: Proj. Recovery >=11";
	label var pathR "R: Proj. Recovery >=11";

* THEN DO IT FOR UR-DUMMIES;

	* PROJECT FORWARD PATH OF EARNINGS LOSSES;

	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		g path`var'=base`var' if ccnt<=10;
		replace path`var'=path`var'[_n-1]*(1+$dec) if ccnt>=11&ccnt<=$maxpred;
	};


* THE SAME FOR LOG DIFFERENCE OF LOSSES RELATIVE TO MEANS;

		foreach n in 0 R E 4_5 5_6 6_7 7_8 8_11 {;
			g diffA`n'= log(mean`n')-log(cntf`n'); /* LOG DIFF OF ACTUAL AVG. RELATIVE TO COUNTERFACTUAL */
			g diffB`n'= path`n'/cntf`n';		/* RATIO OF LOSS RELATIVE TO COUNTERFACTUAL AVERAGE */
		};

* SAVE OUT BASIC VARIABLES;

keep if ccnt<=$maxpred;
keep ccnt cntf* mean* base* diff* path* cntf*;
g ten=`ten';
g str15 sep="`sep'";
g agegr=`age';

save regsum3u_vars_`ten'_`sep'_`age', replace;

/*--------------------------------------------------------------------*/
* DISCOUNT VALUES WITH 5% DISCOUNT Rate;

* FIRST DO NBER RECESSION DATE;

	* only sum up losses starting at year of job loss; 

	keep if ccnt>=0&ccnt<=$maxpred;

	* discount starting at t=0;

	g t=_n-1;
	g disc=(1+.05)^(-t);
	foreach var in base path mean cntf {;
		foreach n in 0 R E {;
			g `var'`n'D=`var'`n'*disc;
		};
	};

* THEN DO UR DUMMIES;

	foreach var in base path mean cntf {;
		foreach n in 4_5 5_6 6_7 7_8 8_11 {;
			g `var'`n'D=`var'`n'*disc;
		};
	};

* THE SAME FOR LOG DIFFERENCE OF LOSSES RELATIVE TO MEANS;

		foreach n in 0 R E 4_5 5_6 6_7 7_8 8_11 {;
			g diffA`n'D= diffA`n'*disc;
			g diffB`n'D= diffB`n'*disc;
		};

/*-----------------------------------------------------------------*/
* SUM UP TO GENERATE PDV LOSSES;

collapse (sum) base* path* mean* diff* cntf*;
xpose, clear varname;
g ten=`ten';
g str15 sep="`sep'";
g agegr=`age';
rename _varname measure;
rename v1 pdvloss;
save regsum3u_`ten'_`sep'_`age', replace;
end;
/*---------------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------------*/


/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
* RUN THE WHOLE THING;

global tenlist 3 6;
*global seplist ddd2yrmnwkd30n1 ddd2yrmnwkd80n1 ddd1yrmnwkd30n1 ddd1yrmnwkd80n1 has1stsep;
global seplist ddd2yrmnwkd30n1;

* load data;

loadit;

*>>>>>>>>>> run regressions <<<<<<<<<<;

foreach sep in $seplist {;
          foreach ten in $tenlist {;
			  forvalues age=1/4 {;
				regmain1 `ten' `sep' `age' zer;  /* ten= TENURE, sep = MLF-type, age = age-group, zer=variable */
			};
 	    };
};


/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
* MERGE FILES TOGETHER: OUTPUT FILES;

local sep1: word 1 of $seplist;
local ten1: word 1 of $tenlist;

local seplist $seplist;
global seplist2 : list seplist-sep1;
local tenlist $tenlist;
global tenlist2 : list tenlist-ten1;

use regsum3u_`ten1'_`sep1'_1,clear;
append using regsum3u_`ten1'_`sep1'_2;
append using regsum3u_`ten1'_`sep1'_3;
append using regsum3u_`ten1'_`sep1'_4;

global sep1 `sep1';
foreach ten in $tenlist2 {;
		foreach age in 1 2 3 4 {;
		        local sep1 $sep1;                  
                   append using regsum3u_`ten'_`sep1'_`age';
        };
};

foreach sep in $seplist2 {;
                    foreach ten in $tenlist {;
				foreach age in 1 2 3 4 {;
                                      append using regsum3u_`ten'_`sep'_`age';
              	        };
		};
};		

* SAVE IT OUT;

*sort sep ten;

save regsum3u, replace;

/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
* MERGE FILES TOGETHER: GENERATED ANNUAL LOSS+EARNINGS VALUES;

local sep1: word 1 of $seplist;
local ten1: word 1 of $tenlist;

local seplist $seplist;
global seplist2 : list seplist-sep1;
local tenlist $tenlist;
global tenlist2 : list tenlist-ten1;

use regsum3u_vars_`ten1'_`sep1'_1, clear;
append using regsum3u_vars_`ten1'_`sep1'_2;
append using regsum3u_vars_`ten1'_`sep1'_3;
append using regsum3u_vars_`ten1'_`sep1'_4;

global sep1 `sep1';
foreach ten in $tenlist2 {;
		foreach age in 1 2 3 4 {;
	        local sep1 $sep1;                  
                   append using regsum3u_vars_`ten'_`sep1'_`age';
        };

};
foreach sep in $seplist2 {;
                    foreach ten in $tenlist {;
				foreach age in 1 2 3 4 {;
                                      append using regsum3u_vars_`ten'_`sep'_`age';
              	        };
		};
};		


* SAVE IT OUT;

save regsum3u_vars, replace;

/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
* CLEAN UP;

foreach sep in $seplist {;
                      foreach ten in $tenlist {;
					foreach age in 1 2 3 4 {;
                                   erase regsum3u_`ten'_`sep'_`age'.dta;
	                             erase regsum3u_vars_`ten'_`sep'_`age'.dta;
                       		};
 		};
};

erase temp_regsum3u.dta;

log close;

