#delimit ;
capture log close;
log using regsum2d3u2.log, replace;
set more off;

* MAIN PROGRAM FOR TABLE OF PDV EARNINGS LOSSES;

global maxcnt=20;			/* SET THIS BY HAND: HAVE AT LEAST 3 COHORTS PER CNT-YEAR */
global maxyear=2008;		
global maxdisp=2005;		

/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
capture program drop loadit;
program define loadit;

/*************************************************/
/* STEP 0: LOAD ORIGINAL MEANS PLUS COEFFICIENTS */
/*************************************************/

use if (sep=="ddd2yrmnwkd30n1"|sep=="ddd2yrmnwkd80n1") using ../../SSA_REPLICATION/RESULTS/basic3fYR3e_100, clear;
g year=cnt+yrgr-1;

* RESET DIFFERENCE VIS-A-VIS FOUR YEARS BEFORE LAYOFF;

foreach var in all zer {;
		g dum=bearn`var'5 if cnt==-4;
		egen ini=sum(dum), by(yrgr sep ten);
		g dearn`var'5=bearn`var'5-ini;
		drop ini dum;
	};

sort ten sep yrgr cnt;

* GENERATE "ADJUSTED VARIABLE": SUBTRACT LOSS;

foreach var in earnzer earnall {;		
	g c`var'0=b`var'1-b`var'5;
	g c`var'=b`var'1-d`var'5;		
	};

foreach var in zer all {;
	rename cearn`var' c`var';	/* COUNTERFACTUAL MEAN */
	rename bearn`var'1 m`var';	/* ACTUAL MEAN */
	rename bearn`var'5 b`var'; 	/* LOSS */
	rename dearn`var'5 d`var'; 	/* LOSS WRT CNT=-3 */
};
rename bwork1 mwork;
rename bwork5 bwork; 

keep c* bzer ball bwork dzer dall m* ten sep yrgr year cnt;

sort yrgr;
tempfile temp;
save `temp';	

/*************************************************/
/* STEP 0: MERGE ON INFO FROM MONTHLY UR BY YEAR */
/*************************************************/

use year value period if year>=1980&year<=$maxdisp using ../mntur_bls_jul2011, clear;

rename value ur;

sum ur, d;
replace ur=ur/100;

g dur4_5=0;
replace dur4_5=1 if ur<=.05;
g dur5_6=0;
replace dur5_6=1 if ur>.05&ur<=.06;
g dur6_7=0;
replace dur6_7=1 if ur>.06&ur<=.07;
g dur7_8=0;
replace dur7_8=1 if ur>.07&ur<=.08;
g dur8_11=0;
replace dur8_11=1 if ur>.08;

collapse (mean) dur*, by(year);

egen check=rsum(dur*);
sum check;	* should be identical to 1;
drop check;

sum dur*;

rename year yrgr;
sort yrgr;
merge yrgr using `temp';
tab _merge;
keep if _merge ==3; 
drop _merge;

/* GENERATE RELEVANT DUMMIES */

g dumR = 0;
replace dumR = 7/12 if yrgr==1980|yrgr==1981;
replace dumR = 9/12 if yrgr==1982;
replace dumR = 7/12 if yrgr==1990;
replace dumR = 3/12 if yrgr==1991;
replace dumR = 8/12 if yrgr==2001;
*replace dumR = 1/12 if yrgr==2007;
*replace dumR = 1 if yrgr==2008;
*replace dumR = 6/12 if yrgr==2009;
label var dumR "Indicator NBER Recession";

g dumE = 1-dumR;
label var dumE "Indicator NBER Expansion";

save temp_regsum2d3u2, replace;

end;
/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/

/**************************************************/
/* STEP 1: REGRESS ON RECESSION DUMMIES		  */
/**************************************************/

/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
capture program drop regmain1;
program define regmain1;
local ten `1';
local sep `2';
global var `3';

/*--------------------------------------------------------------------*/
* LOAD AND GENERATE BASIC VARIABLES;

	use if cnt<=$maxcnt&sep=="`sep'"&ten==`ten'&yrgr<=$maxdisp&year<=$maxyear using temp_regsum2d3u2, clear;

	qui tab cnt, g(dcnt);	/* GENERATE DUMMIES */

	egen group=group(cnt);	/* GENERATE COUNTER */
	sum group;
	global max=r(max);

/*--------------------------------------------------------------------*/
* FIRST OBTAIN BASIC MEAN OF AVERAGE WAGES BY THE CYCLE;

	reg c$var dcnt1-dcnt$max if ten==`ten', noconst; 	/* COUNTERFACTUAL MEAN */

	* save out coefficients;
	g cntf0=.;
	forvalues x=1/$max {;
                      qui replace cntf0=_b[dcnt`x'] in `x';
	};

	reg m$var dcnt1-dcnt$max if ten==`ten', noconst; 	/* ACTUAL MEAN */

	* save out coefficients;
	g mean0=.;
	forvalues x=1/$max {;
                      qui replace mean0=_b[dcnt`x'] in `x';
	};

	* ALSO OBTAIN AVERAGE LOSS DUE TO LAYOFF;

	reg d$var dcnt1-dcnt$max if ten==`ten', noconst; 	/* LOSS */

	* save out coefficients;
	g base0=.;
	forvalues x=1/$max {;
                      qui replace base0=_b[dcnt`x'] in `x';
	};

/*--------------------------------------------------------------------*/
* THEN DO NBER RECESSION DATES;

	* GENERATE ADDITIONAL REGRESSORS;

	forvalues x=1/$max {;
                      g dcntR`x'=dcnt`x'*dumR;
                    };
	forvalues x=1/$max {;
                      g dcntE`x'=dcnt`x'*dumE;
                    };

	* ALLOW FOR PERSISTENT EFFECT EFFECT TO VARY WITH INITIAL CONDITION;

	reg c$var dcntR1-dcntR$max dcntE1-dcntE$max if ten==`ten', noconst; 	/* COUNTERFACTUAL MEAN */
	
	* SIMULATE EFFECT OF VARIOUS UR LEVELS AND SAVE OUT COEFFICIENTS;

	g cntfR=.;
	g cntfE=.;
	forvalues x=1/$max {;
                      qui replace cntfR=_b[dcntR`x'] in `x';
                      qui replace cntfE=_b[dcntE`x'] in `x';
	};

	* ALLOW FOR ACTUAL MEAN TO VARY WITH INITIAL CONDITION;

	reg m$var dcntR1-dcntR$max dcntE1-dcntE$max if ten==`ten', noconst; 	/* ACTUAL MEAN */
	
	* SIMULATE EFFECT OF VARIOUS UR LEVELS AND SAVE OUT COEFFICIENTS;

	g meanR=.;
	g meanE=.;
	forvalues x=1/$max {;
                      qui replace meanR=_b[dcntR`x'] in `x';
                      qui replace meanE=_b[dcntE`x'] in `x';
	};

	g ccnt=_n-7;
	label var mean0 "Counterfactual Average";
	label var meanR "Ctf. Avg. NBER Recessions";
	label var meanE "Ctf. Avg. NBER Expansions";
	label var ccnt "Year Before/After Layoff";

	* ALSO ALLOW FOR PERSISTENT EFFECT EFFECT TO VARY WITH INITIAL CONDITION;

	reg d$var dcntR1-dcntR$max dcntE1-dcntE$max if ten==`ten', noconst;	/* LOSS */
	
	* SIMULATE EFFECT OF VARIOUS UR LEVELS AND SAVE OUT COEFFICIENTS;

	g baseR=.;
	g baseE=.;
	forvalues x=1/$max {;
                      qui replace baseR=_b[dcntR`x'] in `x';
                      qui replace baseE=_b[dcntE`x'] in `x';
	};


/*--------------------------------------------------------------------*/
* NEXT DO UR DUMMIES;

	* GENERATE ADDITIONAL REGRESSORS;

	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		forvalues x=1/$max {;
                      g dcntur`var'_`x'=dcnt`x'*dur`var';
                    };
	};

	* ALLOW FOR COUNTERFACTUAL MEAN TO VARY WITH INITIAL CONDITION;

	reg c$var dcntur* if ten==`ten', noconst;		/* COUNTERFACTUAL MEAN */
	
	* SIMULATE EFFECT OF VARIOUS UR LEVELS AND SAVE OUT COEFFICIENTS;

	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		qui g cntf`var'=.;
	};
	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		forvalues x=1/$max {;
                      qui replace cntf`var'=_b[dcntur`var'_`x'] in `x';
		};
	};
	
	* ALLOW FOR ACTUAL MEAN TO VARY WITH INITIAL CONDITION;

	reg m$var dcntur* if ten==`ten', noconst;		/* ACTUAL MEAN */
	
	* SIMULATE EFFECT OF VARIOUS UR LEVELS AND SAVE OUT COEFFICIENTS;

	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		qui g mean`var'=.;
	};
	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		forvalues x=1/$max {;
                      qui replace mean`var'=_b[dcntur`var'_`x'] in `x';
		};
	};

	* ALSO ALLOW FOR PERSISTENT LOSS TO VARY WITH INITIAL CONDITION;

	reg d$var dcntur* if ten==`ten', noconst;		/* LOSS */
	
	* SIMULATE EFFECT OF VARIOUS UR LEVELS AND SAVE OUT COEFFICIENTS;

	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		qui g base`var'=.;
	};
	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		forvalues x=1/$max {;
                      qui replace base`var'=_b[dcntur`var'_`x'] in `x';
		};
	};


/*--------------------------------------------------------------------*/
* GENERATE RATE OF DECAY BASED ON AVERAGE RECOVERY PATTERN;

* FIRST DO IT FOR NBER RECESSION DATES;

	foreach v in 6 10 11 15 20 12 18 19 {;
		g x=base0 if ccnt==`v';
		egen loss`v'=mean(x);
		drop x;
	};
	g dec6_10 = (log(abs(loss10))-log(abs(loss6)))/5;
	sum dec6_10;
	g dec11_15= (log(abs(loss15))-log(abs(loss11)))/5;
	sum dec11_15;
	g dec11_20= (log(abs(loss20))-log(abs(loss11)))/5;
	sum dec11_20;

	* take average to account for variability (or moving average);
	
	g dec=(dec6_10+dec11_15)/2;	/* choose this: use 5-10, since there most cohorts, but also 11-15 to put some weight on persistence */
	sum dec;				

	* PROJECT FORWARD PATH OF EARNINGS LOSSES;

	qui g path0=base0 if ccnt<=10;
	qui replace path0=path0[_n-1]*(1+dec) if ccnt>=11;
	qui g pathE=baseE if ccnt<=10;
	qui replace pathE=pathE[_n-1]*(1+dec) if ccnt>=11;
	qui g pathR=baseR if ccnt<=10;
	qui replace pathR=pathR[_n-1]*(1+dec) if ccnt>=11;

	label var path0 "Avg: Proj. Recovery >=11";
	label var pathE "E: Proj. Recovery >=11";
	label var pathR "R: Proj. Recovery >=11";

* THEN DO IT FOR UR-DUMMIES;

	* PROJECT FORWARD PATH OF EARNINGS LOSSES;

	foreach var in 4_5 5_6 6_7 7_8 8_11 {;
		g path`var'=base`var' if ccnt<=10;
		replace path`var'=path`var'[_n-1]*(1+dec) if ccnt>=11;
	};

* THE SAME FOR LOG DIFFERENCE OF LOSSES RELATIVE TO MEANS;

		foreach n in 0 R E 4_5 5_6 6_7 7_8 8_11 {;
			g diffA`n'= log(mean`n')-log(cntf`n'); /* LOG DIFF OF ACTUAL AVG. RELATIVE TO COUNTERFACTUAL */
			g diffB`n'= path`n'/cntf`n';		/* RATIO OF LOSS RELATIVE TO COUNTERFACTUAL AVERAGE */
		};

* SAVE OUT BASIC VARIABLES;

keep if mean0!=.;
keep ccnt cntf* mean* base* diff* path* cntf*;
g ten=`ten';
g str15 sep="`sep'";

save regsum2d3u2_vars_`ten'_`sep', replace;

/*--------------------------------------------------------------------*/
* DISCOUNT VALUES WITH 5% DISCOUNT Rate;

* FIRST DO NBER RECESSION DATE;

	* only sum up losses starting at year of job loss; 

	keep if ccnt>=0;

	* discount starting at t=0;

	g t=_n-1;
	g disc=(1+.05)^(-t);
	foreach var in base path mean cntf {;
		foreach n in 0 R E {;
			g `var'`n'D=`var'`n'*disc;
		};
	};

* THEN DO UR DUMMIES;

	foreach var in base path mean cntf {;
		foreach n in 4_5 5_6 6_7 7_8 8_11 {;
			g `var'`n'D=`var'`n'*disc;
		};
	};

* THE SAME FOR LOG DIFFERENCE OF LOSSES RELATIVE TO MEANS;

		foreach n in 0 R E 4_5 5_6 6_7 7_8 8_11 {;
			g diffA`n'D= diffA`n'*disc;
			g diffB`n'D= diffB`n'*disc;
		};

/*-----------------------------------------------------------------*/
* SUM UP TO GENERATE PDV LOSSES;


collapse (sum) base* path* mean* diff* cntf*;
xpose, clear varname;
g ten=`ten';
g str15 sep="`sep'";
rename _varname measure;
rename v1 pdvloss;
save regsum2d3u2_`ten'_`sep', replace;
end;
/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/

* RUN THE WHOLE THING;

global tenlist 3 6;
global seplist ddd2yrmnwkd30n1 ddd2yrmnwkd80n1 ;

* load data;

loadit;

*>>>>>>>>>> run regressions <<<<<<<<<<;

foreach sep in $seplist {;
          foreach ten in $tenlist {;
				regmain1 `ten' `sep' zer;  /* ten= TENURE, sep = MLF-type, zer = variable */
 	    };
};


/*-----------------------------------------------------------------*/
* MERGE FILES TOGETHER: OUTPUT FILES;

local sep1: word 1 of $seplist;
local ten1: word 1 of $tenlist;

local seplist $seplist;
global seplist2 : list seplist-sep1;
local tenlist $tenlist;
global tenlist2 : list tenlist-ten1;

use regsum2d3u2_`ten1'_`sep1',clear;

global sep1 `sep1';
foreach ten in $tenlist2 {;
        local sep1 $sep1;                  
                   append using regsum2d3u2_`ten'_`sep1';
        };

foreach sep in $seplist2 {;
                          foreach ten in $tenlist {;
                                      append using regsum2d3u2_`ten'_`sep';
              	        };
		};
		
* SAVE IT OUT;

save regsum2d3u2, replace;

/*-----------------------------------------------------------------*/
* MERGE FILES TOGETHER: GENERATED ANNUAL LOSS+EARNINGS VALUES;

use regsum2d3u2_vars_3_ddd2yrmnwkd30n1, clear;
append using regsum2d3u2_vars_6_ddd2yrmnwkd30n1;
append using regsum2d3u2_vars_3_ddd2yrmnwkd80n1;
append using regsum2d3u2_vars_6_ddd2yrmnwkd80n1;

* SAVE IT OUT;

save regsum2d3u2_vars, replace;

/*-----------------------------------------------------------------*/
* CLEAN UP;

foreach sep in $seplist {;
                      foreach ten in $tenlist {;
                             erase regsum2d3u2_`ten'_`sep'.dta;
                             erase regsum2d3u2_vars_`ten'_`sep'.dta;
                       };
 		};

erase temp_regsum2d3u2.dta;

log close;
