#delimit ;
set more off;
capture log close;
log using figure5.log, replace;

* FIGURE 5: ANNUAL EARNINGS LOSSES BOOMS/RECESSIONS;

* OUTPUT FILES SAVED IN FOLDER FIGURES/;

/*------------------------------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------------------------------*/
capture program drop fig5;
program define fig5;

use sep ten mean0 meanR meanE base0 baseR baseE ccnt using regsum2d3u2_vars, clear; /* /* SEE REGSUM2D3U_2.DO */ */
label var ccnt "Years Before/After Displacement";
label var base0 "Avg. All Years";
label var baseR "Avg. NBER Recessions";
label var baseE "Avg. NBER Expansions";

label var mean0 "Avg. All Years";
label var meanR "Avg. NBER Recessions";
label var meanE "Avg. NBER Expansions";

sort sep ten ccnt;

foreach var in base0 baseR baseE mean0 meanR meanE {;
		local a1=.2;
		local a2=1-2*`a1';
		qui replace `var'=`var'[_n-1]*`a1'+`var'*`a2'+`var'[_n+1]*`a1' if ccnt>=2&ten==ten[_n-1]&ten==ten[_n+1]&
		sep==sep[_n-1]&sep==sep[_n+1];
};

* generate values relative to initial mean;

foreach x in E R 0 {;
	g dum=mean`x' if ccnt>=-4&ccnt<=-1;
	egen iniw`x'=mean(dum), by(sep ten);
	drop dum;
	g rel`x'=base`x'/iniw`x';
};

label var rel0 "Avg. All Years";
label var relR "Avg. NBER Recessions";
label var relE "Avg. NBER Expansions";



* SAVE OUT TO UPLOAD IN EXCEL;

	* RESHAPE;
	g str4 sep_="";
	replace sep_="30d2" if sep=="ddd2yrmnwkd30n1";
	replace sep_="30d1" if sep=="ddd1yrmnwkd30n1";
	replace sep_="80d2" if sep=="ddd2yrmnwkd80n1";
	replace sep_="plcl" if sep=="ddd1yrmnwkd100n";
	drop sep;
	global varlist base0 baseR baseE mean0 meanR meanE rel0 relR relE; 
	keep ten sep_ ccnt $varlist;
	global varlist1;
	foreach var in $varlist {;
		rename `var' `var'_;
		global varlist1 $varlist1 `var'_;
		};
	reshape wide $varlist1 , i(ten ccnt) j(sep_) string;

	* MAKE RIGHT ORDER;
	global varlist2;
	foreach var in $varlist {;
		global varlist2 $varlist2 `var'_30d2 `var'_80d2;
		};
	sort ten ccnt;
	order ten ccnt $varlist2;

	* SAVE OUT;
	outsheet using FIGURES/figure5.txt, replace;

end;
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*------------------------------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------------------------------*/
