#delimit ;
capture log close;
log using regsum2f2u.log, replace;
set more off;

* GENERATES PROJECTED PDV EARNINGS LOSSES BY YEAR OF DISPLACEMENT;

global maxcnt=20;		/* SET THIS BY HAND: HAVE AT LEAST 3 COHORTS PER CNT-YEAR */
global maxyear=2007;		
global maxdisp=2007;		
global maxcnt=$maxyear-1980;	

/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
capture program drop loadit;
program define loadit;

/*************************************************/
/* STEP 0: LOAD ORIGINAL MEANS PLUS COEFFICIENTS */
/*************************************************/

use if (sep=="ddd2yrmnwkd30n1"|sep=="ddd2yrmnwkd80n1") using ../../SSA_REPLICATION/RESULTS/basic3fYR3e_100, clear;
g year=cnt+yrgr-1;	

* RESET DIFFERENCE VIS-A-VIS FOUR YEARS BEFORE LAYOFF;

foreach var in all zer {;
		g dum=bearn`var'5 if cnt==-4;
		egen ini=sum(dum), by(yrgr sep ten);
		g dearn`var'5=bearn`var'5-ini;
		drop ini dum;
	};

sort ten sep yrgr cnt;

* GENERATE "ADJUSTED VARIABLE": SUBTRACT LOSS;

foreach var in earnzer earnall {;		/* CHECK THAT THIS WORKS */
	g c`var'0=b`var'1-b`var'5;
	g c`var'=b`var'1-d`var'5;		/* NEW (8/24/2011): USE RESET LOSS -- CHECK THAT THIS WORKS */
	};

foreach var in zer all {;
	rename cearn`var' c`var';	/* COUNTERFACTUAL MEAN */
	rename bearn`var'1 m`var';	/* ACTUAL MEAN */
	rename bearn`var'5 b`var'; 	/* LOSS */
	rename dearn`var'5 d`var'; 	/* LOSS WRT CNT=-3 */
};
rename bwork1 mwork;
rename bwork5 bwork; 

keep c* bzer dzer ball bwork m* ten sep yrgr year cnt;

sort yrgr;
tempfile temp;
save `temp';

/*************************************************/
/* STEP 0: MERGE ON INFO FROM MONTHLY UR BY YEAR */
/*************************************************/

use year value period if year>=1980&year<=$maxdisp using mntur_bls_jul2011, clear;

rename value ur;

sum ur, d;
replace ur=ur/100;

g dur4_5=0;
replace dur4_5=1 if ur<=.05;
g dur5_6=0;
replace dur5_6=1 if ur>.05&ur<=.06;
g dur6_7=0;
replace dur6_7=1 if ur>.06&ur<=.07;
g dur7_8=0;
replace dur7_8=1 if ur>.07&ur<=.08;
g dur8_11=0;
replace dur8_11=1 if ur>.08;

collapse (mean) dur*, by(year);

egen check=rsum(dur*);
sum check;	* should be identical to 1;
drop check;

sum dur*;

rename year yrgr;
sort yrgr;
merge yrgr using `temp';
tab _merge;
keep if _merge ==3; 
drop _merge;

/* GENERATE RELEVANT DUMMIES */

g dumR = 0;
replace dumR = 7/12 if yrgr==1980|yrgr==1981;
replace dumR = 9/12 if yrgr==1982;
replace dumR = 7/12 if yrgr==1990;
replace dumR = 3/12 if yrgr==1991;
replace dumR = 8/12 if yrgr==2001;
*replace dumR = 1/12 if yrgr==2007;
*replace dumR = 1 if yrgr==2008;
*replace dumR = 6/12 if yrgr==2009;
label var dumR "Indicator NBER Recession";

g dumE = 1-dumR;
label var dumE "Indicator NBER Expansion";

save temp_regsum2f2u, replace;

end;
/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/

/**************************************************/
/* STEP 1: REGRESS ON RECESSION DUMMIES		  */
/**************************************************/

/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
capture program drop regmain1;
program define regmain1;
local ten `1';
local sep `2';
global var `3';

/*--------------------------------------------------------------------*/
* LOAD AND GENERATE BASIC VARIABLES;

	use if cnt<=$maxcnt&sep=="`sep'"&ten==`ten'&yrgr<=$maxdisp&year<=$maxyear using temp_regsum2f2u, clear;

	qui tab cnt, g(dcnt);	/* GENERATE DUMMIES */

	egen group=group(cnt);	/* GENERATE COUNTER */
	sum group;
	global max=r(max);

/*--------------------------------------------------------------------*/
* FIRST OBTAIN BASIC MEAN OF AVERAGE WAGES BY THE CYCLE;

	reg c$var dcnt1-dcnt$max if ten==`ten', noconst; 	/* COUNTERFACTUAL MEAN */

	* save out coefficients;
	g cntf0=.;
	forvalues x=1/$max {;
                      qui replace cntf0=_b[dcnt`x'] in `x';
	};

	reg m$var dcnt1-dcnt$max if ten==`ten', noconst; 	/* ACTUAL MEAN */

	* save out coefficients;
	g mean0=.;
	forvalues x=1/$max {;
                      qui replace mean0=_b[dcnt`x'] in `x';
	};

	* ALSO OBTAIN AVERAGE LOSS DUE TO LAYOFF;

	reg d$var dcnt1-dcnt$max if ten==`ten', noconst; 	/* LOSS */

	* save out coefficients;
	g base0=.;
	forvalues x=1/$max {;
                      qui replace base0=_b[dcnt`x'] in `x';
	};

	g ccnt=_n-7;

/*--------------------------------------------------------------------*/
* GENERATE RATE OF DECAY BASED ON AVERAGE RECOVERY PATTERN;

* FIRST DO IT FOR NBER RECESSION DATES;

	foreach v in 2 5 6 10 11 15 20 12 18 19 {;
		g x=base0 if ccnt==`v';
		egen loss`v'=mean(x);
		drop x;
	};
	g dec2_5 = (log(abs(loss5))-log(abs(loss2)))/4;
	sum dec2_5;
	g dec6_10 = (log(abs(loss10))-log(abs(loss6)))/5;
	sum dec6_10;
	g dec11_15= (log(abs(loss15))-log(abs(loss11)))/5;
	sum dec11_15;
	g dec11_20= (log(abs(loss20))-log(abs(loss11)))/5;
	sum dec11_20;

	* take average to account for variability (or moving average);
	

	g dec=(dec6_10+dec11_15)/2;	/* choose this: use 5-10, since there most cohorts, but also 11-15 to put some weight on persistence */
	sum dec;					

* keep relevant variables;
	
	keep dec d$var c$var m$var yrgr cnt dec2_5 dec6_10; 

	* PROJECT FORWARD PATH OF EARNINGS LOSSES;

	* only sum up losses starting at year of job loss; 

	keep if cnt>0;
	sort yrgr cnt;
	tempfile temp;
	save `temp';
	clear;
	set obs 20;
	g cnt=_n;
	g n=1;
	save temp0, replace;
	forvalues y=1980/$maxdisp {;	
		use temp0, clear;
		g yrgr=`y';
		g t=_n-1;
		g disc=(1+.05)^(-t);
	 	save temp`y', replace;
	};
	use temp1980;
	forvalues y=1981/$maxdisp {;	
		append using temp`y';
		erase temp`y'.dta;
	};
	sort yrgr cnt;
	save temp, replace;
	erase temp1980.dta;
	erase temp0.dta;

	merge yrgr cnt using `temp';
	tab _merge;
	drop _merge;
	egen dec1=mean(dec2_5);
	egen dec2=mean(dec6_10);
	egen dec3=mean(dec);
	drop dec dec2_5 t n;


		* generate projected variables;

		g gap=$maxyear-yrgr+1;

		qui g pd$var=.;
		qui replace pd$var=d$var if cnt<=10&gap>=10;
		qui replace pd$var=pd$var[_n-1]*(1+dec3) if cnt>=11&gap>=10;	

		qui replace pd$var=d$var if cnt<=5&gap>=5&gap<10;
		qui replace pd$var=pd$var[_n-1]*(1+dec2) if cnt>=6&gap>=5&gap<10;
	
		qui replace pd$var=d$var if cnt<=gap&gap<5;
		qui replace pd$var=pd$var[_n-1]*(1+dec1) if cnt>gap&cnt<=5&gap<5;	
		qui replace pd$var=pd$var[_n-1]*(1+dec2) if cnt>gap&cnt>5&cnt<=10&gap<5;	
		qui replace pd$var=pd$var[_n-1]*(1+dec3) if cnt>gap&cnt>10&gap<5;	


/*--------------------------------------------------------------------*/
* DISCOUNT VALUES WITH 5% DISCOUNT Rate;

	* discount starting at t=0;

	foreach var in d$var pd$var {;
			g `var'D=`var'*disc;
		};


keep d$var* pd$var* cnt yrgr;

g ten=`ten';
g str15 sep="`sep'";

save regsum2f2u_vars_`ten'_`sep', replace;

/*-----------------------------------------------------------------*/
* SUM UP TO GENERATE PDV LOSSES;

collapse (sum) d$var* pd$var*, by(yrgr);

* CHECK RESULTS;
gr7 pdzerD dzerD yrgr, c(ll) xline(1982 1991 2002) yline(0);

g ten=`ten';
g str15 sep="`sep'";

save regsum2f2u_`ten'_`sep', replace;
end;
/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/
/*-----------------------------------------------------------------*/

* RUN THE WHOLE THING;

global tenlist 3 6;
global seplist ddd2yrmnwkd30n1 ddd2yrmnwkd80n1 ;

* load data;

loadit;

* run regressions;

foreach sep in $seplist {;
                 foreach ten in $tenlist {;
				regmain1 `ten' `sep' zer;
			};
	};


/*-----------------------------------------------------------------*/
* MERGE FILES TOGETHER: OUTPUT FILES;

local sep1: word 1 of $seplist;
local ten1: word 1 of $tenlist;

local seplist $seplist;
global seplist2 : list seplist-sep1;
local tenlist $tenlist;
global tenlist2 : list tenlist-ten1;

use regsum2f2u_`ten1'_`sep1',clear;

global sep1 `sep1';
foreach ten in $tenlist2 {;
        local sep1 $sep1;                  
                   append using regsum2f2u_`ten'_`sep1';
        };

foreach sep in $seplist2 {;
                          foreach ten in $tenlist {;
                                      append using regsum2f2u_`ten'_`sep';
              	        };
		};
		
* SAVE IT OUT;

save regsum2f2u, replace;

/*-----------------------------------------------------------------*/
* MERGE FILES TOGETHER: GENERATED ANNUAL LOSS+EARNINGS VALUES;

use regsum2f2u_vars_3_ddd2yrmnwkd30n1, clear;
append using regsum2f2u_vars_6_ddd2yrmnwkd30n1;
append using regsum2f2u_vars_3_ddd2yrmnwkd80n1;
append using regsum2f2u_vars_6_ddd2yrmnwkd80n1;

* SAVE IT OUT;

save regsum2f2u_vars, replace;

/*-----------------------------------------------------------------*/
* CLEAN UP;

foreach sep in $seplist {;
                      foreach ten in $tenlist {;
                             erase regsum2f2u_`ten'_`sep'.dta;
                             erase regsum2f2u_vars_`ten'_`sep'.dta;
                       };
 		};

erase temp_regsum2f2u.dta;

log close;
