#delimit ;
set more off;
capture log close;
log using figure7.log, replace;

* FIGURE 7: PDV ANNUAL EARNINGS LOSSES BOOMS/RECESSIONS;

* OUTPUT FILES SAVED IN FOLDER FIGURES/;

/*------------------------------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------------------------------*/
capture program drop fig7;
program define fig7;


/*----------------------------------*/
* load data;
/*----------------------------------*/

/* MERGE ON ANNUAL UR */

* prepare average annual UR;

use year urate if year>=1980&year<2006 using yearur,clear;
rename year yrgr;
sort yrgr;
tempfile temp;
save `temp';

* prepare main data;

use regsum2f2u, clear;	/* SEE REGSUM2F2U.DO */

drop if yrgr==2007|yrgr==2006;
keep pdzerD ten sep yrgr;
reshape wide pdzerD, i(sep yrgr) j(ten);
sort sep yrgr;

label var yrgr "Year of Displacement";
label var pdzerD3 "Tenure 3+";
label var pdzerD6 "Tenure 6+";

foreach var in pdzerD3 pdzerD6 {;
		local a1=.25;
		local a2=1-2*`a1';
		g `var's=`var';
		qui replace `var's=`var'[_n-1]*`a1'+`var'*`a2'+`var'[_n+1]*`a1' if yrgr>=1971&yrgr<=2002&sep==sep[_n-1]&sep==sep[_n+1];
};

label var pdzerD3s "Tenure 3+";
label var pdzerD6s "Tenure 6+";

* merge;

sort yrgr;
merge yrgr using `temp';
tab _merge;
keep if _merge==3;
drop _merge;

label var ur "Unemployment Rate at Displacement";


/* MERGE ON INITIAL WAGE LEVEL */

tempfile temp;
sort sep yrgr;
save `temp';

use sep ten cnt yrgr bearnall1 if cnt>=-4&cnt<=-1 & (sep=="ddd2yrmnwkd30n1"|sep=="ddd2yrmnwkd80n1") using ../../SSA_REPLICATION/RESULTS/basic3fYR3e_100, clear;
collapse (mean) bearnall1, by(yrgr ten sep);
keep yrgr ten sep bearnall1;
rename bearnall1 iniw;

reshape wide iniw, i(sep yrgr) j(ten);
sort sep yrgr;
merge sep yrgr using `temp';
tab _merge;
keep if _merge==3;
drop _merge;
foreach var in pdzerD {;
	g rel`var'3=`var'3/iniw3;
	g rel`var'6=`var'6/iniw6;
};

/*----------------------------------*/
* make figures;
/*----------------------------------*/


* WITHOUT TITLE FOR PAPER;

scatter relpdzerD3 ur if sep=="ddd2yrmnwkd30n1", m(d o p) clw(medthick medthick medthick) ml(yrgr) ytitle("PDV Earnings Loss/Initial Wage") 
graphregion(color(white)) plotregion(lcolor(black) lwidth(medthin)) ylabel(, nogrid)
saving(FIGURES/figure7, replace);

graph export FIGURES/figure7.wmf, replace;
graph export FIGURES/figure7.eps, replace;

* SAVE OUT TO UPLOAD IN EXCEL;

	* RESHAPE;
	*keep if sep=="ddd2yrmnwkd30n1"&ten==3;
	g str4 sep_="";
	replace sep_="30d2" if sep=="ddd2yrmnwkd30n1";
	replace sep_="30d1" if sep=="ddd1yrmnwkd30n1";
	replace sep_="80d2" if sep=="ddd2yrmnwkd80n1";
	replace sep_="plcl" if sep=="ddd1yrmnwkd100n";
	drop sep;
	global varlist relpdzerD3 relpdzerD6 pdzerD3 pdzerD6 pdzerD3s pdzerD6s;
	keep sep_ $varlist ur yrgr;
	global varlist1;
	foreach var in $varlist {;
		rename `var' `var'_;
		global varlist1 $varlist1 `var'_;
		};
	reshape wide $varlist1 , i(ur) j(sep_) string;
	* MAKE RIGHT ORDER;
	global varlist2;
	foreach var in $varlist {;
		global varlist2 $varlist2 `var'_30d2 `var'_80d2;
		};
	sort yrgr;
	order yrgr ur $varlist2;
	* SAVE OUT;
	outsheet using FIGURES/figure7.txt, replace;

end; /* end program: fig7 */
/*------------------------------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------------------------------*/

* RUN IT ALL ;

fig7;  /* fig 7 */

log close;
