%
% Caclulate standard errors for Table 4 for the 2011 Brookings Paper "Let's
%   Twist Again," by Eric Swanson.
%
% code written by Eric Swanson, March 2011
%

clear all ;

load Moodys_Corporate_yields.txt ;

data = Moodys_Corporate_yields ;

data = data(find(all(~isnan(data),2)),:) ; % drop holidays

yr = data(:,1) ;
mo = data(:,2) ;
dy = data(:,3) ;

yields = data(:,4:5) ;

Dyields = diff(yields)*100 ; % daily yield change in basis points
Dyields2 = (yields(3:end,:) - yields(1:end-2,:)) *100 ; % 2-day yield change
Dyields3 = (yields(4:end,:) - yields(1:end-3,:)) *100 ; % 3-day yield change

%i62 = find(yr==1962 | (yr==1961 & mo>5)) ;
i62 = find(yr==1962) ;
i62 = i62(1:end-1) ;

fprintf('Daily standard deviation in 1962:\n') ;
std(Dyields(i62,:))

omegahat = Dyields(i62,:)'*Dyields(i62,:) /length(i62) ;
omegahat2 = Dyields2(i62(1:2:end)-1,:)'*Dyields2(i62(1:2:end)-1,:) /length(i62(1:2:end)) ;
omegahat3 = Dyields3(i62(1:3:end)-1,:)'*Dyields3(i62(1:3:end)-1,:) /length(i62(1:3:end)) ;

omegahat9 = omegahat + omegahat2 + 2*omegahat3 ;
omegahat13 = omegahat + 3*omegahat2 + 2*omegahat3 ;

[sqrt(diag(omegahat))'; sqrt(diag(omegahat2))'; sqrt(diag(omegahat3))'; ...
    sqrt(diag(omegahat9))'; sqrt(diag(omegahat13))']


