%
% Caclulate standard errors for Table 3 and associated Wald statistics and p-values
%   for the 2011 Brookings Paper "Let's Twist Again," by Eric Swanson.
%
% code written by Eric Swanson, December 2010, updated March 2011
%

load FAME_Treasury_yields.txt ;

data = FAME_Treasury_yields ;

data = data(find(all(~isnan(data),2)),:) ; % drop holidays

yr = data(:,1) ;
mo = data(:,2) ;
dy = data(:,3) ;

yields = data(:,4:9) ;

Dyields = diff(yields)*100 ; % daily yield change in basis points
Dyields2 = (yields(3:end,:) - yields(1:end-2,:)) *100 ; % 2-day yield change
Dyields3 = (yields(4:end,:) - yields(1:end-3,:)) *100 ; % 3-day yield change

i62 = find(yr==1962) ;

fprintf('Daily standard deviation in 1962:\n') ;
std(Dyields(i62,:))

omegahat = Dyields(i62,:)'*Dyields(i62,:) /length(i62) ;
omegahat2 = Dyields2(i62(1:2:end)+1,:)'*Dyields2(i62(1:2:end)+1,:) /length(i62(1:2:end)) ;
omegahat3 = Dyields3(i62(1:3:end)+1,:)'*Dyields3(i62(1:3:end)+1,:) /length(i62(1:3:end)) ;
  % omegahat3 is used in Table 4, not Table 3

omegahat6 = 2*omegahat + 2*omegahat2 ;
omegahat8 = 4*omegahat + 2*omegahat2 ;
omegahat9 = omegahat + omegahat2 + 2*omegahat3 ; % used in Table 4, not Table 3
omegahat13 = omegahat + 3*omegahat2 + 2*omegahat3 ; % used in Table 4, not Table 3

[sqrt(diag(omegahat))'; sqrt(diag(omegahat2))'; sqrt(diag(omegahat6))'; sqrt(diag(omegahat8))']


response1 = [1    -0.7  -4.3  -3.5 -3.7  -4]' ;
response2 = [-0.2  3     3.7  -2   -3.3  -1.5]' ;
response3 = [2.8   4      2    1    -1   -1]' ;
response4 = [11    6    -2.7  -9    -8   -6]' ;
response5 = [-2.5 -3.5   -1    8.5  3.3   1.5]' ;
response6 = [-0.2  -5   -1.3  -1   -0.3  -1.5]' ;


wald1 = response1' /omegahat * response1
p1 = 1 - chi2cdf(wald1,6)

wald2 = response2' /omegahat * response2
p2 = 1 - chi2cdf(wald2,6)

wald3 = response3' /omegahat2 * response3
p3 = 1 - chi2cdf(wald3,6)

wald4 = response4' /omegahat2 * response4
p4 = 1 - chi2cdf(wald4,6)

wald5 = response5' /omegahat * response5
p5 = 1 - chi2cdf(wald5,6)

wald6 = response6' /omegahat * response6
p6 = 1 - chi2cdf(wald6,6)



cumresponse1 = [14.7  12.3  -1.3  -13.5  -16  -12.5]' ;
cumresponse2 = [12    3.8   -3.7   -6    -13  -12.5]' ;

cumwald1 = cumresponse1' /omegahat6 * cumresponse1
cump1 = 1 - chi2cdf(cumwald1,6)

cumwald2 = cumresponse2' /omegahat8 * cumresponse2
cump2 = 1 - chi2cdf(cumwald2,6)

