cd /DIRECTORY PATH HERE

**note: this file was created in Stata 11 SE and uses the contributed command esttab

use lst_bpea_public_unitedstates.dta

global controls "chngwlth_dum2 - chngwlth_dum8 inc_dum2 - inc_dum9 finwlth_dum2 - finwlth_dum10 tradetech somecoll coll grad unemploy age_three_2 age_three_3 gender black hispan asian otherraceethnic nvrmar divwid othermar  childhh liveparents reg_ne reg_mw reg_w chngwlth_dum1 inc_dum10 finwlth_dum11"

mark nomiss
markout nomiss gender age_three_2 grad black nvrmar reg_ne liveparents emerg_2a unemploy childhh

svyset respid [pw=indi_weights]


**Table 1**
for var chngwlth income finwlth hsorless tradetech coll grad unemploy age_three gender race marcohab nvrmar divwid othermar childhh liveparents region: ///
svy: tab X emerg_2b, row, if nomiss == 1 


**Table 2**
eststo clear
eststo: dprobit emerg_2a ///
$controls ///
if nomiss == 1 ///
[pw=indi_weights]

eststo: dprobit emerg_2a ///
$controls ///
gambled fined risk_cor_all ///
if nomiss == 1 ///
[pw=indi_weights]

esttab using table_2.txt, replace margin nodiscrete pr2 wide b(3) starlevels(+ 0.10 * 0.05 ** 0.01 *** 0.001) ///
stardetach modelwidth(7) varwidth(25) label nonumbers mtitles("Model 1" "Model 2")


**TABLE 3**
svy: tab emerg_3_numways if nomiss == 1 

for var emerg_3r emerg_3s emerg_3t_main emerg_3t_afs emerg_3u emerg_3k: ///
svy: tab emerg_3_numways X, row, if nomiss == 1 

for var emerg_3a emerg_3b emerg_3q emerg_3i emerg_3j emerg_3e emerg_3f emerg_3g emerg_3h emerg_3k emerg_3l emerg_3m emerg_3n emerg_3p: ///
svy: tab emerg_3_numways X, row, if nomiss == 1 


**Table 4**
svy: tab emerg_3_numways emerg_2b, col, if nomiss == 1 & emerg_2b != 4 


**Table 5**
eststo clear
for var emerg_3r emerg_3s emerg_3t_main emerg_3t_afs emerg_3u emerg_3k: eststo: dprobit  X $controls  gambled fined risk_cor_all if nomiss == 1 & emerg_3_numways != . ///
[pw=indi_weights]

esttab using table_5.txt, replace margin nodiscrete pr2 wide b(3) starlevels(+ 0.10 * 0.05 ** 0.01 *** 0.001) ///
stardetach modelwidth(7) varwidth(25) label nonumbers mtitles("Savings" "Family/Friends" "Mainstream Credit" "AFS Credit" "Sell Things" "Work More") ///
title(Table 5.  Relationship between Economic and Demographic Characteristics and Types of Coping Responses, Additional Controls) ///
addnotes("Savings = (1) draw from savings, (2) liquidate or sell investments, (3) borrow against retirement savings, and/or (4) liquidiate some retirement investments" ///
"Family/Friends = (1) borrow or ask for help from family and/or (2) borrow or ask for help from my friends (not family)" ///
"Mainstream Credit = (1) use credit cards, (2) open or use home equity line of credit/second mortgage, and/or (3) unsecured loan" ///
"AFS Credit = (1) payday or payroll advance loan and/or (2) pawn an asset" ///
"Sell Things = (1) sell things I owned, except my home and/or (2) sell my home" ///
"Work More = (1) Work overtime, get a second job, or another member of my household would work longer or go to work")

clear

use lst_bpea_public_eightcountries.dta
svyset respid [pw=indi_weights]

**Table 6**
for var emerg_2b emerg_3r emerg_3s emerg_3t_main emerg_3t_afs emerg_3u emerg_3k emerg_3o emerg_3p emerg_3_numways: ///
svy: tab X country, col

**note: publication tabulations for the US are restricted to those with non-missing data on the covariates used in the models presented in Tables 2 and 5


**Table 7**
global controls_8 "chngwlth_dum2 - chngwlth_dum8 harmed_dum1 harmed_dum2 harmage_dum2 harmage_dum3 gender childhh gambled fined risk_cor_all chngwlth_dum1 "

mark nomiss_8
markout nomiss_8 childhh gender harmage_dum2 harmed_dum2 gambled fined risk_cor_all

keep if nld != 1

eststo clear
eststo: dprobit emerg_2a ///
gb ger por fr cnd ity ///
if nomiss_8 == 1 ///
[pw=pop_weights], vce(cluster country)

eststo: dprobit emerg_2a ///
gb ger por fr cnd ity ///
$controls_8 ///
if nomiss == 1 ///
[pw=pop_weights], vce(cluster country)

esttab using table_7.txt, replace margin nodiscrete pr2 wide b(3) starlevels(+ 0.10 * 0.05 ** 0.01 *** 0.001) ///
stardetach modelwidth(7) varwidth(25) label nonumbers mtitles("Model 1" "Model 2") ///
drop(chngwlth_dum* harmed_dum1 harmed_dum2 harmage_dum2 harmage_dum3 gender childhh gambled fined risk_cor_all)





clear


