
/***********************************************************************************************
This do file combines principal/school/district datasets from all SASS surveys.
***********************************************************************************************/

# delimit;
capture log close;
capture program drop all;
clear;
clear matrix;
set more off;
set mem 500M;

global data "C:/Users/nschwart/Desktop/nclb_final/sass_folder/raw_data/";


/*********************
2007
*********************/

/*2007 Principal data*/
use "${data}prin07.dta";
destring STATE, replace;
rename A0240 p_male;
replace p_male=. if p_male==-8 | p_male==-9;
replace p_male = 0 if p_male==2;
rename AGE_P p_age;
gen p_hispanic = 0;
replace p_hispanic = 1 if RACETH_P==1 | RACETH_P==2 | RACETH_P==4 | RACETH_P==7 | RACETH_P==8 | RACETH_P==9 | RACETH_P==16 | RACETH_P==17
 | RACETH_P==20 | RACETH_P==22 | RACETH_P==24 | RACETH_P==25 | RACETH_P==31;
replace p_hispanic=. if RACETH_P==. | RACETH_P<0;
gen p_white_nh=0;
label var p_white_nh "White, not Hispanic";
replace p_white_nh = 1 if RACETH_P==47;
replace p_white_nh=. if RACETH_P==. | RACETH_P<0;
gen p_black_nh = 0;
label var p_black_nh "Black, not Hispanic";
replace p_black_nh = 1 if RACETH_P==39 | RACETH_P==40 | RACETH_P==42 | RACETH_P==43;
replace p_black_nh=. if RACETH_P==. | RACETH_P<0;
gen p_other=0;
replace p_other=1 if RACETH_P==32 | RACETH_P==33 | RACETH_P==34 | RACETH_P==35 | RACETH_P==36 | RACETH_P==37 | RACETH_P==48
 | RACETH_P==49 | RACETH_P==51 | RACETH_P==53 | RACETH_P==55 | RACETH_P==56 | RACETH_P==62;
 replace p_other=. if RACETH_P==.  | RACETH_P<0;
gen skills_priority=0;
replace skills_priority=1 if A0040==1;
gen skills_or_excellence=0;
replace skills_or_excellence=1 if A0040==1 | A0040==2;
gen excellence_priority = 0;
replace excellence_priority = 1 if A0040 ==2;
gen skills_topthree = 0;
replace skills_topthree = 1 if A0040==1 | A0041==1 | A0042==1;
gen excellence_topthree = 0;
replace excellence_topthree = 1 if A0040==2 | A0041==2 | A0042==2;
gen skills_over_excellence = 0;
replace skills_over_excellence = 1 if A0040==1 | (A0041==1&A0040~=2) | (A0042==1 & A0041~=2 & A0040~=2);
gen sk_or_exc_or_disc = 0;
replace sk_or_exc_or_disc = 1 if A0040==1 | A0040==2 | A0040==4;
gen prin_disc=0;
replace prin_disc=1 if A0040==4;
gen survey_year=2007;
keep skills_priority skills_or_excellence excellence_priority skills_topthree excellence_topthree skills_over_excellence CNTLNUMS survey_year
p_male p_age RACETH_P p_hispanic p_white_nh p_black_nh p_other AFNLWGT STATE sk_or_exc_or_disc prin_disc;
save "${data}temp_prin07.dta", replace;

/*2007 School data*/
use "${data}pubsch07.dta";
rename URBANS8 URBANIC;
rename S0038 s_ungraded;
rename S0025 s_kind;
rename S0026 s_first;
rename S0027 s_second;
rename S0028 s_third;
rename S0029 s_fourth;
rename S0030 s_fifth;
rename S0031 s_sixth;
rename S0032 s_seventh;
rename S0033 s_eighth;
rename S0034 s_ninth;
rename S0035 s_tenth;
rename S0036 s_eleventh;
rename S0037 s_twelfth;
replace s_ungraded=0 if s_ungraded==-8 | s_ungraded==-9 | s_ungraded==.;
replace s_kind=0 if s_kind==-8 | s_kind==-9 | s_kind==.;
replace s_first=0 if s_first==-8 | s_first==-9 | s_first==.;
replace s_second=0 if s_second==-8 | s_second==-9 | s_second==.;
replace s_third=0 if s_third==-8 | s_third==-9 | s_third==.;
replace s_fourth=0 if s_fourth==-8 | s_fourth==-9 | s_fourth==.;
replace s_fifth=0 if s_fifth==-8 | s_fifth==-9 | s_fifth==.;
replace s_sixth=0 if s_sixth==-8 | s_sixth==-9 | s_sixth==.;
replace s_seventh=0 if s_seventh==-8 | s_seventh==-9 | s_seventh==.;
replace s_eighth=0 if s_eighth==-8 | s_eighth==-9 | s_eighth==.;
replace s_ninth=0 if s_ninth==-8 | s_ninth==-9 | s_ninth==.;
replace s_tenth=0 if s_tenth==-8 | s_tenth==-9 | s_tenth==.;
replace s_eleventh=0 if s_eleventh==-8 | s_eleventh==-9 | s_eleventh==.;
replace s_twelfth=0 if s_twelfth==-8 | s_twelfth==-9 | s_twelfth==.;
rename S0039 school_enroll;
replace school_enroll=0 if school_enroll==-8;
replace school_enroll=. if school_enroll==-9;
gen sch_minutes=.;
rename S0051 sch_hrs;
replace sch_hrs=. if sch_hrs==-8 | sch_hrs==-9;
rename S0052 sch_min;
replace sch_min=. if sch_min==-8 | sch_min==-9;
replace sch_hrs = sch_hrs*60;
replace sch_minutes = sch_hrs+sch_min;
drop sch_hrs;
drop sch_min;
rename IEP pct_iep;
replace pct_iep = . if pct_iep==-8 | pct_iep==-9;
rename LEP pct_lep;
replace pct_lep=. if pct_lep==-8 | pct_lep==-9;
rename MINENR pct_min;
replace pct_min = 0 if pct_min==-8;
replace pct_min = . if pct_min==-9;
replace S0217=0 if S0215==2;
replace S0217=0 if S0217==-8;
replace S0217=. if S0217==-9;
gen pct_lunch = (S0217/school_enroll)*100;
gen survey_year=2007;
keep survey_year pct_lunch pct_min pct_iep pct_lep sch_minutes school_enroll CNTLNUMS CNTLNUMD SC_ZIP
 s_ungraded s_kind s_first s_second s_third s_fourth s_fifth s_sixth s_seventh s_eighth s_ninth s_tenth s_eleventh s_twelfth SCHLEVE2;
save "${data}temp_sch07.dta", replace;

/*********************
2003
*********************/

/*2003 Principal data*/
use "${data}newprin_03.dta";

destring STATE, replace;
rename A0254 p_male;
replace p_male=. if p_male==-8 | p_male==-9;
replace p_male = 0 if p_male==2;
rename AGE_P p_age;
gen p_hispanic = 0;
replace p_hispanic = 1 if RACETH_P==1 | RACETH_P==2 | RACETH_P==4 | RACETH_P==7 | RACETH_P==8 | RACETH_P==9 | RACETH_P==16 | RACETH_P==17
 | RACETH_P==20 | RACETH_P==22 | RACETH_P==24 | RACETH_P==25 | RACETH_P==31;
replace p_hispanic=. if RACETH_P==. | RACETH_P<0;
gen p_white_nh=0;
label var p_white_nh "White, not Hispanic";
replace p_white_nh = 1 if RACETH_P==47;
replace p_white_nh=. if RACETH_P==. | RACETH_P<0;
gen p_black_nh = 0;
label var p_black_nh "Black, not Hispanic";
replace p_black_nh = 1 if RACETH_P==39 | RACETH_P==40 | RACETH_P==42 | RACETH_P==43;
replace p_black_nh=. if RACETH_P==. | RACETH_P<0;
gen p_other=0;
replace p_other=1 if  RACETH_P==32 | RACETH_P==33 | RACETH_P==34 | RACETH_P==35 | RACETH_P==36 | RACETH_P==37 | RACETH_P==48
 | RACETH_P==49 | RACETH_P==51 | RACETH_P==53 | RACETH_P==55 | RACETH_P==56 | RACETH_P==62;
 replace p_other=. if RACETH_P==.  | RACETH_P<0;
gen skills_priority=0;
replace skills_priority=1 if A0056==1;
gen skills_or_excellence=0;
replace skills_or_excellence=1 if A0056==1 | A0056==2;
gen excellence_priority = 0;
replace excellence_priority = 1 if A0056 ==2;
gen skills_topthree = 0;
replace skills_topthree = 1 if A0056==1 | A0057==1 | A0058==1;
gen excellence_topthree = 0;
replace excellence_topthree = 1 if A0056==2 | A0057==2 | A0058==2;
gen skills_over_excellence = 0;
replace skills_over_excellence = 1 if A0056==1 | (A0057==1&A0056~=2) | (A0058==1 & A0057~=2 & A0056~=2);
gen sk_or_exc_or_disc = 0;
replace sk_or_exc_or_disc = 1 if A0056==1 | A0056==2 | A0056==4;
gen prin_disc=0;
replace prin_disc=1 if A0056==4;
gen survey_year=2003;
keep skills_priority skills_or_excellence excellence_priority skills_topthree excellence_topthree skills_over_excellence CNTLNUMS survey_year
p_male p_age RACETH_P p_hispanic p_white_nh p_black_nh p_other AFNLWGT STATE sk_or_exc_or_disc prin_disc;
save "${data}temp_prin03.dta", replace;

/*2003 School data*/
use "${data}newsch_03.dta";
rename URBANS03 URBANIC;
rename S0413 s_ungraded;
rename S0400 s_kind;
rename S0401 s_first;
rename S0402 s_second;
rename S0403 s_third;
rename S0404 s_fourth;
rename S0405 s_fifth;
rename S0406 s_sixth;
rename S0407 s_seventh;
rename S0408 s_eighth;
rename S0409 s_ninth;
rename S0410 s_tenth;
rename S0411 s_eleventh;
rename S0412 s_twelfth;
replace s_ungraded=0 if s_ungraded==-8 | s_ungraded==-9 | s_ungraded==.;
replace s_kind=0 if s_kind==-8 | s_kind==-9 | s_kind==.;
replace s_first=0 if s_first==-8 | s_first==-9 | s_first==.;
replace s_second=0 if s_second==-8 | s_second==-9 | s_second==.;
replace s_third=0 if s_third==-8 | s_third==-9 | s_third==.;
replace s_fourth=0 if s_fourth==-8 | s_fourth==-9 | s_fourth==.;
replace s_fifth=0 if s_fifth==-8 | s_fifth==-9 | s_fifth==.;
replace s_sixth=0 if s_sixth==-8 | s_sixth==-9 | s_sixth==.;
replace s_seventh=0 if s_seventh==-8 | s_seventh==-9 | s_seventh==.;
replace s_eighth=0 if s_eighth==-8 | s_eighth==-9 | s_eighth==.;
replace s_ninth=0 if s_ninth==-8 | s_ninth==-9 | s_ninth==.;
replace s_tenth=0 if s_tenth==-8 | s_tenth==-9 | s_tenth==.;
replace s_eleventh=0 if s_eleventh==-8 | s_eleventh==-9 | s_eleventh==.;
replace s_twelfth=0 if s_twelfth==-8 | s_twelfth==-9 | s_twelfth==.;
rename S0414 school_enroll;
replace school_enroll=0 if school_enroll==-8;
replace school_enroll=. if school_enroll==-9;
gen sch_minutes=.;
rename S0424 sch_hrs;
replace sch_hrs=. if sch_hrs==-8 | sch_hrs==-9;
rename S0425 sch_min;
replace sch_min=. if sch_min==-8 | sch_min==-9;
replace sch_hrs = sch_hrs*60;
replace sch_minutes = sch_hrs+sch_min;
drop sch_hrs;
drop sch_min;
rename IEP pct_iep;
replace pct_iep = . if pct_iep==-8 | pct_iep==-9;
rename LEP pct_lep;
replace pct_lep=. if pct_lep==-8 | pct_lep==-9;
rename MINENR pct_min;
replace pct_min = 0 if pct_min==-8;
replace pct_min = . if pct_min==-9;
replace S0634=0 if S0632==2;
replace S0634=0 if S0634==-8;
replace S0634=. if S0634==-9;
gen pct_lunch = (S0634/school_enroll)*100;
gen survey_year=2003;
keep survey_year pct_lunch pct_min pct_iep pct_lep sch_minutes school_enroll CNTLNUMS CNTLNUMD SC_ZIP URBANIC
 s_ungraded s_kind s_first s_second s_third s_fourth s_fifth s_sixth s_seventh s_eighth s_ninth s_tenth s_eleventh s_twelfth SCHLEVE2;
save "${data}temp_sch03.dta", replace;

/*********************
1999
*********************/

/*1999 Principal data*/
use "${data}newprin_99.dta";
rename state STATE;
destring STATE, replace;
rename afnlwgt AFNLWGT;
rename raceth_p RACETH_P;
gen p_hispanic = 0;
replace p_hispanic = 1 if RACETH_P==5;
replace p_hispanic=. if RACETH_P==. | RACETH_P==-8 | RACETH_P==-9;
gen p_white_nh = 0;
label var p_white_nh "White, not Hispanic";
replace p_white_nh = 1 if RACETH_P==4;
replace p_white_nh=. if RACETH_P==. | RACETH_P==-8 | RACETH_P==-9;
gen p_black_nh = 0;
label var p_black_nh "Black, not Hispanic";
replace p_black_nh = 1 if RACETH_P==3;
replace p_black_nh=. if RACETH_P==. | RACETH_P==-8 | RACETH_P==-9;
gen p_other=0;
replace p_other = 1 if RACETH_P==2 | RACETH_P==1;
replace p_other=. if RACETH_P==. | RACETH_P==-8 | RACETH_P==-9;
rename a0227 p_male;
replace p_male=. if p_male==-8 | p_male==-9;
replace p_male = 0 if p_male==2;
rename age_p p_age;
gen skills_priority=0;
replace skills_priority=1 if a0067==1;
gen skills_or_excellence=0;
replace skills_or_excellence=1 if a0067==1 | a0067==2;
gen excellence_priority = 0;
replace excellence_priority = 1 if a0067 ==2;
gen skills_topthree = 0;
replace skills_topthree = 1 if a0067==1 | a0068==1 | a0069==1;
gen excellence_topthree = 0;
replace excellence_topthree = 1 if a0067==2 | a0068==2 | a0069==2;
gen skills_over_excellence = 0;
replace skills_over_excellence = 1 if a0067==1 | (a0068==1&a0067~=2) | (a0069==1 & a0068~=2 & a0067~=2);
gen sk_or_exc_or_disc = 0;
replace sk_or_exc_or_disc = 1 if a0067==1 | a0067==2 | a0067==4;
gen prin_disc=0;
replace prin_disc=1 if a0067==4;
rename schcntl CNTLNUMS;
gen survey_year=1999;
keep skills_priority skills_or_excellence excellence_priority skills_topthree excellence_topthree skills_over_excellence CNTLNUMS survey_year
p_male p_age RACETH_P p_hispanic p_white_nh p_black_nh p_other AFNLWGT STATE sk_or_exc_or_disc prin_disc;
save "${data}temp_prin99.dta", replace;

/*1999 District data*/
use "${data}dist99.dta";
gen CNTLNUMD=substr(cntlnum, 1,5);
rename d0470 days;
gen survey_year=1999;
save "${data}temp_dist99.dta", replace;

/*1999 School data*/
use "${data}newsch_99.dta";
rename urbanic URBANIC;
rename schleve2 SCHLEVE2;
rename s0090 s_ungraded;
rename s0060 s_kind;
rename s0066 s_first;
rename s0068 s_second;
rename s0070 s_third;
rename s0072 s_fourth;
rename s0074 s_fifth;
rename s0076 s_sixth;
rename s0078 s_seventh;
rename s0080 s_eighth;
rename s0082 s_ninth;
rename s0084 s_tenth;
rename s0086 s_eleventh;
rename s0088 s_twelfth;
replace s_ungraded=0 if s_ungraded==-8 | s_ungraded==-9 | s_ungraded==.;
replace s_kind=0 if s_kind==-8 | s_kind==-9 | s_kind==.;
replace s_first=0 if s_first==-8 | s_first==-9 | s_first==.;
replace s_second=0 if s_second==-8 | s_second==-9 | s_second==.;
replace s_third=0 if s_third==-8 | s_third==-9 | s_third==.;
replace s_fourth=0 if s_fourth==-8 | s_fourth==-9 | s_fourth==.;
replace s_fifth=0 if s_fifth==-8 | s_fifth==-9 | s_fifth==.;
replace s_sixth=0 if s_sixth==-8 | s_sixth==-9 | s_sixth==.;
replace s_seventh=0 if s_seventh==-8 | s_seventh==-9 | s_seventh==.;
replace s_eighth=0 if s_eighth==-8 | s_eighth==-9 | s_eighth==.;
replace s_ninth=0 if s_ninth==-8 | s_ninth==-9 | s_ninth==.;
replace s_tenth=0 if s_tenth==-8 | s_tenth==-9 | s_tenth==.;
replace s_eleventh=0 if s_eleventh==-8 | s_eleventh==-9 | s_eleventh==.;
replace s_twelfth=0 if s_twelfth==-8 | s_twelfth==-9 | s_twelfth==.;
rename s0092 school_enroll;
replace school_enroll=0 if school_enroll==-8;
replace school_enroll=. if school_enroll==-9;
gen sch_minutes=.;
rename s0102 sch_hrs;
replace sch_hrs=. if sch_hrs==-8 | sch_hrs==-9;
rename s0103 sch_min;
replace sch_min=. if sch_min==-8 | sch_min==-9;
replace sch_hrs = sch_hrs*60;
replace sch_minutes = sch_hrs+sch_min;
drop sch_hrs;
drop sch_min;
rename iep pct_iep;
replace pct_iep = . if pct_iep==-8 | pct_iep==-9;
rename lep pct_lep;
replace pct_lep=. if pct_lep==-8 | pct_lep==-9;
rename minenr pct_min;
replace pct_min = 0 if pct_min==-8;
replace pct_min = . if pct_min==-9;
replace s0287=0 if s0282==2;
replace s0287=0 if s0287==-8;
replace s0287=. if s0287==-9;
gen pct_lunch = (s0287/school_enroll)*100;
gen CNTLNUMD=substr(cntlnum, 1,5);
rename schcntl CNTLNUMS;
rename sc_zip SC_ZIP;
gen survey_year=1999;
keep survey_year pct_lunch pct_min pct_iep pct_lep sch_minutes school_enroll CNTLNUMS CNTLNUMD  SC_ZIP URBANIC
 s_ungraded s_kind s_first s_second s_third s_fourth s_fifth s_sixth s_seventh s_eighth s_ninth s_tenth s_eleventh s_twelfth SCHLEVE2;
save "${data}temp_sch99.dta", replace;

/*********************
1993
*********************/

/*1993 Principal data*/
use "${data}newprin_93.dta";
rename state STATE;
rename  admwgt AFNLWGT;
rename race_eth RACETH_P;
gen p_hispanic = 0;
replace p_hispanic = 1 if RACETH_P==5;
replace p_hispanic=. if RACETH_P==. | RACETH_P==-8 | RACETH_P==-9;
gen p_white_nh = 0;
label var p_white_nh "White, not Hispanic";
replace p_white_nh = 1 if RACETH_P==4;
replace p_white_nh=. if RACETH_P==. | RACETH_P==-8 | RACETH_P==-9;
gen p_black_nh = 0;
label var p_black_nh "Black, not Hispanic";
replace p_black_nh = 1 if RACETH_P==3;
replace p_black_nh=. if RACETH_P==. | RACETH_P==-8 | RACETH_P==-9;
gen p_other=0;
replace p_other = 1 if RACETH_P==2 | RACETH_P==1;
replace p_other=. if RACETH_P==. | RACETH_P==-8 | RACETH_P==-9;
rename a890 p_male;
replace p_male=. if p_male==-8 | p_male==-9;
replace p_male = 0 if p_male==2;
rename age p_age;
gen skills_priority=0;
replace skills_priority=1 if a875==1;
gen skills_or_excellence=0;
replace skills_or_excellence=1 if a875==1 | a875==2;
gen excellence_priority = 0;
replace excellence_priority = 1 if a875 ==2;
gen skills_topthree = 0;
replace skills_topthree = 1 if a875==1 | a880==1 | a885==1;
gen excellence_topthree = 0;
replace excellence_topthree = 1 if a875==2 | a880==2 | a885==2;
gen skills_over_excellence = 0;
replace skills_over_excellence = 1 if a875==1 | (a880==1&a875~=2) | (a885==1 & a880~=2 & a875~=2);
gen sk_or_exc_or_disc = 0;
replace sk_or_exc_or_disc = 1 if a875==1 | a875==2 | a875==4;
gen prin_disc=0;
replace prin_disc=1 if a875==4;
rename schcntl CNTLNUMS;
gen survey_year=1993;
keep skills_priority skills_or_excellence excellence_priority skills_topthree excellence_topthree skills_over_excellence CNTLNUMS survey_year
p_male p_age RACETH_P p_hispanic p_white_nh p_black_nh p_other AFNLWGT STATE sk_or_exc_or_disc prin_disc;
save "${data}temp_prin93.dta", replace;

/*1993 School data*/
use "${data}newsch_93.dta";
rename urbanic URBANIC;
rename s0115 s_ungraded;
rename s0125 s_kind;
rename s0135 s_first;
rename s0145 s_second;
rename s0155 s_third;
rename s0165 s_fourth;
rename s0175 s_fifth;
rename s0185 s_sixth;
rename s0195 s_seventh;
rename s0205 s_eighth;
rename s0215 s_ninth;
rename s0225 s_tenth;
rename s0235 s_eleventh;
rename s0245 s_twelfth;
replace s_ungraded=0 if s_ungraded==-8 | s_ungraded==-9 | s_ungraded==.;
replace s_kind=0 if s_kind==-8 | s_kind==-9 | s_kind==.;
replace s_first=0 if s_first==-8 | s_first==-9 | s_first==.;
replace s_second=0 if s_second==-8 | s_second==-9 | s_second==.;
replace s_third=0 if s_third==-8 | s_third==-9 | s_third==.;
replace s_fourth=0 if s_fourth==-8 | s_fourth==-9 | s_fourth==.;
replace s_fifth=0 if s_fifth==-8 | s_fifth==-9 | s_fifth==.;
replace s_sixth=0 if s_sixth==-8 | s_sixth==-9 | s_sixth==.;
replace s_seventh=0 if s_seventh==-8 | s_seventh==-9 | s_seventh==.;
replace s_eighth=0 if s_eighth==-8 | s_eighth==-9 | s_eighth==.;
replace s_ninth=0 if s_ninth==-8 | s_ninth==-9 | s_ninth==.;
replace s_tenth=0 if s_tenth==-8 | s_tenth==-9 | s_tenth==.;
replace s_eleventh=0 if s_eleventh==-8 | s_eleventh==-9 | s_eleventh==.;
replace s_twelfth=0 if s_twelfth==-8 | s_twelfth==-9 | s_twelfth==.;
rename stcnty stcnty_fips;
rename s0255 school_enroll;
gen sch_minutes=.;
rename s0470 sch_hrs;
rename s0475 sch_min;
replace sch_hrs = sch_hrs*60;
replace sch_minutes = sch_hrs+sch_min;
drop sch_hrs;
drop sch_min;
replace s1385=0 if s1380==2;
gen pct_iep = (s1385/school_enroll)*100;
replace s1295=0 if s1290==2;
gen pct_lep = (s1295/school_enroll)*100;
rename pminenr pct_min;
replace s1660=0 if s1650==2;
gen pct_lunch = (s1660/school_enroll)*100;
gen survey_year=1993;
rename leacntl CNTLNUMD;
rename schcntl CNTLNUMS;
gen lowest=0;
gen highest=0;
gen SCHLEVE2=.;
replace lowest = 12 if s_twelfth==1;
replace lowest = 11 if s_eleventh==1;
replace lowest = 10 if s_tenth==1;
replace lowest = 9 if s_ninth==1;
replace lowest = 8 if s_eighth==1;
replace lowest = 7 if s_seventh==1;
replace lowest = 6 if s_sixth==1;
replace lowest = 5 if s_fifth==1;
replace lowest = 4 if s_fourth==1;
replace lowest = 3 if s_third==1;
replace lowest = 2 if s_second==1;
replace lowest = 1 if s_first==1;
replace lowest = 0 if s_kind==1;
replace highest = 0 if s_kind==1;
replace highest = 1 if s_first==1;
replace highest = 2 if s_second==1;
replace highest = 3 if s_third==1;
replace highest = 4 if s_fourth==1;
replace highest = 5 if s_fifth==1;
replace highest = 6 if s_sixth==1;
replace highest = 7 if s_seventh==1;
replace highest = 8 if s_eighth==1;
replace highest = 9 if s_ninth==1;
replace highest = 10 if s_tenth==1;
replace highest = 11 if s_eleventh==1;
replace highest = 12 if s_twelfth==1;
replace SCHLEVE2=1 if lowest<=4 & highest<=8;
replace SCHLEVE2=3 if lowest>=7 & highest>=9;
replace SCHLEVE2=2 if lowest>=5 & highest<=8;
replace SCHLEVE2=4 if lowest<=6 & highest>=9;
replace SCHLEVE2=4 if s_ungraded==1 & lowest<1 & highest<1;
destring stcnty_fips, replace;
keep survey_year pct_lunch pct_min pct_iep pct_lep sch_minutes school_enroll CNTLNUMS CNTLNUMD stcnty_fips URBANIC
 s_ungraded s_kind s_first s_second s_third s_fourth s_fifth s_sixth s_seventh s_eighth s_ninth s_tenth s_eleventh s_twelfth SCHLEVE2;
save "${data}temp_sch93.dta", replace;

clear;

/**********************Combine Files**************************/

use "${data}temp_sch93.dta";
append using "${data}temp_sch99.dta";
append using "${data}temp_sch03.dta";
append using "${data}temp_sch07.dta";
keep survey_year pct_lunch pct_min pct_iep pct_lep sch_minutes school_enroll CNTLNUMS CNTLNUMD stcnty_fips URBANIC
 s_ungraded s_kind s_first s_second s_third s_fourth s_fifth s_sixth s_seventh s_eighth s_ninth s_tenth s_eleventh s_twelfth SCHLEVE2;
save "${data}s_allyears.dta", replace;
erase "${data}temp_sch93.dta";
erase "${data}temp_sch99.dta";
erase "${data}temp_sch03.dta";
erase "${data}temp_sch07.dta";

use "${data}temp_prin93.dta";
append using "${data}temp_prin99.dta";
append using "${data}temp_prin03.dta";
append using "${data}temp_prin07.dta";
save "${data}p_allyears.dta", replace;
erase "${data}temp_prin93.dta";
erase "${data}temp_prin99.dta";
erase "${data}temp_prin03.dta";
erase "${data}temp_prin07.dta";
