/*********************************
fig a3 - parents ed - among 8th graders - self reported by these 8th graders. %s.... 

pared_scba
pared_ba
pared_dk
pared_lths

for these app figures 1 and 2, use the years we used before :
*keep if year>=1992 & year<=2007;
*keep if int(year/2)==year/2;

for app fig 3, use all years with pared data...
*********************************/

#delimit;


*pub/cath achievement figs;
***figures 9 & 10***;
 use ${data}fulldata3.dta, clear;
 gen read4=subject=="read"==1&grade==4;
 gen read8=subject=="read"==1&grade==8;
 gen math4=subject=="math"==1&grade==4;
 gen math8=subject=="math"==1&grade==8;


foreach s in math4 math8 read4 read8 {;
 preserve;
 keep if (type=="Public"|type=="Catholic") & state=="National" & `s'==1;


 gen post=year>=2003;
 gen post_trend=post*trend;

 foreach out in mean pct_bsc {;
  foreach g in Public Catholic {;
   gen `out'_`g'=`out' if type=="`g'";
   *predicted trends, pre- and post-;
   reg `out'_`g' post_trend post trend;
   predict trend_`out'_`g' if e(sample);
  };

   **figure numbering;
    if "`s'"=="math4"|"`s'"=="math8" local f=1;
    if "`s'"=="read4"|"`s'"=="read8" local f=2;
    if "`out'"=="mean"&("`s'"=="math4"|"`s'"=="read4") local p="a";
    if "`out'"=="mean"&("`s'"=="math8"|"`s'"=="read8") local p="c";
    if "`out'"=="pct_bsc"&("`s'"=="math4"|"`s'"=="read4") local p="b";
    if "`out'"=="pct_bsc"&("`s'"=="math8"|"`s'"=="read8") local p="d";

 gen tmp=.;
 twoway (scatter `out'_Public `out'_Catholic year,
         msymbol(D Oh) mcolor(black black))
        (line trend_`out'_Public trend_`out'_Catholic year if year<2003,
         lcolor(black black) lpattern(solid dash))
        (line trend_`out'_Public trend_`out'_Catholic year if year>=2003,
         lcolor(black black) lpattern(solid dash))
        (scatter tmp tmp year,
         lcolor(black black) lpattern(solid dash) connect(direct direct)
                      msymbol(D Oh) mcolor(black black)),
            xtitle(Year) xline(2002, lcolor(black) lpattern(solid))
            xmlabel(1990(2)2008, labsize(medsmall))
            xlabel(none) ylabel(, labsize(medsmall))
            legend(order(7 8) label(7 "Public") label(8 "Catholic"));
     graph export ${figs}figA`f'`p'.eps, replace;
 drop tmp;
 };
 restore;
};



use ${data}pub_cath_enr_data.dta, clear;

replace enr_elemwoprek=
	169078+168539+169801+168720+168807+170073+173289+171207+169390+4422
	if year==2008&type=="Catholic";
*projected public school 2007 & 2008 enrollment from digest;
replace enr_elemwoprek=33340000 if year==2007&type=="Public";
replace enr_elemwoprek=33352000 if year==2008&type=="Public";


keep if year>=1994 & year<=2008;

sum pared_scba pared_ba pared_dk pared_lths;

for any pared_scba pared_ba pared_dk pared_lths: replace X=. if X==0;


*new enrollment figs;
 gen post=year>=2003;
 gen trend=year-1989;
 gen post_trend=post*trend;

 gen log_enr=log(enr_elemwoprek);
 gen tmp=log_enr if year==1994;
 egen tmp2=max(tmp), by(type);
 replace log_enr=log_enr-tmp2;

 gen pct_blk_his=pct_blk+pct_his;

/* foreach out in log_enr pup_tea pct_blk pct_his pct_blk_his {;*/
 foreach out in log_enr pup_tea pct_blk pct_his {;
  foreach g in Public Catholic {;
   gen `out'_`g'=`out' if type=="`g'";
   *predicted trends, pre- and post-;
   reg `out'_`g' post_trend post trend;
   predict trend_`out'_`g' if e(sample);
  };

   **figure numbering;
    if "`out'"=="log_enr" {; local f=3; local p="a"; local ytitle= "Ln(Enrollment)"; };
    if "`out'"=="pup_tea" {; local f=4; local p="b";
       			     	   	 local ytitle= "Pupil-Teacher Ratio"; };
    if "`out'"=="pct_blk" {; local f=5; local p="a"; local ytitle="Percent"; };
    if "`out'"=="pct_his" {; local f=5; local p="b"; local ytitle="Percent"; };
/*    if "`out'"=="pct_blk_his" {; local f=12; local p="c"; };*/

 gen tmpy=.;
 twoway (scatter `out'_Public `out'_Catholic year,
         msymbol(D Oh) mcolor(black black))
        (line trend_`out'_Public trend_`out'_Catholic year if year<2003,
         lcolor(black black) lpattern(solid dash))
        (line trend_`out'_Public trend_`out'_Catholic year if year>=2003,
         lcolor(black black) lpattern(solid dash))
        (scatter tmpy tmpy year,
         lcolor(black black) lpattern(solid dash) connect(direct direct)
                      msymbol(D Oh) mcolor(black black)),
            xtitle(Year) xline(2002, lcolor(black) lpattern(solid))
            xmlabel(1994(2)2008, labsize(medsmall))
            xlabel(none) ylabel(, labsize(medsmall))
	    ytitle(`ytitle')
            legend(order(7 8) label(7 "Public") label(8 "Catholic"));
     graph export ${figs}figA`f'`p'.eps, replace;
 drop tmpy;
 };


 foreach out in pared_scba pared_ba pared_lths pared_dk {;
  foreach g in Public Catholic {;
   gen `out'_`g'=`out' if type=="`g'";
   *predicted trends, pre- and post-;
   reg `out'_`g' post_trend post trend;
   predict trend_`out'_`g' if e(sample);
  };

   **figure numbering;
    if "`out'"=="pared_scba" {; local f=6; local p="a"; local ylab= "40(10)85"; };
    if "`out'"=="pared_ba" {; local f=6; local p="b"; local ylab ="40(10)85"; };
    if "`out'"=="pared_lths" {; local f=6; local p="c"; local ylab= "0(2)12"; };
    if "`out'"=="pared_dk" {; local f=6; local p="d"; local ylab= "0(2)12"; };

 gen tmpy=.;
 twoway (scatter `out'_Public `out'_Catholic year,
         msymbol(D Oh) mcolor(black black))
        (line trend_`out'_Public trend_`out'_Catholic year if year<2003,
         lcolor(black black) lpattern(solid dash))
        (line trend_`out'_Public trend_`out'_Catholic year if year>=2003,
         lcolor(black black) lpattern(solid dash))
        (scatter tmpy tmpy year,
         lcolor(black black) lpattern(solid dash) connect(direct direct)
                      msymbol(D Oh) mcolor(black black)),
            xtitle(Year) xline(2002, lcolor(black) lpattern(solid))
            xmlabel(1994(2)2008, labsize(medsmall))
            xlabel(none) ylabel(`ylab', labsize(medsmall))
	    ytitle("Percent")
            legend(order(7 8) label(7 "Public") label(8 "Catholic"));
     graph export ${figs}figA`f'`p'.eps, replace;
 drop tmpy;
 };

