#delimit;
clear;
estimates clear;



**************************************
**** BY RACE CHECKS ******
**************************************;

log using nclb_race.log, replace;

*global outcomes "mean pct_bsc pct_prof pct_adv pct10 pct25 pct50 pct75 pct90";
global outcomes "mean pct_bsc pct10 pct90";



foreach s in sci4 sci8 {;

 foreach y of global outcomes {;
  use ${data}tmpall.dta, clear;

    keep if type=="Public" & state!="National Public" & state!="National" & `s'==1
    & samp==1 & group!="All" & scale=="Composite Scale" & ac_base==1;
    *whether to use 2000 or 2002 for baseline means;
    local preyr=2000;
    if "`s'"=="read4"|"`s'"=="read8" local preyr=2002;

    keep if `y'!=.;

/*
*Determine which states have data on all of the race groups;
 tab year group;
 egen tmp=group(group);
 egen nrace=nvals(tmp), by(statecode year);
 tab group nrace, m;

     keep if nrace==3;
 drop tmp nrace;

 *also check limited sample;
 egen tmp=group(group) if exca9901==0;
 egen nrace=nvals(tmp), by(statecode year);
 tab group nrace, m;
 gen insamp_exca9901=exca9901==0&nrace==3;
 drop tmp nrace;
*/

        gen noacc=yearca>1998|yearca==.;
        gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb03_noacc=trendnclb03*noacc;

        gen nyracc=.;
        replace nyracc=11 if yearca==.;
        replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";
        
        gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb03_nyracc=trendnclb03*nyracc;

	gen yy_00=year==2000; gen yy_05=year==2005;


  foreach r in Black Hispanic White Male Female Eligible Ineligible {;

     disp "**** SUBJECT `s'    Race `r' ******";
     preserve;
     keep if group=="`r'";


if "`s'"=="sci4"     capture noisily areg `y'
        nyracc nclb03 nclb03_nyracc
	excl excl_sq, a(statecode) cl(statecode);
if "`s'"=="sci8"     capture noisily areg `y'
        nyracc yy_00 yy_05 nclb03_nyracc
	excl excl_sq, a(statecode) cl(statecode);

        estimates store `s'_`r'_`y';
          qui sum `y' if yearca==.&year==`preyr' & e(sample);
                   estadd scalar basemn=r(mean);

            capture noisily lincom nclb03_nyracc*6;
            estadd scalar TOT = r(estimate);
            estadd scalar TOTse=r(se);
            estadd scalar TOTt = r(estimate)/r(se);


if "`s'"=="sci4"     capture noisily areg `y'
        nyracc nclb03 nclb03_nyracc
	excl excl_sq [aw=enrollment], a(statecode) cl(statecode);
if "`s'"=="sci8"     capture noisily areg `y'
        nyracc yy_00 yy_05 nclb03_nyracc
	excl excl_sq [aw=enrollment], a(statecode) cl(statecode);

        estimates store w`s'_`r'_`y';
          qui sum `y' [aw=enrollment] if yearca==.&year==`preyr' & e(sample);
                   estadd scalar basemn=r(mean);

            capture noisily lincom nclb03_nyracc*6;
            estadd scalar TOT = r(estimate);
            estadd scalar TOTse=r(se);
            estadd scalar TOTt = r(estimate)/r(se);

    restore;
   };

 };


     estout `s'_Wh* w`s'_Wh* `s'_Bl* w`s'_Bl* `s'_Hi* w`s'_Hi*
     	    `s'_Ma* w`s'_Ma* `s'_Fe* w`s'_Fe*
	    `s'_El* w`s'_El* `s'_In* w`s'_In*
       using ${tabs}nclb_race_`s'_sci.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_nyracc)
       order(nclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse TOTt basemn N_clust N, fmt(3 3 2 0 0 0)
                  layout(@ `"(@)"' @ @ @ @));
	estimates clear;

};


log close;



