#delimit;
clear;
estimates clear;



**************************************
**** BY RACE CHECKS ******
**************************************;

log using nclb_race.log, replace;

*global outcomes "mean pct_bsc pct_prof pct_adv pct10 pct25 pct50 pct75 pct90";
global outcomes "mean pct_bsc pct10 pct90";



foreach s in math4 math8 read4 read8 {;

 foreach y of global outcomes {;
  use ${data}tmpall.dta, clear;

 gen nclb04=year>=2004;
 gen trendnclb04=0;
 replace trendnclb04=year-2003 if year>=2004;


    keep if type=="Public" & state!="National Public" & state!="National" & `s'==1
    & samp==1 & group!="All" & scale=="Composite Scale" & ac_base==1;
    *whether to use 2000 or 2002 for baseline means;
    local preyr=2000;
    if "`s'"=="read4"|"`s'"=="read8" local preyr=2002;

    keep if `y'!=.;

/*
*Determine which states have data on all of the race groups;
 tab year group;
 egen tmp=group(group);
 egen nrace=nvals(tmp), by(statecode year);
 tab group nrace, m;

     keep if nrace==3;
 drop tmp nrace;

 *also check limited sample;
 egen tmp=group(group) if exca9901==0;
 egen nrace=nvals(tmp), by(statecode year);
 tab group nrace, m;
 gen insamp_exca9901=exca9901==0&nrace==3;
 drop tmp nrace;
*/

        gen noacc=yearca>1998|yearca==.;
        gen nclb04_noacc=noacc*nclb04;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb04_noacc=trendnclb04*noacc;

        gen nyracc=.;
        replace nyracc=11 if yearca==.;
        replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";
        
        gen nclb04_nyracc=nyracc*nclb04;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb04_nyracc=trendnclb04*nyracc;

        for any 2003 2005 2007: gen yy_X=year==X \ gen yy_X_noacc=yy_X*noacc;
        for any 2003 2005 2007: gen yy_X_nyracc=yy_X*nyracc;



  foreach r in Black Hispanic White Male Female Eligible Ineligible {;

     disp "**** SUBJECT `s'    Race `r' ******";
     preserve;
     keep if group=="`r'";


     capture noisily areg `y'
        nyracc trend trend_nyracc trendnclb04 trendnclb04_nyracc nclb04 nclb04_nyracc
	excl excl_sq, a(statecode) cl(statecode);

        estimates store `s'_`r'_`y';
          qui sum `y' if yearca==.&year==`preyr' & e(sample);
                   estadd scalar basemn=r(mean);
            disp "*** Effect of NCLB for state that never had any pre-accountability
            relative to a state that had pre-accountability by 97 ***";
            disp "** effect as of 2007 **";
            capture noisily lincom nclb04_nyracc*6 + 24*trendnclb04_nyracc ;
            estadd scalar TOT = r(estimate);
            estadd scalar TOTse=r(se);
            estadd scalar TOTt = r(estimate)/r(se);


     capture noisily areg `y'
        nyracc trend trend_nyracc trendnclb04 trendnclb04_nyracc nclb04 nclb04_nyracc
	excl excl_sq [aw=enrollment], a(statecode) cl(statecode);

        estimates store w`s'_`r'_`y';
          qui sum `y' [aw=enrollment] if yearca==.&year==`preyr' & e(sample);
                   estadd scalar basemn=r(mean);
            disp "*** Effect of NCLB for state that never had any pre-accountability
            relative to a state that had pre-accountability by 98 ***";
            disp "** effect as of 2007 **";
            capture noisily lincom nclb04_nyracc*6 + 24*trendnclb04_nyracc ;
            estadd scalar TOT = r(estimate);
            estadd scalar TOTse=r(se);
            estadd scalar TOTt = r(estimate)/r(se);

    restore;
   };


 };


     estout `s'_Wh* w`s'_Wh* `s'_Bl* w`s'_Bl* `s'_Hi* w`s'_Hi*
     	    `s'_Ma* w`s'_Ma* `s'_Fe* w`s'_Fe*
	    `s'_El* w`s'_El* `s'_In* w`s'_In*
       using ${tabs}nclb_race_`s'_nclb04.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb04_nyracc trendnclb04_nyracc)
       order(nclb04_nyracc trendnclb04_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse TOTt basemn N_clust N, fmt(3 3 2 0 0 0)
                  layout(@ `"(@)"' @ @ @ @));
	estimates clear;

};



log close;



