#delimit;
clear;
estimates clear;

 
*** Baseline Specs for multiple outcomes ***;

log using nclb_tab6.log, replace;


global outcomes "mean pct_bsc pct_prof pct_adv pct10 pct25 pct50 pct75 pct90";



foreach s in math4 math8 read4 read8 {;
  foreach r in All {;


if "`s'"=="math4"|"`s'"=="read4"
 global sycov "excl  povpct povpct_sq excl_sq
          ipct_fl pct_black pct_hisp pct_white mm_race
          unemprate unemprate_sq";

if "`s'"=="math8"|"`s'"=="read8" 
 global sycov "excl  povpct povpct_sq excl_sq
          ipct_fl pct_black pct_hisp pct_white mm_race
          pared_1 pared_2 pared_3
          unemprate unemprate_sq";


    use ${data}tmpall.dta, clear;

    keep if type=="Public" & state!="National Public" & state!="National" & samp==1 &
        	`s'==1 & group=="`r'" &ac_base==1& scale=="Composite Scale";

    *whether to use 2000 or 2002 for baseline means;
    local preyr=2000;
    if "`s'"=="read4"|"`s'"=="read8" local preyr=2002;




    foreach y of global outcomes {;

     disp "**** SUBJECT `s'  GROUP `r'  OUTCOME `y' ******";

    
/*
    disp "*** PANEL B:  CA by 1998, exclude CA 99-01 ***";
        gen noacc=yearca>1998|yearca==.;
        gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb03_noacc=trendnclb03*noacc;

        capture noisily areg `y' noacc trend trend_noacc trendnclb03 trendnclb03_noacc
	 nclb03 nclb03_noacc curexp povpct excl
        curexp_sq povpct_sq excl_sq if exca9901==0, a(statecode) cl(statecode);

         estimates store Ba`s'_`y' ;
	 	   if "`s'"=="math4"|"`s'"=="math8" 
		      sum `y' if e(sample)&yearca==.&year==2000;
	 	   if "`s'"=="read4"
		      sum `y' if e(sample)&yearca==.&year==2002;
		   estadd scalar mn_y=r(mean);
  		   estadd scalar sd_y=r(sd);

*          capture noisily lincom nclb03_noacc + 3*trendnclb03_noacc;
          capture noisily lincom nclb03_noacc + 5*trendnclb03_noacc;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);


     disp "*** CA by 1998, exclude CA 99-01, Separate Post Effects ***";
        
        for any 2003 2005 2007: gen yy_X=year==X \ gen yy_X_noacc=yy_X*noacc;
        
        capture noisily areg `y' 
        noacc trend trend_noacc 
        yy_2003 yy_2005 yy_2007   yy_2003_noacc yy_2005_noacc yy_2007_noacc 
        curexp povpct excl curexp_sq povpct_sq excl_sq if exca9901==0,
	        a(statecode) cl(statecode);

         estimates store Bb`s'_`y' ;

          drop noacc nclb03_noacc trend_noacc trendnclb03_noacc yy_*;
*/


     disp "*** PANEL C:  CA interacted with year ***";

        gen nyracc=.;
        replace nyracc=11 if yearca==.;
        replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";
        
        gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb03_nyracc=trendnclb03*nyracc;



        capture noisily areg `y' 
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc 
        ${sycov}, a(statecode) cl(statecode);

          estimates store Ca`s'_`y' ;

          qui sum `y' if yearca==.&year==`preyr' & e(sample);
		   estadd scalar basemn=r(mean);

         
	disp "*** Effect of NCLB for state that never had any pre-accountability
          relative to a state that had pre-accountability by 97 ***";

          disp "** effect as of 2007 **";
          capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);


          drop nyracc nclb03_nyracc trend_nyracc trendnclb03_nyracc;

/*  
  
   disp "*** CA interacted with year, Separate Post Year Effects ***";
  
       gen nyracc=.;
       replace nyracc=11 if yearca==.;
       replace nyracc=yearca-1992 if yearca~=.;
       gen      trend_nyracc=trend*nyracc;
        
       for any 2003 2005 2007: gen yy_X=year==X \ gen yy_X_nyracc=yy_X*nyracc;

        capture noisily areg `y' 
        nyracc trend trend_nyracc 
        yy_2003 yy_2005 yy_2007 yy_2003_nyracc yy_2005_nyracc yy_2007_nyracc
        curexp povpct excl curexp_sq povpct_sq excl_sq, a(statecode) cl(statecode);

          estimates store Cb`s'_`y' ;


        
         drop yy_* nyracc trend_nyracc;
*/ 
        

  };
 


 };
};


     estout Camath4* Camath8* Caread4* Caread8*
       using ${tabs}nclb_tab6cov.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_nyracc trendnclb03_nyracc)
       order(nclb03_nyracc trendnclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse TOTt basemn N_clust N, fmt(3 3 2 0 0 0)
                  layout(@ `"(@)"' @ @ @ @));
       estimates clear;

log close;

