#delimit;
clear;
estimates clear;


**************************************
**** OTHER ROBUSTNESSS CHECKS ******
**************************************;


log using nclb_robust.log, replace;


program define nclb_robust;


     capture noisily areg mean
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
        excl excl_sq ${`5'} if ${`3'},  a(statecode) cl(statecode);

        estimates store `1'_R`2'_B1;
          sum mean if yearca==. & year==`4' & e(sample);
	  if `2'==3 qui sum mean [aw=enrollment] if yearca==. & year==`4' & e(sample);
          estadd scalar basemn=r(mean);

            disp "*** Effect of NCLB for state that never had any pre-accountability
            relative to a state that had pre-accountability by 97 ***";
            disp "** effect as of 2007 **";
            capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;
            estadd scalar TOT = r(estimate);
            estadd scalar TOTse=r(se);
            estadd scalar TOTt = r(estimate)/r(se);

end;



foreach s in math4 math8 read4 read8 {;
    use ${data}tmpall.dta, clear;
    keep if type=="Public" & state!="National Public" & state!="National"
    	 &`s'==1 & group=="All" & mean!=. & scale=="Composite Scale";
    disp "**** SUBJECT `s' ******";
    *whether to use 2000 or 2002 for baseline means;
    local preyr=2000;
    if "`s'"=="read4"|"`s'"=="read8" local preyr=2002;


  disp "*** BASELINE - Column 1 ***";
        gen noacc=yearca>1998|yearca==.;
        gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb03_noacc=trendnclb03*noacc;
        for any 2003 2005 2007: gen yy_X=year==X \ gen yy_X_noacc=yy_X*noacc;

	gen nyracc=.;
	replace nyracc=11 if yearca==.;
	replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";
        
        gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb03_nyracc=trendnclb03*nyracc;
        for any 2003 2005 2007: gen yy_X_nyracc=yy_X*nyracc;


  global cond "samp==1&ac_base==1";
  nclb_robust `s' 1 cond `preyr';

  disp "*** Time varying covars - Column 2 ***";
if "`s'"=="math4"|"`s'"=="read4" {;
 global sycov1 "excl  povpct povpct_sq excl_sq
          ipct_fl pct_black pct_hisp pct_white mm_race
          hhinc emppop frac_pub frac_fulldayk_mavg frac_prek_mavg
	  	    mm_frac_pub mm_frac_fulldayk_mavg mm_frac_prek_mavg";
 global sycov2 "excl  povpct povpct_sq excl_sq
          ipct_fl pct_black pct_hisp pct_white mm_race
          hhinc hhinc_sq emppop emppop_sq frac_pub frac_fulldayk_mavg frac_prek_mavg
	  	    mm_frac_pub mm_frac_fulldayk_mavg mm_frac_prek_mavg";
 global sycov3 "excl  povpct povpct_sq excl_sq
          ipct_fl pct_black pct_hisp pct_white mm_race pup_tea lnppexp
          hhinc hhinc_sq emppop emppop_sq frac_pub frac_fulldayk_mavg frac_prek_mavg
	  	    mm_frac_pub mm_frac_fulldayk_mavg mm_frac_prek_mavg";
};

if "`s'"=="math8"|"`s'"=="read8" {;
 global sycov1 "excl  povpct povpct_sq excl_sq
          ipct_fl pct_black pct_hisp pct_white mm_race
	  pared_1 pared_2 pared_3
          hhinc emppop frac_pub frac_fulldayk_mavg frac_prek_mavg
	  	    mm_frac_pub mm_frac_fulldayk_mavg mm_frac_prek_mavg";  
 global sycov2 "excl  povpct povpct_sq excl_sq
          ipct_fl pct_black pct_hisp pct_white mm_race
	  pared_1 pared_2 pared_3
          hhinc hhinc_sq emppop emppop_sq frac_pub frac_fulldayk_mavg frac_prek_mavg
	  	    mm_frac_pub mm_frac_fulldayk_mavg mm_frac_prek_mavg";
 global sycov3 "excl  povpct povpct_sq excl_sq
          ipct_fl pct_black pct_hisp pct_white mm_race pup_tea lnppexp
	  pared_1 pared_2 pared_3
          hhinc hhinc_sq emppop emppop_sq frac_pub frac_fulldayk_mavg frac_prek_mavg
	  	    mm_frac_pub mm_frac_fulldayk_mavg mm_frac_prek_mavg";
};

gen hhinc_sq=hhinc^2;
gen emppop_sq=emppop^2;
forval j=1/3 {; 
     capture noisily areg mean
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
	  ${sycov`j'} if samp==1&ac_base==1, a(statecode) cl(statecode);

        estimates store `s'_R2_`j'_B1;

          qui sum mean if yearca==.&year==`preyr' & e(sample);
          estadd scalar basemn=r(mean);

            disp "*** Effect of NCLB for state that never had any pre-accountability
            relative to a state that had pre-accountability by 97 ***";
            disp "** effect as of 2007 **";
            capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;
            estadd scalar TOT = r(estimate);
            estadd scalar TOTse=r(se);
            estadd scalar TOTt = r(estimate)/r(se);
};

  disp "*** Weight by enrollment - Column 3 ***";
  global cond "samp==1&ac_base==1 [aw=enrollment]";
  nclb_robust `s' 3 cond `preyr';

  disp "*** yearca==. for VA WI IN KS - Column 4 ***";
  preserve;

tab statecode yearca if statecode=="VA"|statecode=="WI"|statecode=="IN"|statecode=="KS";
tab statecode yearca if (statecode=="VA"|statecode=="WI"|statecode=="IN"|statecode=="KS")
    &samp==1&ac_base==1;

     replace yearca=. if statecode=="VA"|statecode=="WI"|statecode=="IN"|statecode=="KS";
     drop noacc trend_noacc trendnclb03_noacc nclb03_noacc 
          nyracc trend_nyracc trendnclb03_nyracc nclb03_nyracc yy_*;

        gen noacc=yearca>1998|yearca==.;
        gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb03_noacc=trendnclb03*noacc;
        for any 2003 2005 2007: gen yy_X=year==X \ gen yy_X_noacc=yy_X*noacc;

	gen nyracc=.;
	replace nyracc=11 if yearca==.;
	replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";
        
        gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb03_nyracc=trendnclb03*nyracc;
        for any 2003 2005 2007: gen yy_X_nyracc=yy_X*nyracc;
  global cond "samp==1&ac_base==1";
  nclb_robust `s' 4 cond `preyr';
  restore;




  disp "*** Year Fixed Effects - Column 6 ***";
  global cond "samp==1&ac_base==1";
  qui tab year, gen(tmp_yy_);
  drop tmp_yy_1;
  global cov "tmp_yy_*";
  nclb_robust `s' 6 cond `preyr' cov;
  drop tmp_yy_*;


  disp "*** state specific pre-nclb trends - Column 7 ***";
    egen st=group(statecode) if samp==1;
    qui tab st if samp==1; local max=r(r);
    for num 1/`max': gen trendstate_X=trend*(st==X);
    drop trendstate_1; sum trendstate*; tab trendstate_2;

  global cond "samp==1&ac_base==1";
  global cov "trendstate_*";
  nclb_robust `s' 7 cond `preyr' cov;
  drop trendstate_*;



  disp "*** No state fixed effects - Column 8 ***";
     capture noisily reg mean
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
        excl excl_sq if samp==1&ac_base==1,  cl(statecode);

        estimates store `s'_R8_B1;

          qui sum mean if yearca==.&year==`preyr' & e(sample);
          estadd scalar basemn=r(mean);
            disp "*** Effect of NCLB for state that never had any pre-accountability
            relative to a state that had pre-accountability by 97 ***";
            disp "** effect as of 2007 **";
            capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;
            estadd scalar TOT = r(estimate);
            estadd scalar TOTse=r(se);
            estadd scalar TOTt = r(estimate)/r(se);

  disp "*** states with at least 1 pre-nclb test score - Column 9 ***";
   disp "*adds the following states*";
     tab statecode if samp==0 & noobspre03g>=1, m;
  global cond "noobspre03g>=1&ac_base==1";
  nclb_robust `s' 9 cond `preyr';


 if "`s'"!="read8" {;
  disp "*** states with at least 3 pre-nclb test score - Column 10 ***";
   disp "*subtracts the following states*";
     tab statecode if samp==1 & noobspre03g<3, m;
  global cond "samp==1&noobspre03g>=3&ac_base==1";
  nclb_robust `s' 10 cond `preyr';
 };
 
 *accomodations alternate coding;
 global cond "samp==1&ac_alt==1";
 nclb_robust `s' 11 cond `preyr';

disp "*** variance weighted least squares ***";
qui tab statecode, gen(st_);
drop st_1;
     capture noisily vwls mean
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
        excl excl_sq st_* if samp==1&ac_base==1, sd(se_mean);

        estimates store `s'_R12_B1;

          qui sum mean if yearca==.&year==`preyr' & e(sample);
          estadd scalar basemn=r(mean);
            disp "*** Effect of NCLB for state that never had any pre-accountability
            relative to a state that had pre-accountability by 97 ***";
            disp "** effect as of 2007 **";
            capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;
            estadd scalar TOT = r(estimate);
            estadd scalar TOTse=r(se);
            estadd scalar TOTt = r(estimate)/r(se);


***assume NCLB starts in 2001-02 or 2003-04 -- C13 and C14***;


local c=12;
foreach nclbyr in nclb02 nclb04 {;
 local c=`c'+1;

 preserve;
 gen nclb04=year>=2004;
 gen trendnclb04=0;
 replace trendnclb04=year-2003 if year>=2004;
     drop noacc trend_noacc trendnclb03_noacc nclb03_noacc
          nyracc trend_nyracc trendnclb03_nyracc nclb03_nyracc yy_*;

        gen noacc=yearca>1998|yearca==.;
        gen `nclbyr'_noacc=noacc*`nclbyr';
        gen      trend_noacc=trend*noacc;
        gen      trend`nclbyr'_noacc=trend`nclbyr'*noacc;

        gen nyracc=.;

            if "`nclbyr'"=="nclb04" replace nyracc=12 if yearca==.;
            if "`nclbyr'"=="nclb02" replace nyracc=10 if yearca==.;
        replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";

        gen `nclbyr'_nyracc=nyracc*`nclbyr';
        gen      trend_nyracc=trend*nyracc;
        gen      trend`nclbyr'_nyracc=trend`nclbyr'*nyracc;

  global cond "samp==1&ac_base==1";

     capture noisily areg mean
        nyracc trend trend_nyracc trend`nclbyr' trend`nclbyr'_nyracc
	 `nclbyr' `nclbyr'_nyracc
        excl excl_sq if ${cond},  a(statecode) cl(statecode);

        estimates store `s'_R`c'_B1;
          sum mean if yearca==. & year==`preyr' & e(sample);
          estadd scalar basemn=r(mean);

            disp "*** Effect of NCLB for state that never had any pre-accountability
            relative to a state that had pre-accountability by 97 ***";
            disp "** effect as of 2007 **";
            if "`nclbyr'"=="nclb04" 
	       capture noisily lincom `nclbyr'_nyracc*7 + 28*trend`nclbyr'_nyracc ;
            if "`nclbyr'"=="nclb02" 
               capture noisily lincom `nclbyr'_nyracc*5 + 30*trend`nclbyr'_nyracc ;
            estadd scalar TOT = r(estimate);
            estadd scalar TOTse=r(se);
            estadd scalar TOTt = r(estimate)/r(se);

restore;
};

};

     estout math4_R* math8_R* read4_R* read8_R*
       using ${tabs}nclb_robust.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_nyracc trendnclb03_nyracc)
       order(nclb03_nyracc trendnclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse TOTt basemn N_clust N, fmt(3 3 3 3 0 0)
        layout(@ `"(@)"' @ @ @ @));

       estimates clear;




***additional specs for read4***;

    use ${data}tmpall.dta, clear;
    keep if type=="Public" & state!="National Public" & state!="National"
    	 &read4==1 & group=="All" & mean!=. & ac_base==1 & scale=="Composite Scale";

  disp "*** BASELINE - Column 1 ***";
        gen noacc=yearca>1998|yearca==.;
        gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb03_noacc=trendnclb03*noacc;
        for any 2003 2005 2007: gen yy_X=year==X \ gen yy_X_noacc=yy_X*noacc;

	gen nyracc=.;
	replace nyracc=11 if yearca==.;
	replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";
        
        gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb03_nyracc=trendnclb03*nyracc;
        for any 2003 2005 2007: gen yy_X_nyracc=yy_X*nyracc;

  global cond "samp==1";
  nclb_robust read4 1 cond 2002;

  global cond "samp==1&year!=1992";
  nclb_robust read4 2 cond 2002;

  global cond "samp==1&year!=1992&obs1994==1&obs1998==1&obs2002==1";
  nclb_robust read4 3 cond 2002;

  global cond "samp==1&year!=1992&year!=2002&obs1994==1&obs1998==1&obs2002==1";
  nclb_robust read4 4 cond 2002;

 
     estout read4_R*
       using ${tabs}nclb_robust_read4_part2.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_nyracc trendnclb03_nyracc)
       order(nclb03_nyracc trendnclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse TOTt basemn N_clust N, fmt(3 3 3 3 0 0)
        layout(@ `"(@)"' @ @ @ @));

       estimates clear;




log close;







/*

    disp "*** drop states that only had warnings/ratings ***";
    disp "*** this sets NC, WI and VA to no pre NCLB accountability ***";
    
        gen noacc=yearca2>1998|yearca2==.;
        gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb03_noacc=trendnclb03*noacc;

     areg mean  trend trend_noacc trendnclb03 trendnclb03_noacc
        nclb03 nclb03_noacc curexp povpct excl
        curexp_sq povpct_sq excl_sq  if exca9901==0&samp==1,
		   a(statecode) cluster(statecode);

        estimates store `s'_R1_A;
          capture noisily lincom nclb03_noacc + 5*trendnclb03_noacc;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);	  


        gen nyracc = (2002-yearca2);
        replace nyracc=0 if yearca2>=2002 | yearca2==.;
        gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb03_nyracc=trendnclb03*nyracc;

   areg mean
          trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
          curexp povpct excl curexp_sq povpct_sq excl_sq if samp==1,
	  	  a(statecode) cl(statecode);
        estimates store `s'_R1_B;
          capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);


       *now restore variables to their original definition;

       drop noacc trend_noacc trendnclb03_noacc nclb03_noacc 
       	    nyracc trend_nyracc trendnclb03_nyracc nclb03_nyracc ;

        gen noacc=yearca>1998|yearca==.;
        gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb03_noacc=trendnclb03*noacc;

        gen nyracc = (2002-yearca);
        replace nyracc=0 if yearca>=2002 | yearca==.;
     
        label var nyracc "# years state had CA prior to 2002 ";
        
        gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb03_nyracc=trendnclb03*nyracc;

*        tab statecode, gen(ss_);




   disp "*** exclude DC ***";
        
    areg mean  trend trend_noacc trendnclb03 trendnclb03_noacc
       nclb03 nclb03_noacc curexp povpct excl
        curexp_sq povpct_sq excl_sq  if exca9901==0 & statecode!="DC" & samp==1,
		  a(statecode)  cluster(statecode);

        estimates store `s'_R2_A;
          capture noisily lincom nclb03_noacc + 5*trendnclb03_noacc;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);	  

   areg mean
          trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
          curexp povpct excl curexp_sq povpct_sq excl_sq if statecode!="DC" &samp==1
	  	 , a(statecode) cl(statecode);

        estimates store `s'_R2_B;
          capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

 
 

   disp "*** run without time-varying covariates ***";
 
    areg mean  trend trend_noacc trendnclb03 trendnclb03_noacc
       nclb03 nclb03_noacc if exca9901==0 & samp==1, a(statecode) cluster(statecode);

        estimates store `s'_R3_A;
          capture noisily lincom nclb03_noacc + 5*trendnclb03_noacc;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);	  

   areg mean
          trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
	  	if samp==1 , a(statecode) cl(statecode);

        estimates store `s'_R3_B;
          capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);
 


   ***run without state FE ***;

   reg mean  trend trend_noacc trendnclb03 trendnclb03_noacc
      nclb03 nclb03_noacc 
        if exca9901==0 & samp==1,  cluster(statecode);

        estimates store `s'_R4_A;
          capture noisily lincom nclb03_noacc + 5*trendnclb03_noacc;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);	  

   reg mean
          trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
	  	if samp==1 , cl(statecode);

        estimates store `s'_R4_B;
          capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);
*/


