#delimit;
clear;
estimates clear;

 
*** Baseline Specs: Use Our Measures, Which are Slight Deviation from HR ***;
*** Examine 2002 and 2003, with and without covariates ***;

log using nclb_tab3.log, replace;


global outcomes "mean";
*global outcomes "mean pct10 pct25 pct50 pct75 pct90 pct_bsc pct_prof pct_adv";



*  foreach r in All {;

foreach s in math4 math8 read4 read8 {;

    use ${data}tmpall.dta, clear;

    keep if type=="Public" & state!="National Public" & state!="National" & samp==1 &
        	`s'==1 & group=="All" &ac_base==1& scale=="Composite Scale";


    *whether to use 2000 or 2002 for baseline means;
    local preyr=2000; 
    if "`s'"=="read4"|"`s'"=="read8" local preyr=2002; 



    foreach y of global outcomes {;


    disp "*** PANEL B:  CA by 1998, exclude CA 99-01 ***";
        gen noacc=yearca>1998|yearca==.;
        gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb03_noacc=trendnclb03*noacc;

        capture noisily areg `y' noacc trend trend_noacc trendnclb03 trendnclb03_noacc
	 nclb03 nclb03_noacc excl excl_sq if exca9901==0, a(statecode) cl(statecode);

         estimates store Ba`s'_`y' ;
         

	  qui sum `y' if yearca==.&year==`preyr' & e(sample);
	  estadd scalar basemn=r(mean);

          capture noisily lincom nclb03_noacc + 5*trendnclb03_noacc;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);



*Calculate diff in state vs. naep proficiency rates;
*Positive values = easy state tests = NCLB will have bigger effect;
*We will define states with no accountability to have the largest potential difference 
 btw state and naep tests - ie, 1;
 
 
 gen diff=(prof_st_tst_2002 - pct_prof)/100 if year==`preyr';
 tab diff if year==`preyr', m;
 tab diff yearca if year==`preyr', m;
 egen mdiff=max(diff), by(state);

 gen treat = 1 if noacc==1;
 replace treat = mdiff if treat==.;

  
*Re-run model above but for sample that does have state prof tests;
        
       capture noisily areg `y' noacc trend trend_noacc trendnclb03 trendnclb03_noacc
  nclb03 nclb03_noacc excl excl_sq if exca9901==0 & treat!=., a(statecode) cl(statecode);

capture noisily lincom nclb03_noacc + 5*trendnclb03_noacc;

*Now incorporate the strength of school accountability as proxied by the diff in prof rates;

    gen nclb03_treat=treat*nclb03;
        gen      trend_treat=trend*treat;
        gen      trendnclb03_treat=trendnclb03*treat;
  
        capture noisily areg `y' treat nclb03 nclb03_treat if exca9901==0 & treat!=., a(statecode) cl(statecode) ;
  
     capture noisily areg `y' treat trend trend_treat trendnclb03 trendnclb03_treat nclb03 nclb03_treat excl excl_sq if exca9901==0 & treat!=., a(statecode) cl(statecode);

     capture noisily lincom nclb03_treat + 5*trendnclb03_treat;
     


          drop noacc nclb03_noacc trend_noacc trendnclb03_noacc;
	  drop treat nclb03_treat trendnclb03_treat trend_treat;

};
};
STOP;

/*

     disp "*** PANEL C:  CA interacted with year ***";

        gen nyracc=.;
        replace nyracc=11 if yearca==.;
        replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state was w/o CA prior to 2002 ";
	gen frac_nyracc=nyracc/11;

	gen treat1=11 if yearca==.;
	replace treat1=nyracc*mdiff if treat1==.;

	gen treat2=1 if yearca==.;
	replace treat2=frac_nyracc*mdiff if treat2==.;

sum treat1 treat2, det;

/*        
        SOME CODE THAT IS LIKE .... nyracc * mdiff.....but for states with no prior accountability, do not use mdiff.
        
        maybe better to rescale this to be 0 - 1 also...
        
        fraction of years without.... x the mdiff....
        
        NOT SURE - CODE UP 1 or 2 versions that seem plausible.
*/        
        
        gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb03_nyracc=trendnclb03*nyracc;

        gen nclb03_treat1=treat1*nclb03;
        gen      trend_treat1=trend*treat1;
        gen      trendnclb03_treat1=trendnclb03*treat1;

        gen nclb03_treat2=treat1*nclb03;
        gen      trend_treat2=trend*treat2;
        gen      trendnclb03_treat2=trendnclb03*treat2;

        capture noisily areg `y' 
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc 
        excl excl_sq if treat1!=., a(statecode) cl(statecode);

          capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;

        capture noisily areg `y' 
        treat1 nclb03 nclb03_treat1, a(statecode) cl(statecode);

        capture noisily areg `y' 
        treat1 trend trend_treat1 trendnclb03 trendnclb03_treat1 nclb03 nclb03_treat1 
        excl excl_sq, a(statecode) cl(statecode);

          capture noisily lincom nclb03_treat1*6 + 30*trendnclb03_treat1 ;

        capture noisily areg `y' 
        treat2 trend trend_treat2 trendnclb03 trendnclb03_treat2 nclb03 nclb03_treat2 
        excl excl_sq, a(statecode) cl(statecode);

          capture noisily lincom nclb03_treat2*(6/11) + (6/11)*5*trendnclb03_treat2 ;
STOP;




          estimates store Ca`s'_`y' ;

	  qui sum `y' if yearca==.&year==`preyr' & e(sample);
	  estadd scalar basemn=r(mean);
         
	disp "*** Effect of NCLB for state that never had any pre-accountability
          relative to a state that had pre-accountability by 97 ***";

          disp "** effect as of 2007, relative to state with acct in 1997 **";


          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

          drop nyracc nclb03_nyracc trend_nyracc trendnclb03_nyracc;
*/
  
    };

         

  };
STOP;


 
     estout Aamath4_mean Aamath8_mean Aaread4_mean Aaread8_mean
     	    Bamath4_mean Bamath8_mean Baread4_mean Baread8_mean
     	    Camath4_mean Camath8_mean Caread4_mean Caread8_mean
       using ${tabs}nclb_tab3_All.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_noacc trendnclb03_noacc nclb03_nyracc trendnclb03_nyracc)
       order(nclb03_noacc trendnclb03_noacc nclb03_nyracc trendnclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse TOTt basemn N_clust N, fmt(3 3 3 3 0 0)
       		  layout(@ `"(@)"' @ @ @ @));
       estimates clear;


log close;

