#delimit;
clear;
estimates clear;

 
*** Baseline Specs: Use Our Measures, Which are Slight Deviation from HR ***;
*** Examine 2002 and 2003, with and without covariates ***;

log using nclb_tab3_2009.log, replace;


global outcomes "mean";
*global outcomes "mean pct10 pct25 pct50 pct75 pct90 pct_bsc pct_prof pct_adv";



*  foreach r in All {;

foreach s in math4 math8 {;

    use ${data}tmpall.dta, clear;

    keep if type=="Public" & state!="National Public" & state!="National" & samp2009==1 &
        	`s'==1 & group=="All" &ac_base==1& scale=="Composite Scale";


    *whether to use 2000 or 2002 for baseline means;
    local preyr=2000; 
    if "`s'"=="read4"|"`s'"=="read8" local preyr=2002; 


    foreach y of global outcomes {;

     disp "**** SUBJECT `s'  GROUP All  OUTCOME `y' ******";

   disp "*** PANEL A: CA by 2001, no exclusions ***";
        
        gen noacc=yearca>2001|yearca==.;
        gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb03_noacc=trendnclb03*noacc;

        capture noisily areg `y' noacc trend trend_noacc trendnclb03 trendnclb03_noacc
		 nclb03 nclb03_noacc excl excl_sq, a(statecode) cl(statecode);

         estimates store Aa`s'_`y' ;

	  qui sum `y' if yearca==.&year==`preyr' & e(sample);
	  estadd scalar basemn=r(mean);
         
          capture noisily lincom nclb03_noacc + 5*trendnclb03_noacc;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);
          capture noisily lincom nclb03_noacc + 7*trendnclb03_noacc;
          estadd scalar TOT09 = r(estimate);
          estadd scalar TOT09se=r(se);
          estadd scalar TOT09t = r(estimate)/r(se);


      disp "*** CA by 2001, no exclu, Separate Post Effects ***";

        for any 2003 2005 2007 2009: gen yy_X=year==X \ gen yy_X_noacc=yy_X*noacc;
        
        capture noisily areg `y' 
        noacc trend trend_noacc 
        yy_2003 yy_2005 yy_2007 yy_2009
	yy_2003_noacc yy_2005_noacc yy_2007_noacc yy_2009_noacc 
         excl excl_sq , a(statecode) cl(statecode);

         estimates store Ab`s'_`y' ;
	 drop yy_*;


          drop noacc nclb03_noacc trend_noacc trendnclb03_noacc;



    disp "*** PANEL B:  CA by 1998, exclude CA 99-01 ***";
        gen noacc=yearca>1998|yearca==.;
        gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb03_noacc=trendnclb03*noacc;

        capture noisily areg `y' noacc trend trend_noacc trendnclb03 trendnclb03_noacc
	 nclb03 nclb03_noacc excl excl_sq if exca9901==0, a(statecode) cl(statecode);

         estimates store Ba`s'_`y' ;
         

	  qui sum `y' if yearca==.&year==`preyr' & e(sample);
	  estadd scalar basemn=r(mean);

          capture noisily lincom nclb03_noacc + 5*trendnclb03_noacc;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

          capture noisily lincom nclb03_noacc + 7*trendnclb03_noacc;
          estadd scalar TOT09 = r(estimate);
          estadd scalar TOT09se=r(se);
          estadd scalar TOT09t = r(estimate)/r(se);


     disp "*** CA by 1998, exclude CA 99-01, Separate Post Effects ***";
        
        for any 2003 2005 2007 2009: gen yy_X=year==X \ gen yy_X_noacc=yy_X*noacc;
        
        capture noisily areg `y' 
        noacc trend trend_noacc 
        yy_2003 yy_2005 yy_2007 yy_2009
	yy_2003_noacc yy_2005_noacc yy_2007_noacc yy_2009_noacc
         excl excl_sq  if exca9901==0, a(statecode) cl(statecode);

         estimates store Bb`s'_`y' ;
	 drop yy_*;



          drop noacc nclb03_noacc trend_noacc trendnclb03_noacc;



     disp "*** PANEL C:  CA interacted with year ***";

        gen nyracc=.;
        replace nyracc=11 if yearca==.;
        replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";
        
        gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb03_nyracc=trendnclb03*nyracc;

        capture noisily areg `y' 
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc 
        excl excl_sq, a(statecode) cl(statecode);

          estimates store Ca`s'_`y' ;

	  qui sum `y' if yearca==.&year==`preyr' & e(sample);
	  estadd scalar basemn=r(mean);
         
	disp "*** Effect of NCLB for state that never had any pre-accountability
          relative to a state that had pre-accountability by 97 ***";

          disp "** effect as of 2007, relative to state with acct in 1997 **";
          capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;

          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

          disp "** effect as of 2009, relative to state with acct in 1997 **";
          capture noisily lincom nclb03_nyracc*6 + 42*trendnclb03_nyracc ;

          estadd scalar TOT09 = r(estimate);
          estadd scalar TOT09se=r(se);
          estadd scalar TOT09t = r(estimate)/r(se);
  

   disp "*** CA interacted with year, Separate Post Year Effects ***";
  
       for any 2003 2005 2007 2009: gen yy_X=year==X \ gen yy_X_nyracc=yy_X*nyracc;

        capture noisily areg `y' 
        nyracc trend trend_nyracc 
        yy_2003 yy_2005 yy_2007 yy_2009
	yy_2003_nyracc yy_2005_nyracc yy_2007_nyracc yy_2009_nyracc
        excl excl_sq,  a(statecode) cl(statecode);

          estimates store Cb`s'_`y' ;
	  drop yy_*;


          drop nyracc nclb03_nyracc trend_nyracc trendnclb03_nyracc;



    };

         

  };



 
     estout Aamath4_mean Aamath8_mean
     	    Bamath4_mean Bamath8_mean
     	    Camath4_mean Camath8_mean
       using ${tabs}nclb_tab3_2009.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_noacc trendnclb03_noacc nclb03_nyracc trendnclb03_nyracc)
       order(nclb03_noacc trendnclb03_noacc nclb03_nyracc trendnclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse TOTt TOT09 TOT09se TOT09t basemn N_clust N, fmt(3 3 3 3 3 3 3 0 0)
       		  layout(@ `"(@)"' @ @ `"(@)"' @ @ @ @));

     estout Abmath4_mean Abmath8_mean
     	    Bbmath4_mean Bbmath8_mean
     	    Cbmath4_mean Cbmath8_mean
       using ${tabs}nclb_tab3_2009int.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(yy_2003_noacc yy_2005_noacc yy_2007_noacc yy_2009_noacc
		  yy_2003_nyracc yy_2005_nyracc yy_2007_nyracc yy_2009_nyracc)
       order(yy_2003_noacc yy_2005_noacc yy_2007_noacc yy_2009_noacc
		  yy_2003_nyracc yy_2005_nyracc yy_2007_nyracc yy_2009_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(basemn N_clust N, fmt(3 0 0));

       estimates clear;



log close;

