#delimit;
clear;
estimates clear;

 
*** baseline spec for subscale scores ***;

log using nclb_tab11.log, replace;


global outcomes "mean";



foreach s in math4 math8 read4 read8 {;
	if "`s'"=="math4"|"`s'"=="math8" local scales="1/5";
	if "`s'"=="read8" local scales="6/8";
	if "`s'"=="read4" local scales="6/7";
  forval scale = `scales' {;

    use ${data}tmpall.dta, clear;

gen scale_num=1 if scale=="Algebra Scale";
replace scale_num=2 if scale=="Geometry Scale";
replace scale_num=3 if scale=="Measurement Scale";
replace scale_num=4 if scale=="Number Properties and operations scale";
replace scale_num=5 if scale=="data analysis, statistics, and probability scale";
replace scale_num=6 if scale=="Gain Information Scale";
replace scale_num=7 if scale=="Literary Experience Scale";
replace scale_num=8 if scale=="Perform a task scale";

tab scale_num, m;
tab scale if scale_num==.;


    keep if type=="Public" & state!="National Public" & state!="National" & samp==1 &
        	`s'==1 & group=="All" &ac_base==1& scale_num==`scale';


    *whether to use 2000 or 2002 for baseline means;
    local preyr=2000;
    if "`s'"=="read4"|"`s'"=="read8" local preyr=2002;


    foreach y of global outcomes {;

     disp "**** SUBJECT `s'  SCALE `scale'  OUTCOME `y' ******";

    

     disp "*** PANEL C:  CA interacted with year ***";

        gen nyracc=.;
        replace nyracc=11 if yearca==.;
        replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";
        
        gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb03_nyracc=trendnclb03*nyracc;



        capture noisily areg `y' 
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc 
        excl excl_sq, a(statecode) cl(statecode);

          estimates store Ca`s'_`y'`scale' ;

          qui sum `y' if yearca==.&year==`preyr' & e(sample);
		   estadd scalar basemn=r(mean);

         
	disp "*** Effect of NCLB for state that never had any pre-accountability
          relative to a state that had pre-accountability by 97 ***";

          disp "** effect as of 2007 **";
          capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);


          drop nyracc nclb03_nyracc trend_nyracc trendnclb03_nyracc;


  };
 


 };
};


     estout Camath4* Camath8* Caread4* Caread8*
       using ${tabs}nclb_tab11.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_nyracc trendnclb03_nyracc)
       order(nclb03_nyracc trendnclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse TOTt basemn N_clust N, fmt(3 3 2 0 0 0)
                  layout(@ `"(@)"' @ @ @ @));
       estimates clear;

log close;

