#delimit;
clear;

** FIGURES ***;

log using nclb_figs1_10.log, replace;




***figures 1-4 - National Public School Attainment***;
 use ${data}fulldata3.dta, clear;
 gen read4=subject=="read"==1&grade==4;
 gen read8=subject=="read"==1&grade==8;
 gen math4=subject=="math"==1&grade==4;
 gen math8=subject=="math"==1&grade==8;


global outcomes "mean pct_bsc pct_prof";
foreach s in math4 math8 read4 read8 {;
 preserve;
 keep if type=="Public" & state=="National Public"&`s'==1 &year>1990;

**figure numbering;
 if "`s'"=="math4" local f=1;
 if "`s'"=="read4" local f=2;
 if "`s'"=="math8" local f=3;
 if "`s'"=="read8" local f=4;


*panel d;
 twoway (scatter pct10 pct25 pct75 pct90 year if group=="All students",
 	 connect(direct direct direct direct)
	 lpattern(solid longdash shortdash dash_dot) 
	 lcolor(black black black black)
	 msymbol(O D T S) mcolor(black black black black)),
	    xtitle(Year) xline(2002, lcolor(black) lpattern(solid))
	    xmlabel(1992(2)2008, labsize(medsmall))
	    xlabel(none) ylabel(, labsize(medsmall))
	    legend(label(1 "10th Percentile") label(2 "25th Percentile")
	    		    label(3 "75th Percentile") label(4 "90th Percentile"));
     graph export ${figs}fig`f'd.eps, replace;

*panels a-c;
 drop if group=="All students";
 foreach out of global outcomes {;
  foreach g in Black Hispanic White {;
    gen `out'_`g'=`out' if group=="`g'";
  };

    *figure labels;
    if "`out'"=="mean" local p="a";
    if "`out'"=="pct_bsc" local p="b";
    if "`out'"=="pct_prof" local p="c";

     twoway (scatter `out'_Black `out'_Hispanic `out'_White year,
     	     connect(direct direct direct)
     	     lcolor(black black black) mcolor(black black black)
	     lpattern(dot dash solid)  msymbol(Oh X T)),
	    xtitle(Year) xline(2002, lcolor(black) lpattern(solid))
	    xmlabel(1992(2)2008, labsize(medsmall))
	    xlabel(none) ylabel(, labsize(medsmall))
	    ytitle("NAEP scale score")
	    legend(cols(1) colfirst
	          label(1 "African-American") label(2 "Hispanic") label(3 "White"));
     graph export ${figs}fig`f'`p'.eps, replace;
 };
 restore;
};



***figures 5-8 - National Public School Attainment - LTT***;
 use ${data}longterm.dta, clear;
 gen read9=subject=="read"==1&age==9;
 gen read13=subject=="read"==1&age==13;
 gen math9=subject=="math"==1&age==9;
 gen math13=subject=="math"==1&age==13;

global outcomes "mean lvl200 lvl250";
foreach s in math9 math13 read9 read13 {;
 preserve;
 keep if type=="public" & mod_ass==0 & `s'==1;

**figure numbering;
 if "`s'"=="math9" local f=5;
 if "`s'"=="read9" local f=6;
 if "`s'"=="math13" local f=7;
 if "`s'"=="read13" local f=8;

*panel d;
 twoway (scatter pct10 pct25 pct75 pct90 year if group=="All students",
 	 connect(direct direct direct direct)
	 lpattern(solid longdash shortdash dash_dot) 
	 lcolor(black black black black)
	 msymbol(O D T S) mcolor(black black black black)),
	    xtitle(Year) xline(2002, lcolor(black) lpattern(solid))
	    xmlabel(1974(4)2006, labsize(medsmall))
	    xlabel(none) ylabel(, labsize(medsmall))
	    legend(label(1 "10th Percentile") label(2 "25th Percentile")
	    		    label(3 "75th Percentile") label(4 "90th Percentile"));
     graph export ${figs}fig`f'd.eps, replace;

*panels a-c;
 drop if group=="All students";
 foreach out of global outcomes {;
  foreach g in Black Hispanic White {;
    gen `out'_`g'=`out' if group=="`g'";
  };

    *figure labels;
    if "`out'"=="mean" local p="a";
    if "`out'"=="lvl200" local p="b";
    if "`out'"=="lvl250" local p="c";

     twoway (scatter `out'_Black `out'_Hispanic `out'_White year,
     	     connect(direct direct direct)
     	     lcolor(black black black) mcolor(black black black)
	     lpattern(dot dash solid)  msymbol(Oh X T)),
	    xtitle(Year) xline(2002, lcolor(black) lpattern(dash))
	    xmlabel(1974(4)2006, labsize(medsmall))
	    xlabel(none) ylabel(, labsize(medsmall))
	    legend(cols(1) colfirst
	          label(1 "African-American") label(2 "Hispanic") label(3 "White"));
     graph export ${figs}fig`f'`p'.eps, replace;
 };
 restore;
};



/*  ***this section moved to pub_cath2.do***
***figures 9 & 10***;
 use ${data}fulldata3.dta, clear;
 gen read4=subject=="read"==1&grade==4;
 gen read8=subject=="read"==1&grade==8;
 gen math4=subject=="math"==1&grade==4;
 gen math8=subject=="math"==1&grade==8;


foreach s in math4 math8 read4 read8 {;
 preserve;
 keep if (type=="Public"|type=="Catholic") & state=="National" & `s'==1;


 gen post=year>=2003;
 gen post_trend=post*trend;

 foreach out in mean pct_bsc {;
  foreach g in Public Catholic {;
   gen `out'_`g'=`out' if type=="`g'";
   *predicted trends, pre- and post-;
   reg `out'_`g' post_trend post trend;
   predict trend_`out'_`g' if e(sample);
  };

   **figure numbering;
    if "`s'"=="math4"|"`s'"=="math8" local f=9;
    if "`s'"=="read4"|"`s'"=="read8" local f=10;
    if "`out'"=="mean"&("`s'"=="math4"|"`s'"=="read4") local p="a";
    if "`out'"=="mean"&("`s'"=="math8"|"`s'"=="read8") local p="c";
    if "`out'"=="pct_bsc"&("`s'"=="math4"|"`s'"=="read4") local p="b";
    if "`out'"=="pct_bsc"&("`s'"=="math8"|"`s'"=="read8") local p="d";

 gen tmp=.;
 twoway (scatter `out'_Public `out'_Catholic year,
	 msymbol(D Oh) mcolor(black black))
	(line trend_`out'_Public trend_`out'_Catholic year if year<2003,
	 lcolor(black black) lpattern(solid dash))
	(line trend_`out'_Public trend_`out'_Catholic year if year>=2003,
	 lcolor(black black) lpattern(solid dash))
	(line tmp tmp year,
	 lcolor(black black) lpattern(solid dash) connect(direct direct)
	 	      msymbol(D Oh) mcolor(black black)),
	    xtitle(Year) xline(2002, lcolor(black) lpattern(solid))
	    xmlabel(1990(2)2008, labsize(medsmall))
	    xlabel(none) ylabel(, labsize(medsmall))
	    legend(order(7 8) label(7 "Public") label(8 "Catholic"));
     graph export ${figs}fig`f'`p'.eps, replace;
 drop tmp;
 };
 restore;
}; 
*/


***Additional pub/private figs***;
use ${data}pub_prv_data_trends.dta, clear;
keep if year>=1994;

 gen post=year>=2003;
 gen trend=year-1989;
 gen post_trend=post*trend;

 gen log_enr=log(enr_elemwoprek);
 gen tmp=log_enr if year==1994;
 egen tmp2=max(tmp), by(school_type);
 replace log_enr=log_enr-tmp2;

 gen pct_blk_his=pct_blk+pct_his;

 foreach out in log_enr pup_tea pct_blk pct_his pct_blk_his {;
  foreach g in Public Catholic {;
   gen `out'_`g'=`out' if school_type=="`g'";
   *predicted trends, pre- and post-;
   reg `out'_`g' post_trend post trend;
   predict trend_`out'_`g' if e(sample);
  };

   **figure numbering;
    if "`out'"=="log_enr" {; local f=11; local p="a"; };
    if "`out'"=="pup_tea" {; local f=11; local p="b"; };
    if "`out'"=="pct_blk" {; local f=12; local p="a"; };
    if "`out'"=="pct_his" {; local f=12; local p="b"; };
    if "`out'"=="pct_blk_his" {; local f=12; local p="c"; };


 twoway (scatter `out'_Public `out'_Catholic year,
	 msymbol(D Oh) mcolor(black black))
	(line trend_`out'_Public trend_`out'_Catholic year if year<2003,
	 lcolor(black black) lpattern(solid dash))
	(line trend_`out'_Public trend_`out'_Catholic year if year>=2003,
	 lcolor(black black) lpattern(solid dash)),
	    xtitle(Year) xline(2002, lcolor(black) lpattern(dash))
	    xmlabel(1994(2)2008, labsize(medsmall))
	    xlabel(none) ylabel(, labsize(medsmall))
	    legend(order(1 2) label(1 "Public") label(2 "Catholic"));
     graph export ${figs}fig`f'`p'.eps, replace;

 };



log close;
