#delimit;
clear;
capture log close;
set more off;
set mem 1000M;

** FIGURES ***;

log using nclb_figs1_10.log, replace;

insheet using "${data_update}fulldata3_update.txt", names;
save "${data_update}fulldata3_update.dta", replace;

***figures 1-4 - National Public School Attainment***;
 use ${data}fulldata3.dta, clear;
 append using "${data_update}fulldata3_update.dta";

 gen read4=subject=="read"==1&grade==4;
 gen read8=subject=="read"==1&grade==8;
 gen math4=subject=="math"==1&grade==4;
 gen math8=subject=="math"==1&grade==8;

global outcomes "mean";
foreach s in math4 math8 read4 read8 {;
 preserve;
 keep if (type=="Public" | type=="public") & state=="National Public"&`s'==1 &year>1990;

**figure numbering;
 if "`s'"=="math4" local f=1;
 if "`s'"=="read4" local f=2;
 if "`s'"=="math8" local f=3;
 if "`s'"=="read8" local f=4;


*panel d;
 twoway (scatter pct10 pct25 pct75 pct90 year if group=="All students",
 	 connect(direct direct direct direct)
	 lpattern(solid longdash shortdash dash_dot) 
	 lcolor(black black black black)
	 msymbol(O D T S) mcolor(black black black black)),
	    xtitle(Year) xline(2002, lcolor(black) lpattern(solid))
	    xmlabel(1992(2)2010, labsize(medsmall))
	    xlabel(none) ylabel(, labsize(medsmall))
	    legend(label(1 "10th Percentile") label(2 "25th Percentile")
	    		    label(3 "75th Percentile") label(4 "90th Percentile"));
     graph export "${figs}fig`f'd.eps", replace;



*panels a-c;
 drop if group=="All students";
 foreach out of global outcomes {;
  foreach g in Black Hispanic White {;
    gen `out'_`g'=`out' if group=="`g'";
  };

    *figure labels;
    if "`out'"=="mean" local p="a";

     twoway (scatter `out'_Black `out'_Hispanic `out'_White year,
     	     connect(direct direct direct)
     	     lcolor(black black black) mcolor(black black black)
	     lpattern(dot dash solid)  msymbol(Oh X T)),
	    xtitle(Year) xline(2002, lcolor(black) lpattern(solid))
	    xmlabel(1992(2)2010, labsize(medsmall))
	    xlabel(none) ylabel(, labsize(medsmall))
	    ytitle("Scale Score")
	    legend(cols(1) colfirst
	          label(1 "African-American") label(2 "Hispanic") label(3 "White"));
     graph export "${figs}fig`f'`p'.eps", replace;
 };
 restore;
};

***figures 5-8 - National Public School Attainment - LTT***;

insheet using "${data_update}LTT_update.txt", clear names;
save "${data_update}LTT_update.dta", replace;

 use ${data}longterm.dta, clear;
 append using "${data_update}LTT_update.dta";

 gen read9=subject=="read"==1&age==9;
 gen read13=subject=="read"==1&age==13;
 gen math9=subject=="math"==1&age==9;
 gen math13=subject=="math"==1&age==13;

global outcomes "mean";
foreach s in math9 math13 read9 read13 {;
 preserve;
 keep if type=="public" & mod_ass==0 & `s'==1;

**figure numbering;
 if "`s'"=="math9" local f=5;
 if "`s'"=="read9" local f=6;
 if "`s'"=="math13" local f=7;
 if "`s'"=="read13" local f=8;

*panel d;
 twoway (scatter pct10 pct25 pct75 pct90 year if group=="All students",
 	 connect(direct direct direct direct)
	 lpattern(solid longdash shortdash dash_dot) 
	 lcolor(black black black black)
	 msymbol(O D T S) mcolor(black black black black)),
	    xtitle(Year) xline(2002, lcolor(black) lpattern(solid))
	    xmlabel(1974(4)2008, labsize(medsmall))
	    xlabel(none) ylabel(, labsize(medsmall))
	    legend(label(1 "10th Percentile") label(2 "25th Percentile")
	    		    label(3 "75th Percentile") label(4 "90th Percentile"));
     graph export "${figs}fig`f'd.eps", replace;


*panels a-c;
 drop if group=="All students";
 foreach out of global outcomes {;
  foreach g in Black Hispanic White {;
    gen `out'_`g'=`out' if group=="`g'";
  };

    *figure labels;
    if "`out'"=="mean" local p="a";

     twoway (scatter `out'_Black `out'_Hispanic `out'_White year,
     	     connect(direct direct direct)
     	     lcolor(black black black) mcolor(black black black)
	     lpattern(dot dash solid)  msymbol(Oh X T)),
	    xtitle(Year) xline(2002, lcolor(black) lpattern(solid))
	    xmlabel(1974(4)2010, labsize(medsmall))
	    xlabel(none) ylabel(, labsize(medsmall))
	    ytitle("Scale Score")
	    legend(cols(1) colfirst
	          label(1 "African-American") label(2 "Hispanic") label(3 "White"));
     graph export "${figs}fig`f'`p'.eps", replace;
 };
 restore;
};


***Additional pub/private figs***;
use ${data}pub_prv_data_trends.dta, clear;
keep if year>=1994;

 gen post=year>=2003;
 gen trend=year-1989;
 gen post_trend=post*trend;

 gen log_enr=log(enr_elemwoprek);
 gen tmp=log_enr if year==1994;
 egen tmp2=max(tmp), by(school_type);
 replace log_enr=log_enr-tmp2;

 gen pct_blk_his=pct_blk+pct_his;

 foreach out in log_enr pup_tea pct_blk pct_his pct_blk_his {;
  foreach g in Public Catholic {;
   gen `out'_`g'=`out' if school_type=="`g'";
   *predicted trends, pre- and post-;
   reg `out'_`g' post_trend post trend;
   predict trend_`out'_`g' if e(sample);
  };

   **figure numbering;
    if "`out'"=="log_enr" {; local f=11; local p="a"; };
    if "`out'"=="pup_tea" {; local f=11; local p="b"; };
    if "`out'"=="pct_blk" {; local f=12; local p="a"; };
    if "`out'"=="pct_his" {; local f=12; local p="b"; };
    if "`out'"=="pct_blk_his" {; local f=12; local p="c"; };


 twoway (scatter `out'_Public `out'_Catholic year,
	 msymbol(D Oh) mcolor(black black))
	(line trend_`out'_Public trend_`out'_Catholic year if year<2003,
	 lcolor(black black) lpattern(solid dash))
	(line trend_`out'_Public trend_`out'_Catholic year if year>=2003,
	 lcolor(black black) lpattern(solid dash)),
	    xtitle(Year) xline(2002, lcolor(black) lpattern(dash))
	    xmlabel(1994(2)2008, labsize(medsmall))
	    xlabel(none) ylabel(, labsize(medsmall))
	    legend(order(1 2) label(1 "Public") label(2 "Catholic"));
     graph export ${figs}fig`f'`p'.eps, replace;

 };

log close;
