/****************************************************************
insheets race and pared data obtained from NAEP
creates stata data set for merging with nclb analysis data
****************************************************************/

set more off
clear
#delimit;


insheet using g4math_race_edit.csv;
des;
tab year ac_perm, m;
gen grade=4;
gen subject="Math";
destring pct_* se_pct_*, force replace;
sum;
save g4math_race.dta, replace;
clear;

insheet using g4read_race_edit.csv;
des;
tab year ac_perm, m;
gen grade=4;
gen subject="Reading";
destring pct_* se_pct_*, force replace;
sum;
save g4read_race.dta, replace;
clear;

insheet using g8math_race_edit.csv;
des;
tab year ac_perm, m;
gen grade=8;
gen subject="Math";
destring pct_* se_pct_*, force replace;
sum;
save g8math_race.dta, replace;
clear;

insheet using g8read_race_edit.csv;
des;
tab year ac_perm, m;
gen grade=8;
gen subject="Reading";
destring pct_* se_pct_*, force replace;
sum;
save g8read_race.dta, replace;
clear;

insheet using g8math_pared_edit.csv;
des;
tab year ac_perm, m;
gen grade=8;
gen subject="Math";
destring pared_* se_pared_*, force replace;
sum;
save g8math_pared.dta, replace;
clear;

insheet using g8read_pared_edit.csv;
des;
tab year ac_perm, m;
gen grade=8;
gen subject="Reading";
destring pared_* se_pared_*, force replace;
sum;
save g8read_pared.dta, replace;
clear;


use g4read_race.dta;
append using g4math_race.dta;
append using g8read_race.dta;
append using g8math_race.dta;

mmerge year state grade subject ac_perm using g8math_pared.dta, t(1:1);
mmerge year state grade subject ac_perm using g8read_pared.dta, t(1:1) update;
drop _m;

sum;
compress;
des;

save naep_race_pared.dta, replace;

