/*******************************************************************************
cleans economic indicator data from several sources for merge with nclb data;
*******************************************************************************/
#delimit;

*bring in population and hhincome data*;
insheet using ${econ}pop_state.csv, clear;
drop state;
des;
destring pop*, replace ignore(",");
reshape long pop, i(statecode) j(year);
sum;
save ${econ}pop_state.dta, replace;

insheet using ${econ}medianhhinc.csv, clear;
drop state;
des;
reshape long hhinc, i(statecode) j(year);
sum;
*Use most relevant CPI deflator to create hhinc in real terms - 2007 $$ ;
sum hhinc;
replace hhinc=hhinc*207.342/130.7 if year==1990;
replace hhinc=hhinc*207.342/140.3 if year==1992;
replace hhinc=hhinc*207.342/148.2 if year==1994;
replace hhinc=hhinc*207.342/156.9 if year==1996;
replace hhinc=hhinc*207.342/163.0 if year==1998;
replace hhinc=hhinc*207.342/172.2 if year==2000;
replace hhinc=hhinc*207.342/179.9 if year==2002;
replace hhinc=hhinc*207.342/184.0 if year==2003;
replace hhinc=hhinc*207.342/195.3 if year==2005;
sum hhinc;
label var hhinc "median household income 2007 $";
save ${econ}medianhhinc.dta, replace;

*clear unemp data;
use ${econ}unemp_by_state_1976_2008.dta, clear;
destring employment, ignore("(G)") replace;
destring labor_force, ignore("(G)") replace;
destring unemployment, ignore("(G)") replace;
rename state statecode;
save ${econ}tmp_unemp.dta, replace;


***single dataset with all econ measures***;
use ${econ}tmp_unemp.dta, clear;
mmerge statecode year using ${econ}pop_state.dta, t(1:1);
mmerge statecode year using ${econ}medianhhinc.dta, t(1:1);
mmerge statecode year using ${econ}pctpov_1979_to_2007.dta, t(1:1);
rename pctpov povpct;
drop fips_st _m;

des;
tab year;

gen emppop=employment/pop;
gen log_lf=ln(labor_force);
gen log_pop=ln(pop);
gen log_emp=ln(employment);

egen tmpi=group(statecode);
tsset tmpi year;
for any unemprate log_lf log_pop log_emp emppop povpct hhinc: gen X_lag=l.X;
tsset, clear;
drop tmpi;

des;
sum;
compress;
save ${econ}econind.dta, replace;

keep statecode year unemprate_lag log_lf_lag log_pop_lag log_emp_lag emppop_lag
      povpct_lag hhinc_lag;
for any unemprate log_lf log_pop log_emp emppop povpct hhinc: rename X_lag X;
save ${econ}econind_lag.dta, replace;





