#delimit;
clear;
estimates clear;


******************************************************
**** UNEMP SPEC C DROPPING ONE STATE AT A TIME  ******
******************************************************;


log using nclb_unemp_outliers.log, replace;


**create a state-level dataset to save TOT parameters in**; 
use ${data}tmpall.dta, clear;
    keep if type=="Public" & state!="National Public" & state!="National"
         & group=="All"&ac_base==1 & scale=="Composite Scale"&samp==1;
keep statecode;
duplicates drop;
foreach s in math4 math8 read4 read8 {;
 gen TOT_`s'=.;
 gen se_TOT_`s'=.;
};
sort statecode;
save unemp_outliers.dta, replace;
*global of all state names to loop over;
local obs=_N;
global states "";
forval n= 1/`obs' {;
 local tmp=statecode[`n'];
 global states "${states} `tmp'";
};
di "$states";


foreach s in math4 math8 read4 read8 {;
    use ${data}tmpall.dta, clear;
    keep if type=="Public" & state!="National Public" & state!="National"
    	 &`s'==1 & group=="All"&ac_base==1 & scale=="Composite Scale"&samp==1;
    disp "**** SUBJECT `s' ******";
    *whether to use 2000 or 2002 for baseline means;
    local preyr=2000;
    if "`s'"=="read4"|"`s'"=="read8" local preyr=2002;

	gen nyracc=.;
	replace nyracc=11 if yearca==.;
	replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";
        
        gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb03_nyracc=trendnclb03*nyracc;

 foreach state of global states {; 
  preserve;
  di "`state'";
  count if statecode=="`state'";
  if r(N)!=0 {;
   drop if statecode=="`state'";

        areg unemprate
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
        , a(statecode) cl(statecode);

          lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;
	  local TOT=r(estimate);
	  local se_TOT=r(se);

    use unemp_outliers.dta, clear;
    replace TOT_`s'=`TOT' if statecode=="`state'";
    replace se_TOT_`s'=`se_TOT' if statecode=="`state'";
    save unemp_outliers.dta, replace;
  };
   restore;
 };

 use unemp_outliers.dta, clear;
 hist TOT_`s';
 graph export ${figs}hist_TOT_`s'.eps, replace;

};

use unemp_outliers.dta, clear;
sum TOT*;
pwcorr TOT*;
scatter TOT_math4 TOT_math8;
graph export ${figs}TOT_math.eps, replace;
scatter TOT_read4 TOT_read8;
graph export ${figs}TOT_read.eps, replace;


log close;