#delimit;
clear;
estimates clear;



**************************************
**** SUBGROUP FIGURES ******
**************************************;


*global outcomes "mean pct_bsc pct_prof pct_adv pct10 pct25 pct50 pct75 pct90";
global outcomes "mean pct_bsc pct10 pct90";


local count=0;
foreach s in math4 math8 read4 read8 {;
 foreach y of global outcomes {;
  foreach r in Black Hispanic White Male Female Eligible Ineligible {;
   local count=`count'+1;

     disp "**** SUBJECT: `s'    Subgroup: `r' ******";
  use ${data}tmpall.dta, clear;

   if "`y'"=="mean" local ytitle="NAEP scale score";
   if "`y'"=="pct_bsc" local ytitle="Percent meeting basic standards";
   if "`y'"=="pct10" local ytitle="10th percentile NAEP score";
   if "`y'"=="pct90" local ytitle="90th percentile NAEP score";


    keep if type=="Public" & state!="National Public" & state!="National" & `s'==1
    & samp==1 & group!="All" & scale=="Composite Scale" & ac_base==1;

    keep if `y'!=.;
     keep if group=="`r'";


     local i=0;
     gen tmpyr=.;
     forval yr=1990/2007 {;
      count if year==`yr';
      if r(N)!=0 {;
       gen yy_`yr'=year==`yr';
       local i=`i'+1;
       replace tmpyr=`yr' if _n==`i';
      };
     };
     sum year; local min=r(min); drop yy_`min'; local minp1=`min'+1;


  *raw means;
     reg `y' yy_* if yearca>=1994&yearca<=1998, cl(statecode);
     gen meanraw9498=_b[_cons] if tmpyr==`min';
     forval yr=`minp1'/2007 {;
      count if year==`yr';
      if r(N)!=0 replace meanraw9498=_b[_cons]+_b[yy_`yr'] if tmpyr==`yr';
     };
     reg `y' yy_* if yearca>=1999&yearca<=2001, cl(statecode);
     gen meanraw9901=_b[_cons] if tmpyr==`min';
     forval yr=`minp1'/2007 {;
      count if year==`yr';
      if r(N)!=0 replace meanraw9901=_b[_cons]+_b[yy_`yr'] if tmpyr==`yr';
     };
     reg `y' yy_* if yearca==., cl(statecode);
     gen meanrawdot=_b[_cons] if tmpyr==`min';
     forval yr=`minp1'/2007 {;
      count if year==`yr';
      if r(N)!=0 replace meanrawdot=_b[_cons]+_b[yy_`yr'] if tmpyr==`yr';
     };
   *trend lines;
     areg `y' trend trendnclb03 nclb03
      if yearca>=1994&yearca<=1998, a(statecode) cl(statecode);
      predict meanhat9498, xb;
     areg `y' trend trendnclb03 nclb03
      if yearca>=1999&yearca<=2001, a(statecode) cl(statecode);
      predict meanhat9901, xb;
     areg `y' trend trendnclb03 nclb03
      if yearca==., a(statecode) cl(statecode);
      predict meanhatdot, xb;

     preserve;
     keep tmpyr meanraw9498 meanraw9901 meanrawdot;
     keep if tmpyr!=.;
     save tmp.dta, replace;
     restore;


     keep year meanhat9498 meanhat9901 meanhatdot;
     duplicates drop;
     tab year;


     append using tmp.dta;
     erase tmp.dta;


     twoway (line meanhat9498 meanhatdot year if year<2003,
             lcolor(black black black) mcolor(black black black)
             lpattern(dash solid)
             lwidth(medium medium medium))
            (line meanhat9498 meanhatdot year if year>=2003,
             lcolor(black black black) mcolor(black black black)
             lpattern(dash solid)
             lwidth(medium medium medium))
            (scatter meanraw9498 meanrawdot tmpyr,
             mcolor(black black black) msymbol(Oh T)),
            xtitle(Year) xline(2002, lcolor(black)) ytitle(`ytitle')
            xmlabel(1992(2)2008, labsize(medsmall))
            xlabel(none) ylabel(, labsize(medsmall))
            legend(order(5 6 1 2) cols(1) colfirst
                   label(5 "State adopted school acct. policy by 1998")
                     label(6 "State never adopted school acct. policy before NCLB")
                  label(1 "State adopted school acct. policy by 1998 linear trend")
        label(2 "State never adopted school acct. policy before NCLB linear trend"))
	title("Subject: `s' Subgroup: `r'");
     graph export ${figs}fig_`y'_`s'_`r'.eps, replace;

  if `count'==2 {;
     !cat ${figs}fig_mean_math4_Black.eps ${figs}fig_`y'_`s'_`r'.eps > ${figs}tmp2.eps;
     !rm ${figs}fig_mean_math4_Black.eps ${figs}fig_`y'_`s'_`r'.eps -f;
  };
  if `count'>=3 {;
     local tmp=`count'-1;
     !cat ${figs}tmp`tmp'.eps ${figs}fig_`y'_`s'_`r'.eps > ${figs}tmp`count'.eps;
     !rm ${figs}tmp`tmp'.eps ${figs}fig_`y'_`s'_`r'.eps -f;
  };

   clear;
  };
 };
};







