#delimit;
clear;
estimates clear;



**************************************
**** BY RACE CHECKS ******
**************************************;

log using nclb_race.log, replace;

*global outcomes "mean pct_bsc pct_prof pct_adv pct10 pct25 pct50 pct75 pct90";
global outcomes "mean pct_bsc pct10 pct90";


foreach s in math4 math8 read4 read8 {;

 foreach y of global outcomes {;


if "`s'"=="math4"|"`s'"=="read4"
 global sycov "excl  povpct povpct_sq excl_sq
          ipct_fl pct_black pct_hisp pct_white mm_race
          unemprate unemprate_sq";

if "`s'"=="math8"|"`s'"=="read8"
 global sycov "excl  povpct povpct_sq excl_sq
          ipct_fl pct_black pct_hisp pct_white mm_race
          pared_1 pared_2 pared_3
          unemprate unemprate_sq";


  use ${data}tmpall.dta, clear;

    keep if type=="Public" & state!="National Public" & state!="National" & `s'==1
    & samp==1 & group!="All" & scale=="Composite Scale" & ac_base==1;
    *whether to use 2000 or 2002 for baseline means;
    local preyr=2000;
    if "`s'"=="read4"|"`s'"=="read8" local preyr=2002;

    keep if `y'!=.;

/*
*Determine which states have data on all of the race groups;
 tab year group;
 egen tmp=group(group);
 egen nrace=nvals(tmp), by(statecode year);
 tab group nrace, m;

     keep if nrace==3;
 drop tmp nrace;

 *also check limited sample;
 egen tmp=group(group) if exca9901==0;
 egen nrace=nvals(tmp), by(statecode year);
 tab group nrace, m;
 gen insamp_exca9901=exca9901==0&nrace==3;
 drop tmp nrace;
*/

        gen noacc=yearca>1998|yearca==.;
        gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb03_noacc=trendnclb03*noacc;

        gen nyracc=.;
        replace nyracc=11 if yearca==.;
        replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";
        
        gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb03_nyracc=trendnclb03*nyracc;

        for any 2003 2005 2007: gen yy_X=year==X \ gen yy_X_noacc=yy_X*noacc;
        for any 2003 2005 2007: gen yy_X_nyracc=yy_X*nyracc;



  foreach r in Black Hispanic White Male Female Eligible Ineligible {;

     disp "**** SUBJECT `s'    Race `r' ******";
     preserve;
     keep if group=="`r'";

/*
     capture noisily areg `y' noacc trend trend_noacc trendnclb03 trendnclb03_noacc
         nclb03 nclb03_noacc curexp povpct excl curexp_sq povpct_sq excl_sq
                 if exca9901==0, a(statecode) cl(statecode);

        estimates store `s'_`r'_A1;
          capture noisily lincom nclb03_noacc + 5*trendnclb03_noacc;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

     capture noisily areg `y'
        noacc trend trend_noacc
        yy_2003 yy_2005 yy_2007   yy_2003_noacc yy_2005_noacc yy_2007_noacc
        curexp povpct excl curexp_sq povpct_sq excl_sq if exca9901==0,
                a(statecode) cl(statecode);

        estimates store `s'_`r'_A2;
*/
     capture noisily areg `y'
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
	${sycov}, a(statecode) cl(statecode);

        estimates store `s'_`r'_`y';
          qui sum `y' if yearca==.&year==`preyr' & e(sample);
                   estadd scalar basemn=r(mean);
            disp "*** Effect of NCLB for state that never had any pre-accountability
            relative to a state that had pre-accountability by 97 ***";
            disp "** effect as of 2007 **";
            capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;
            estadd scalar TOT = r(estimate);
            estadd scalar TOTse=r(se);
            estadd scalar TOTt = r(estimate)/r(se);

/*
     capture noisily areg `y'
        nyracc trend trend_nyracc
        yy_2003 yy_2005 yy_2007 yy_2003_nyracc yy_2005_nyracc yy_2007_nyracc
	curexp povpct excl curexp_sq povpct_sq excl_sq,
	       a(statecode) cl(statecode);

	       estimates store `s'_`r'_B2;
*/

***WEIGHTED***;
/*
     capture noisily areg `y' noacc trend trend_noacc trendnclb03 trendnclb03_noacc
         nclb03 nclb03_noacc curexp povpct excl curexp_sq povpct_sq excl_sq
                 [aw=enrollment] if exca9901==0, a(statecode) cl(statecode);

        estimates store w`s'_`r'_A1;
          capture noisily lincom nclb03_noacc + 5*trendnclb03_noacc;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

     capture noisily areg `y'
        noacc trend trend_noacc
        yy_2003 yy_2005 yy_2007   yy_2003_noacc yy_2005_noacc yy_2007_noacc
        curexp povpct excl curexp_sq povpct_sq excl_sq [aw=enrollment] if exca9901==0,
                a(statecode) cl(statecode);

        estimates store w`s'_`r'_A2;
*/
     capture noisily areg `y'
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
	${sycov} [aw=enrollment], a(statecode) cl(statecode);

        estimates store w`s'_`r'_`y';
          qui sum `y' [aw=enrollment] if yearca==.&year==`preyr' & e(sample);
                   estadd scalar basemn=r(mean);
            disp "*** Effect of NCLB for state that never had any pre-accountability
            relative to a state that had pre-accountability by 98 ***";
            disp "** effect as of 2007 **";
            capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;
            estadd scalar TOT = r(estimate);
            estadd scalar TOTse=r(se);
            estadd scalar TOTt = r(estimate)/r(se);

/*
     capture noisily areg `y'
        nyracc trend trend_nyracc
        yy_2003 yy_2005 yy_2007 yy_2003_nyracc yy_2005_nyracc yy_2007_nyracc
	curexp povpct excl curexp_sq povpct_sq excl_sq [aw=enrollment],
	       a(statecode) cl(statecode);

	       estimates store w`s'_`r'_B2;
*/
    restore;
   };

/*
   if "`y'"=="mean"
     estout `s'_* w`s'_*
       using ${tabs}nclb_race_`s'.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_noacc trendnclb03_noacc yy_2003_noacc yy_2005_noacc yy_2007_noacc
       nclb03_nyracc trendnclb03_nyracc yy_2003_nyracc yy_2005_nyracc yy_2007_nyracc)
       order(nclb03_noacc trendnclb03_noacc yy_2003_noacc yy_2005_noacc yy_2007_noacc
       nclb03_nyracc trendnclb03_nyracc yy_2003_nyracc yy_2005_nyracc yy_2007_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(N_clust N TOT TOTse TOTt, fmt(0 0 3 3 3) layout(@ @ @ `"(@)"' @));
*/

 };


     estout `s'_Wh* w`s'_Wh* `s'_Bl* w`s'_Bl* `s'_Hi* w`s'_Hi*
     	    `s'_Ma* w`s'_Ma* `s'_Fe* w`s'_Fe*
	    `s'_El* w`s'_El* `s'_In* w`s'_In*
       using ${tabs}nclb_race_`s'_cov.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_nyracc trendnclb03_nyracc)
       order(nclb03_nyracc trendnclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse TOTt basemn N_clust N, fmt(3 3 2 0 0 0)
                  layout(@ `"(@)"' @ @ @ @));
	estimates clear;

};

/*
     estout read4_Wh* wread4_Wh* read4_Bl* wread4_Bl* read4_Hi* wread4_Hi*
     	    read4_Ma* wread4_Ma* read4_Fe* wread4_Fe*
	    read4_El* wread4_El* read4_In* wread4_In*
     	    read8_Wh* wread8_Wh* read8_Bl* wread8_Bl* read8_Hi* wread8_Hi*
     	    read8_Ma* wread8_Ma* read8_Fe* wread8_Fe*
	    read8_El* wread8_El* read8_In* wread8_In*
       using ${tabs}nclb_race_read.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_nyracc trendnclb03_nyracc)
       order(nclb03_nyracc trendnclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse TOTt basemn N_clust N, fmt(3 3 3 3 0 0)
                  layout(@ `"(@)"' @ @ @ @));
       estimates clear;
*/

log close;



