#delimit;
clear;
estimates clear;


**************************************
**** FALSIFICATION TESTS ******
**************************************;


log using nclb_false.log, replace;


program define nclb_false;

preserve;
   disp "*** PANEL A: CA by 2001, no exclusions ***";
        gen noacc=yearca>2001|yearca==.;
        gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb03_noacc=trendnclb03*noacc;

        capture noisily areg `3' noacc trend trend_noacc trendnclb03 trendnclb03_noacc
                 nclb03 nclb03_noacc if samp==1, a(statecode) cl(statecode);

          estimates store `1'_F`2'a;

          qui sum `3' if yearca==.&year==`4' & e(sample);
          estadd scalar basemn=r(mean);
          estadd scalar basesd=r(sd);

          capture noisily lincom nclb03_noacc + 5*trendnclb03_noacc;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

          drop noacc nclb03_noacc trend_noacc trendnclb03_noacc;


    disp "*** PANEL B:  CA by 1998, exclude CA 99-01 ***";
        gen noacc=yearca>1998|yearca==.;
        gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb03_noacc=trendnclb03*noacc;

        capture noisily areg `3' noacc trend trend_noacc trendnclb03 trendnclb03_noacc
         nclb03 nclb03_noacc if exca9901==0&samp==1, a(statecode) cl(statecode);

          estimates store `1'_F`2'b;

          qui sum `3' if yearca==.&year==`4' & e(sample);
          estadd scalar basemn=r(mean);
          estadd scalar basesd=r(sd);

          capture noisily lincom nclb03_noacc + 5*trendnclb03_noacc;
          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

          drop noacc nclb03_noacc trend_noacc trendnclb03_noacc;


     disp "*** PANEL C:  CA interacted with year ***";
	gen nyracc=.;
	replace nyracc=11 if yearca==.;
	replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state was without CA prior to 2002 ";
        
        gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb03_nyracc=trendnclb03*nyracc;

        capture noisily areg `3'
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
        if samp==1, a(statecode) cl(statecode);

          estimates store `1'_F`2'c;

          qui sum `3' if yearca==.&year==`4' & e(sample);
          estadd scalar basemn=r(mean);
          estadd scalar basesd=r(sd);

        disp "*** Effect of NCLB for state that never had any pre-accountability
          relative to a state that had pre-accountability by 97 ***";
             disp "** effect as of 2007 **";

          capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;

          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

restore;
end;


*program to run models with outcomes only available for 1994 2000 and 2003; 
*only runs panel C estimates;
program define nclb_false2;

    use ${data}tmpall.dta, clear;
    keep if type=="Public" & state!="National Public" & state!="National"
    	 &group=="All"&ac_base==1 & scale=="Composite Scale";

    *run on sample of states from main set of results for subject/grade;
    gen tmp=samp==1&`1'==1;
    egen tmp2=max(tmp), by(state);
    keep if tmp2==1 & `3'!=.;
    drop tmp tmp2;
    egen tag=tag(state year);
    keep if tag==1;

    disp "**** SUBJECT `s' ******";

        gen noacc=yearca>1998|yearca==.;
	gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
	gen      trendnclb03_noacc=trendnclb03*noacc;

        gen nyracc=.;
	replace nyracc=11 if yearca==.;
        replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";

	gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
	gen      trendnclb03_nyracc=trendnclb03*nyracc;

        capture noisily areg `3'
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
        if samp==1, a(statecode) cl(statecode);

          estimates store `1'_F`2';

          qui sum `3' if yearca==.&year==`4' & e(sample);
          estadd scalar basemn=r(mean);
          estadd scalar basesd=r(sd);

        disp "*** Effect of NCLB for state that never had any pre-accountability
          relative to a state that had pre-accountability by 97 ***";
             disp "** effect as of 2007 **";

          capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;

          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

end;



*means for bottom row of table;

use ${data}tmpall.dta, clear;
  gen ln_curexp=log(curexp);
  keep if type=="Public" & state!="National Public" & state!="National"&group=="All"
       &samp==1&yearca==.&year==2000&ac_base==1& scale=="Composite Scale";
  egen tags=tag(statecode);
foreach out in povpct ln_curexp pup_tea ipct_blk ipct_his ipct_wht {;
          sum `out' if tags==1;
};



foreach s in math4 math8 read4 read8 {;
    use ${data}tmpall.dta, clear;
    keep if type=="Public" & state!="National Public" & state!="National"
    	 &`s'==1 & group=="All"&ac_base==1 & scale=="Composite Scale";
    disp "**** SUBJECT `s' ******";
    *whether to use 2000 or 2002 for baseline means;
    local preyr=2000;
    if "`s'"=="read4"|"`s'"=="read8" local preyr=2002;

  disp "*** out==ln_curexp - Column 1 ***";
  gen ln_curexp=log(curexp);
  nclb_false `s' 1 ln_curexp `preyr';

  disp "*** out==pup_tea - Column 2 ***";
  nclb_false `s' 2 pup_tea `preyr';

  disp "*** out==exc. rate - Column 3 ***";
  nclb_false `s' 3 excl `preyr';

  disp "*** out==povpct - Column 4 ***";
  nclb_false `s' 4 povpct `preyr';

  disp "*** out==unemp - Column 5 ***";
  nclb_false `s' 5 unemprate `preyr';

  disp "*** out==%race - Columns 6-8 ***";
  for var pct_black pct_hisp pct_white: replace X=. if mm_race==1;

  nclb_false `s' 6 pct_black `preyr';
  nclb_false `s' 7 pct_hisp `preyr';
  nclb_false `s' 8 pct_white `preyr';
/*
  nclb_false `s' 6b ipct_blk `preyr';
  nclb_false `s' 7b ipct_his `preyr';
  nclb_false `s' 8b ipct_wht `preyr';
*/

  disp "*** out==free lunch - Column 9 ***";
  nclb_false `s' 9 ipct_fl `preyr';

  if "`s'"=="math8"|"`s'"=="read8" {;
   disp "*** out==% in state-year lths or hs - Column 8 ***";
   nclb_false `s' 10 pared_1 `preyr';
   disp "*** out==% in state-year some college + - Column 9 ***";
   nclb_false `s' 11 pared_2 `preyr';
   disp "*** out==% in state-year BA+ - Column 9 ***";
   nclb_false `s' 12 pared_3 `preyr';
   disp "*** out==% in state-year don't know. - Column 9 ***";
   nclb_false `s' 13  pared_dk `preyr';
  };

  disp "*** out==% in state-year with HS or more - Column 8 ***";
  nclb_false `s' 10b phsplus `preyr';
  disp "*** out==% in state-year with BA or more - Column 9 ***";
  nclb_false `s' 11b pbaplus `preyr';

  for var frac_pub frac_fulldayk_mavg frac_prek_mavg: replace X=. if mm_X==1;
  nclb_false `s' 14 frac_pub `preyr';
  nclb_false `s' 15 frac_fulldayk_mavg `preyr';
  nclb_false `s' 16 frac_prek_mavg `preyr';

/*
  disp "*** out==teacher chars - Column 17-24 ***";
  local c=16;
  foreach out in ptchba ptchma ptchsped ptchphd ptchexplt3 ptchexp39
  	   ptchexp1020 ptchexpgt20 {;
   local c=`c'+1;
   nclb_false2 `s' `c' `out' 2000;
  };
*/

};

/*
     estout math4_F* math8_F* read4_F* read8_F* 
       using ${tabs}nclb_false_full.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_nyracc trendnclb03_nyracc)
       order(nclb03_nyracc trendnclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse basemn TOTt basesd N_clust N, fmt(3 3 3 3 3 0 0)
        layout(@ `"(@)"' `"[@]"' @ @ @ @));
*/


foreach p in a b {; 
     estout math4_F3`p' math4_F4`p' math4_F5`p' math4_F14`p' math4_F6`p' math4_F7`p'
     	    	      math4_F9`p' math4_F15`p' math4_F16`p'
            math8_F3`p' math8_F4`p' math8_F5`p' math8_F14`p' math8_F6`p' math8_F7`p'
	    	      math8_F9`p' math8_F12`p' math8_F15`p' math8_F16`p'
	    read4_F3`p' read4_F4`p' read4_F5`p' read4_F14`p' read4_F6`p' read4_F7`p'
	    	      read4_F9`p' read4_F15`p' read4_F16`p'
	    read8_F3`p' read8_F4`p' read8_F5`p' read8_F14`p' read8_F6`p' read8_F7`p'
	    	      read8_F9`p' read8_F12`p' read8_F15`p' read8_F16`p'
       using ${tabs}nclb_false`p'.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_noacc trendnclb03_noacc)
       order(nclb03_noacc trendnclb03_noacc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse basemn TOTt basesd N_clust N, fmt(3 3 3 3 3 0 0)
        layout(@ `"(@)"' `"[@]"' @ @ @ @));
};
     estout math4_F3c math4_F4c math4_F5c math4_F14c math4_F6c math4_F7c
     	    	      math4_F9c math4_F15c math4_F16c
            math8_F3c math8_F4c math8_F5c math8_F14c math8_F6c math8_F7c
	    	      math8_F9c math8_F12c math8_F15c math8_F16c
	    read4_F3c read4_F4c read4_F5c read4_F14c read4_F6c read4_F7c
	    	      read4_F9c read4_F15c read4_F16c
	    read8_F3c read8_F4c read8_F5c read8_F14c read8_F6c read8_F7c
	    	      read8_F9c read8_F12c read8_F15c read8_F16c
       using ${tabs}nclb_falsec.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_nyracc trendnclb03_nyracc)
       order(nclb03_nyracc trendnclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse basemn TOTt basesd N_clust N, fmt(3 3 3 3 3 0 0)
        layout(@ `"(@)"' `"[@]"' @ @ @ @));


       estimates clear;



log close;