#delimit;
clear;
estimates clear;


**************************************
**** FALSIFICATION TESTS ******
**************************************;


log using nclb_false.log, replace;


program define nclb_false;

        capture noisily areg `3'
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
        if samp==1, a(statecode) cl(statecode);

          estimates store `1'_F`2';

          qui sum `3' if yearca==.&year==`4' & e(sample);
          estadd scalar basemn=r(mean);
          estadd scalar basesd=r(sd);

        disp "*** Effect of NCLB for state that never had any pre-accountability
          relative to a state that had pre-accountability by 97 ***";
             disp "** effect as of 2007 **";

          capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;

          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

        capture noisily areg `3'
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
        if samp==1 [aw=enrollment], a(statecode) cl(statecode);

          estimates store `1'_F`2'w;

          qui sum `3' if yearca==.&year==`4' & e(sample);
          estadd scalar basemn=r(mean);
          estadd scalar basesd=r(sd);

        disp "*** Effect of NCLB for state that never had any pre-accountability
          relative to a state that had pre-accountability by 97 ***";
             disp "** effect as of 2007 **";

          capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;

          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

end;


*program to run models with outcomes only available for 1994 2000 and 2003; 
program define nclb_false2;

    use ${data}tmpall.dta, clear;
    keep if type=="Public" & state!="National Public" & state!="National"
    	 &group=="All"&ac_base==1 & scale=="Composite Scale";

    *run on sample of states from main set of results for subject/grade;
    gen tmp=samp==1&`1'==1;
    egen tmp2=max(tmp), by(state);
    keep if tmp2==1 & `3'!=.;
    drop tmp tmp2;
    egen tag=tag(state year);
    keep if tag==1;

    disp "**** SUBJECT `s' ******";

        gen noacc=yearca>1998|yearca==.;
	gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
	gen      trendnclb03_noacc=trendnclb03*noacc;

        gen nyracc=.;
	replace nyracc=11 if yearca==.;
        replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";

	gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
	gen      trendnclb03_nyracc=trendnclb03*nyracc;

        capture noisily areg `3'
        nyracc trend trend_nyracc trendnclb03 trendnclb03_nyracc nclb03 nclb03_nyracc
        if samp==1, a(statecode) cl(statecode);

          estimates store `1'_F`2';

          qui sum `3' if yearca==.&year==`4' & e(sample);
          estadd scalar basemn=r(mean);
          estadd scalar basesd=r(sd);

        disp "*** Effect of NCLB for state that never had any pre-accountability
          relative to a state that had pre-accountability by 97 ***";
             disp "** effect as of 2007 **";

          capture noisily lincom nclb03_nyracc*6 + 30*trendnclb03_nyracc ;

          estadd scalar TOT = r(estimate);
          estadd scalar TOTse=r(se);
          estadd scalar TOTt = r(estimate)/r(se);

end;



*means for bottom row of table;

use ${data}tmpall.dta, clear;
  gen ln_curexp=log(curexp);
  keep if type=="Public" & state!="National Public" & state!="National"&group=="All"
       &samp==1&yearca==.&year==2000&ac_base==1& scale=="Composite Scale";
  egen tags=tag(statecode);
foreach out in povpct ln_curexp pup_tea ipct_blk ipct_his ipct_wht {;
          sum `out' if tags==1;
};



foreach s in math4 math8 read4 read8 {;
    use ${data}tmpall.dta, clear;
    keep if type=="Public" & state!="National Public" & state!="National"
    	 &`s'==1 & group=="All"&ac_base==1 & scale=="Composite Scale";
    disp "**** SUBJECT `s' ******";
    *whether to use 2000 or 2002 for baseline means;
    local preyr=2000;
    if "`s'"=="read4"|"`s'"=="read8" local preyr=2002;

        gen noacc=yearca>1998|yearca==.;
        gen nclb03_noacc=noacc*nclb03;
        gen      trend_noacc=trend*noacc;
        gen      trendnclb03_noacc=trendnclb03*noacc;

	gen nyracc=.;
	replace nyracc=11 if yearca==.;
	replace nyracc=yearca-1992 if yearca~=.;
        label var nyracc "# years state had CA prior to 2002 ";
        
        gen nclb03_nyracc=nyracc*nclb03;
        gen      trend_nyracc=trend*nyracc;
        gen      trendnclb03_nyracc=trendnclb03*nyracc;


  disp "*** out==ln_curexp - Column 1 ***";
  gen ln_curexp=log(curexp);
  nclb_false `s' 1 ln_curexp `preyr';

  disp "*** out==pup_tea - Column 2 ***";
  nclb_false `s' 2 pup_tea `preyr';

  disp "*** out==exc. rate - Column 3 ***";
  nclb_false `s' 3 excl `preyr';

  disp "*** out==povpct - Column 4 ***";
  nclb_false `s' 4 povpct `preyr';

  disp "*** out==unemp - Column 5 ***";
  nclb_false `s' 5 unemprate `preyr';

  disp "*** out==%race - Columns 6-8 ***";
  for var pct_black pct_hisp pct_white: replace X=. if mm_race==1;

  nclb_false `s' 6 pct_black `preyr';
  nclb_false `s' 7 pct_hisp `preyr';
  nclb_false `s' 8 pct_white `preyr';
/*
  nclb_false `s' 6b ipct_blk `preyr';
  nclb_false `s' 7b ipct_his `preyr';
  nclb_false `s' 8b ipct_wht `preyr';
*/

  disp "*** out==free lunch - Column 9 ***";
  replace ipct_fl=ipct_fl*100;
  nclb_false `s' 9 ipct_fl `preyr';

  if "`s'"=="math8"|"`s'"=="read8" {;
   disp "*** out==% in state-year lths or hs - Column 8 ***";
   nclb_false `s' 10 pared_1 `preyr';
   disp "*** out==% in state-year some college + - Column 9 ***";
   nclb_false `s' 11 pared_2 `preyr';
   disp "*** out==% in state-year BA+ - Column 9 ***";
   nclb_false `s' 12 pared_3 `preyr';
   disp "*** out==% in state-year don't know. - Column 9 ***";
   nclb_false `s' 13  pared_dk `preyr';
  };

  disp "*** out==% in state-year with HS or more - Column 8 ***";
  nclb_false `s' 10b phsplus `preyr';
  disp "*** out==% in state-year with BA or more - Column 9 ***";
  nclb_false `s' 11b pbaplus `preyr';

  for var frac_pub frac_fulldayk_mavg frac_prek_mavg:
   replace X=. if mm_X==1 \
   replace X=X*100;
  nclb_false `s' 14 frac_pub `preyr';
  nclb_false `s' 15 frac_fulldayk_mavg `preyr';
  nclb_false `s' 16 frac_prek_mavg `preyr';

  disp "*** out== hhinc, emppop  ***";
  nclb_false `s' 17 hhinc `preyr';
  nclb_false `s' 18 emppop `preyr';
  nclb_false `s' 19 log_lf `preyr';
  nclb_false `s' 20 log_emp `preyr';
  nclb_false `s' 21 log_pop `preyr';
  gen log_unemp=log(unemprate/100);
  nclb_false `s' 22 log_unemp `preyr';

  disp "*** out==teacher chars - Column 23-30 ***";
  local c=22;
  foreach out in ptchba ptchma ptchsped ptchphd ptchexplt3 ptchexp39
  	   ptchexp1020 ptchexpgt20 {;
   local c=`c'+1;
   nclb_false2 `s' `c' `out' 2000;
  };

};

     estout math4_F3 math4_F4 math4_F17 math4_F18 math4_F14 math4_F6
     	    	      math4_F7 math4_F9 math4_F15 math4_F16 math4_F17
		      math4_F18 math4_F19 math4_F20 math4_F21
	    math8_F3 math8_F4 math8_F17 math8_F18 math8_F14 math8_F6
                      math8_F7 math8_F9 math8_F15 math8_F16 math8_F17
                      math8_F18 math8_F19 math8_F20 math8_F21
	    read4_F3 read4_F4 read4_F17 read4_F18 read4_F14 read4_F6
     	    	      read4_F7 read4_F9 read4_F15 read4_F16 read4_F17
		      read4_F18 read4_F19 read4_F20 read4_F21
	    read8_F3 read8_F4 read8_F17 read8_F18 read8_F14 read8_F6
                      read8_F7 read8_F9 read8_F15 read8_F16 read8_F17
                      read8_F18 read8_F19 read8_F20 read8_F21
       using ${tabs}nclb_false.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_nyracc trendnclb03_nyracc)
       order(nclb03_nyracc trendnclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse basemn TOTt basesd N_clust N, fmt(3 3 3 3 3 0 0)
        layout(@ `"(@)"' `"[@]"' @ @ @ @));


     estout math4_F4 math4_F5 math4_F17 math4_F18  math4_F19 math4_F20 math4_F21
math4_F22
	    math8_F4 math8_F5 math8_F17 math8_F18  math8_F19 math8_F20 math8_F21
math8_F22
	    read4_F4 read4_F5 read4_F17 read4_F18  read4_F19 read4_F20 read4_F21
read4_F22
	    read8_F4 read8_F5 read8_F17 read8_F18  read8_F19 read8_F20 read8_F21
read8_F22
	    math4_F4w math4_F5w math4_F17w math4_F18w  math4_F19w math4_F20w math4_F21w
math4_F22w
	    math8_F4w math8_F5w math8_F17w math8_F18w  math8_F19w math8_F20w math8_F21w
math8_F22w
	    read4_F4w read4_F5w read4_F17w read4_F18w  read4_F19w read4_F20w read4_F21w
read4_F22w
	    read8_F4w read8_F5w read8_F17w read8_F18w  read8_F19w read8_F20w read8_F21w
read8_F22w
       using ${tabs}nclb_false_wgt.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_nyracc trendnclb03_nyracc)
       order(nclb03_nyracc trendnclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse basemn TOTt basesd N_clust N, fmt(3 3 3 3 3 0 0)
        layout(@ `"(@)"' `"[@]"' @ @ @ @));


estimates drop *w;
     estout math4_F* math8_F* read4_F* read8_F* 
       using ${tabs}nclb_false_full.txt,
       cells(b(star fmt(3)) se(par)) replace
       keep(nclb03_nyracc trendnclb03_nyracc)
       order(nclb03_nyracc trendnclb03_nyracc)
       starlevels(* 0.10 ** 0.05)
       stats(TOT TOTse basemn TOTt basesd N_clust N, fmt(3 3 3 3 3 0 0)
        layout(@ `"(@)"' `"[@]"' @ @ @ @));


       estimates clear;



log close;